/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ResourceIntegrations;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Resource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Resource> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Resource.getter(Resource::name)).setter(Resource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Resource.getter(Resource::arn)).setter(Resource.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> ASSOCIATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("associationTime").getter(Resource.getter(Resource::associationTime)).setter(Resource.setter(Builder::associationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<ResourceIntegrations> INTEGRATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("integrations").getter(Resource.getter(Resource::integrations)).setter(Resource.setter(Builder::integrations)).constructor(ResourceIntegrations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, ASSOCIATION_TIME_FIELD, INTEGRATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("arn", ARN_FIELD);
            this.put("associationTime", ASSOCIATION_TIME_FIELD);
            this.put("integrations", INTEGRATIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final Instant associationTime;
    private final ResourceIntegrations integrations;

    private Resource(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.associationTime = builder.associationTime;
        this.integrations = builder.integrations;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant associationTime() {
        return this.associationTime;
    }

    public final ResourceIntegrations integrations() {
        return this.integrations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrations());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.associationTime(), other.associationTime()) && Objects.equals(this.integrations(), other.integrations());
    }

    public final String toString() {
        return ToString.builder((String)"Resource").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("AssociationTime", (Object)this.associationTime()).add("Integrations", (Object)this.integrations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "associationTime": {
                return Optional.ofNullable(clazz.cast(this.associationTime()));
            }
            case "integrations": {
                return Optional.ofNullable(clazz.cast(this.integrations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private Instant associationTime;
        private ResourceIntegrations integrations;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            this.name(model.name);
            this.arn(model.arn);
            this.associationTime(model.associationTime);
            this.integrations(model.integrations);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getAssociationTime() {
            return this.associationTime;
        }

        public final void setAssociationTime(Instant associationTime) {
            this.associationTime = associationTime;
        }

        @Override
        public final Builder associationTime(Instant associationTime) {
            this.associationTime = associationTime;
            return this;
        }

        public final ResourceIntegrations.Builder getIntegrations() {
            return this.integrations != null ? this.integrations.toBuilder() : null;
        }

        public final void setIntegrations(ResourceIntegrations.BuilderImpl integrations) {
            this.integrations = integrations != null ? integrations.build() : null;
        }

        @Override
        public final Builder integrations(ResourceIntegrations integrations) {
            this.integrations = integrations;
            return this;
        }

        public Resource build() {
            return new Resource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Resource> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder associationTime(Instant var1);

        public Builder integrations(ResourceIntegrations var1);

        default public Builder integrations(Consumer<ResourceIntegrations.Builder> integrations) {
            return this.integrations((ResourceIntegrations)((ResourceIntegrations.Builder)ResourceIntegrations.builder().applyMutation(integrations)).build());
        }
    }
}

