/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AssociationOption;
import software.amazon.awssdk.services.servicecatalogappregistry.model.OptionsCopier;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ResourceDetails;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceInfo> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ResourceInfo.getter(ResourceInfo::name)).setter(ResourceInfo.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ResourceInfo.getter(ResourceInfo::arn)).setter(ResourceInfo.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(ResourceInfo.getter(ResourceInfo::resourceTypeAsString)).setter(ResourceInfo.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<ResourceDetails> RESOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceDetails").getter(ResourceInfo.getter(ResourceInfo::resourceDetails)).setter(ResourceInfo.setter(Builder::resourceDetails)).constructor(ResourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceDetails").build()}).build();
    private static final SdkField<List<String>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("options").getter(ResourceInfo.getter(ResourceInfo::optionsAsStrings)).setter(ResourceInfo.setter(Builder::optionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_DETAILS_FIELD, OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("arn", ARN_FIELD);
            this.put("resourceType", RESOURCE_TYPE_FIELD);
            this.put("resourceDetails", RESOURCE_DETAILS_FIELD);
            this.put("options", OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String resourceType;
    private final ResourceDetails resourceDetails;
    private final List<String> options;

    private ResourceInfo(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.resourceType = builder.resourceType;
        this.resourceDetails = builder.resourceDetails;
        this.options = builder.options;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final ResourceDetails resourceDetails() {
        return this.resourceDetails;
    }

    public final List<AssociationOption> options() {
        return OptionsCopier.copyStringToEnum(this.options);
    }

    public final boolean hasOptions() {
        return this.options != null && !(this.options instanceof SdkAutoConstructList);
    }

    public final List<String> optionsAsStrings() {
        return this.options;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptions() ? this.optionsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceInfo)) {
            return false;
        }
        ResourceInfo other = (ResourceInfo)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceDetails(), other.resourceDetails()) && this.hasOptions() == other.hasOptions() && Objects.equals(this.optionsAsStrings(), other.optionsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceInfo").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceDetails", (Object)this.resourceDetails()).add("Options", this.hasOptions() ? this.optionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "resourceDetails": {
                return Optional.ofNullable(clazz.cast(this.resourceDetails()));
            }
            case "options": {
                return Optional.ofNullable(clazz.cast(this.optionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourceInfo, T> g) {
        return obj -> g.apply((ResourceInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String resourceType;
        private ResourceDetails resourceDetails;
        private List<String> options = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceInfo model) {
            this.name(model.name);
            this.arn(model.arn);
            this.resourceType(model.resourceType);
            this.resourceDetails(model.resourceDetails);
            this.optionsWithStrings(model.options);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final ResourceDetails.Builder getResourceDetails() {
            return this.resourceDetails != null ? this.resourceDetails.toBuilder() : null;
        }

        public final void setResourceDetails(ResourceDetails.BuilderImpl resourceDetails) {
            this.resourceDetails = resourceDetails != null ? resourceDetails.build() : null;
        }

        @Override
        public final Builder resourceDetails(ResourceDetails resourceDetails) {
            this.resourceDetails = resourceDetails;
            return this;
        }

        public final Collection<String> getOptions() {
            if (this.options instanceof SdkAutoConstructList) {
                return null;
            }
            return this.options;
        }

        public final void setOptions(Collection<String> options) {
            this.options = OptionsCopier.copy(options);
        }

        @Override
        public final Builder optionsWithStrings(Collection<String> options) {
            this.options = OptionsCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsWithStrings(String ... options) {
            this.optionsWithStrings(Arrays.asList(options));
            return this;
        }

        @Override
        public final Builder options(Collection<AssociationOption> options) {
            this.options = OptionsCopier.copyEnumToString(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(AssociationOption ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        public ResourceInfo build() {
            return new ResourceInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceInfo> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceDetails(ResourceDetails var1);

        default public Builder resourceDetails(Consumer<ResourceDetails.Builder> resourceDetails) {
            return this.resourceDetails((ResourceDetails)((ResourceDetails.Builder)ResourceDetails.builder().applyMutation(resourceDetails)).build());
        }

        public Builder optionsWithStrings(Collection<String> var1);

        public Builder optionsWithStrings(String ... var1);

        public Builder options(Collection<AssociationOption> var1);

        public Builder options(AssociationOption ... var1);
    }
}

