/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ApplicationTagResult;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AssociationOption;
import software.amazon.awssdk.services.servicecatalogappregistry.model.OptionsCopier;
import software.amazon.awssdk.services.servicecatalogappregistry.model.Resource;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ServiceCatalogAppRegistryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAssociatedResourceResponse
extends ServiceCatalogAppRegistryResponse
implements ToCopyableBuilder<Builder, GetAssociatedResourceResponse> {
    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resource").getter(GetAssociatedResourceResponse.getter(GetAssociatedResourceResponse::resource)).setter(GetAssociatedResourceResponse.setter(Builder::resource)).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<List<String>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("options").getter(GetAssociatedResourceResponse.getter(GetAssociatedResourceResponse::optionsAsStrings)).setter(GetAssociatedResourceResponse.setter(Builder::optionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ApplicationTagResult> APPLICATION_TAG_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("applicationTagResult").getter(GetAssociatedResourceResponse.getter(GetAssociatedResourceResponse::applicationTagResult)).setter(GetAssociatedResourceResponse.setter(Builder::applicationTagResult)).constructor(ApplicationTagResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationTagResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD, OPTIONS_FIELD, APPLICATION_TAG_RESULT_FIELD));
    private final Resource resource;
    private final List<String> options;
    private final ApplicationTagResult applicationTagResult;

    private GetAssociatedResourceResponse(BuilderImpl builder) {
        super(builder);
        this.resource = builder.resource;
        this.options = builder.options;
        this.applicationTagResult = builder.applicationTagResult;
    }

    public final Resource resource() {
        return this.resource;
    }

    public final List<AssociationOption> options() {
        return OptionsCopier.copyStringToEnum(this.options);
    }

    public final boolean hasOptions() {
        return this.options != null && !(this.options instanceof SdkAutoConstructList);
    }

    public final List<String> optionsAsStrings() {
        return this.options;
    }

    public final ApplicationTagResult applicationTagResult() {
        return this.applicationTagResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptions() ? this.optionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationTagResult());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssociatedResourceResponse)) {
            return false;
        }
        GetAssociatedResourceResponse other = (GetAssociatedResourceResponse)((Object)obj);
        return Objects.equals(this.resource(), other.resource()) && this.hasOptions() == other.hasOptions() && Objects.equals(this.optionsAsStrings(), other.optionsAsStrings()) && Objects.equals(this.applicationTagResult(), other.applicationTagResult());
    }

    public final String toString() {
        return ToString.builder((String)"GetAssociatedResourceResponse").add("Resource", (Object)this.resource()).add("Options", this.hasOptions() ? this.optionsAsStrings() : null).add("ApplicationTagResult", (Object)this.applicationTagResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "options": {
                return Optional.ofNullable(clazz.cast(this.optionsAsStrings()));
            }
            case "applicationTagResult": {
                return Optional.ofNullable(clazz.cast(this.applicationTagResult()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAssociatedResourceResponse, T> g) {
        return obj -> g.apply((GetAssociatedResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogAppRegistryResponse.BuilderImpl
    implements Builder {
        private Resource resource;
        private List<String> options = DefaultSdkAutoConstructList.getInstance();
        private ApplicationTagResult applicationTagResult;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssociatedResourceResponse model) {
            super(model);
            this.resource(model.resource);
            this.optionsWithStrings(model.options);
            this.applicationTagResult(model.applicationTagResult);
        }

        public final Resource.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final Collection<String> getOptions() {
            if (this.options instanceof SdkAutoConstructList) {
                return null;
            }
            return this.options;
        }

        public final void setOptions(Collection<String> options) {
            this.options = OptionsCopier.copy(options);
        }

        @Override
        public final Builder optionsWithStrings(Collection<String> options) {
            this.options = OptionsCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsWithStrings(String ... options) {
            this.optionsWithStrings(Arrays.asList(options));
            return this;
        }

        @Override
        public final Builder options(Collection<AssociationOption> options) {
            this.options = OptionsCopier.copyEnumToString(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(AssociationOption ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        public final ApplicationTagResult.Builder getApplicationTagResult() {
            return this.applicationTagResult != null ? this.applicationTagResult.toBuilder() : null;
        }

        public final void setApplicationTagResult(ApplicationTagResult.BuilderImpl applicationTagResult) {
            this.applicationTagResult = applicationTagResult != null ? applicationTagResult.build() : null;
        }

        @Override
        public final Builder applicationTagResult(ApplicationTagResult applicationTagResult) {
            this.applicationTagResult = applicationTagResult;
            return this;
        }

        @Override
        public GetAssociatedResourceResponse build() {
            return new GetAssociatedResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogAppRegistryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAssociatedResourceResponse> {
        public Builder resource(Resource var1);

        default public Builder resource(Consumer<Resource.Builder> resource) {
            return this.resource((Resource)((Resource.Builder)Resource.builder().applyMutation(resource)).build());
        }

        public Builder optionsWithStrings(Collection<String> var1);

        public Builder optionsWithStrings(String ... var1);

        public Builder options(Collection<AssociationOption> var1);

        public Builder options(AssociationOption ... var1);

        public Builder applicationTagResult(ApplicationTagResult var1);

        default public Builder applicationTagResult(Consumer<ApplicationTagResult.Builder> applicationTagResult) {
            return this.applicationTagResult((ApplicationTagResult)((ApplicationTagResult.Builder)ApplicationTagResult.builder().applyMutation(applicationTagResult)).build());
        }
    }
}

