/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalogappregistry.ServiceCatalogAppRegistryClient;
import software.amazon.awssdk.services.servicecatalogappregistry.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ResourceInfo;

public class ListAssociatedResourcesIterable
implements SdkIterable<ListAssociatedResourcesResponse> {
    private final ServiceCatalogAppRegistryClient client;
    private final ListAssociatedResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssociatedResourcesIterable(ServiceCatalogAppRegistryClient client, ListAssociatedResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssociatedResourcesResponseFetcher();
    }

    public Iterator<ListAssociatedResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceInfo> resources() {
        Function<ListAssociatedResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resources() != null) {
                return response.resources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssociatedResourcesResponseFetcher
    implements SyncPageFetcher<ListAssociatedResourcesResponse> {
        private ListAssociatedResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListAssociatedResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssociatedResourcesResponse nextPage(ListAssociatedResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListAssociatedResourcesIterable.this.client.listAssociatedResources(ListAssociatedResourcesIterable.this.firstRequest);
            }
            return ListAssociatedResourcesIterable.this.client.listAssociatedResources((ListAssociatedResourcesRequest)((Object)ListAssociatedResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

