/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.servicecatalogappregistry.ServiceCatalogAppRegistryClient;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AssociateAttributeGroupRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AssociateAttributeGroupResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AssociateResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AssociateResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ConflictException;
import software.amazon.awssdk.services.servicecatalogappregistry.model.CreateApplicationRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.CreateApplicationResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.CreateAttributeGroupRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.CreateAttributeGroupResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DeleteAttributeGroupRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DeleteAttributeGroupResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DisassociateAttributeGroupRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DisassociateAttributeGroupResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DisassociateResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DisassociateResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetApplicationRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetApplicationResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetAssociatedResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetAssociatedResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetAttributeGroupRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetAttributeGroupResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.InternalServerException;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ResourceNotFoundException;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ServiceCatalogAppRegistryException;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ServiceCatalogAppRegistryRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.servicecatalogappregistry.model.SyncResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.SyncResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.TagResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.TagResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.UntagResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.UntagResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.UpdateAttributeGroupRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.UpdateAttributeGroupResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ValidationException;
import software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListApplicationsIterable;
import software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedAttributeGroupsIterable;
import software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedResourcesIterable;
import software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsIterable;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.AssociateAttributeGroupRequestMarshaller;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.AssociateResourceRequestMarshaller;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.CreateApplicationRequestMarshaller;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.CreateAttributeGroupRequestMarshaller;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.DeleteApplicationRequestMarshaller;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.DeleteAttributeGroupRequestMarshaller;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.DisassociateAttributeGroupRequestMarshaller;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.DisassociateResourceRequestMarshaller;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.GetApplicationRequestMarshaller;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.GetAssociatedResourceRequestMarshaller;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.GetAttributeGroupRequestMarshaller;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.ListApplicationsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.ListAssociatedAttributeGroupsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.ListAssociatedResourcesRequestMarshaller;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.ListAttributeGroupsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.SyncResourceRequestMarshaller;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.UpdateApplicationRequestMarshaller;
import software.amazon.awssdk.services.servicecatalogappregistry.transform.UpdateAttributeGroupRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultServiceCatalogAppRegistryClient
implements ServiceCatalogAppRegistryClient {
    private static final Logger log = Logger.loggerFor(DefaultServiceCatalogAppRegistryClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultServiceCatalogAppRegistryClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "servicecatalog";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateAttributeGroupResponse associateAttributeGroup(AssociateAttributeGroupRequest associateAttributeGroupRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateAttributeGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, associateAttributeGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateAttributeGroup");
            AssociateAttributeGroupResponse associateAttributeGroupResponse = (AssociateAttributeGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateAttributeGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateAttributeGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateAttributeGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateAttributeGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$associateAttributeGroup$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateResourceResponse associateResource(AssociateResourceRequest associateResourceRequest) throws ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, associateResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateResource");
            AssociateResourceResponse associateResourceResponse = (AssociateResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$associateResource$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest) throws ServiceQuotaExceededException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, createApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApplication");
            CreateApplicationResponse createApplicationResponse = (CreateApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$createApplication$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAttributeGroupResponse createAttributeGroup(CreateAttributeGroupRequest createAttributeGroupRequest) throws ServiceQuotaExceededException, ConflictException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAttributeGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, createAttributeGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAttributeGroup");
            CreateAttributeGroupResponse createAttributeGroupResponse = (CreateAttributeGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAttributeGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAttributeGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAttributeGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAttributeGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$createAttributeGroup$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, deleteApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplication");
            DeleteApplicationResponse deleteApplicationResponse = (DeleteApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$deleteApplication$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAttributeGroupResponse deleteAttributeGroup(DeleteAttributeGroupRequest deleteAttributeGroupRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAttributeGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, deleteAttributeGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAttributeGroup");
            DeleteAttributeGroupResponse deleteAttributeGroupResponse = (DeleteAttributeGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAttributeGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAttributeGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAttributeGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAttributeGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$deleteAttributeGroup$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateAttributeGroupResponse disassociateAttributeGroup(DisassociateAttributeGroupRequest disassociateAttributeGroupRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateAttributeGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, disassociateAttributeGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateAttributeGroup");
            DisassociateAttributeGroupResponse disassociateAttributeGroupResponse = (DisassociateAttributeGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateAttributeGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateAttributeGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateAttributeGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateAttributeGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$disassociateAttributeGroup$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateResourceResponse disassociateResource(DisassociateResourceRequest disassociateResourceRequest) throws ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, disassociateResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateResource");
            DisassociateResourceResponse disassociateResourceResponse = (DisassociateResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$disassociateResource$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetApplicationResponse getApplication(GetApplicationRequest getApplicationRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, getApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApplication");
            GetApplicationResponse getApplicationResponse = (GetApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$getApplication$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAssociatedResourceResponse getAssociatedResource(GetAssociatedResourceRequest getAssociatedResourceRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAssociatedResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, getAssociatedResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAssociatedResource");
            GetAssociatedResourceResponse getAssociatedResourceResponse = (GetAssociatedResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAssociatedResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAssociatedResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAssociatedResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAssociatedResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$getAssociatedResource$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAttributeGroupResponse getAttributeGroup(GetAttributeGroupRequest getAttributeGroupRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAttributeGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, getAttributeGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAttributeGroup");
            GetAttributeGroupResponse getAttributeGroupResponse = (GetAttributeGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAttributeGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAttributeGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAttributeGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAttributeGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$getAttributeGroup$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationsResponse listApplications(ListApplicationsRequest listApplicationsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, listApplicationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApplications");
            ListApplicationsResponse listApplicationsResponse = (ListApplicationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listApplicationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListApplicationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listApplicationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$listApplications$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListApplicationsIterable listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        return new ListApplicationsIterable(this, this.applyPaginatorUserAgent(listApplicationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssociatedAttributeGroupsResponse listAssociatedAttributeGroups(ListAssociatedAttributeGroupsRequest listAssociatedAttributeGroupsRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAssociatedAttributeGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, listAssociatedAttributeGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAssociatedAttributeGroups");
            ListAssociatedAttributeGroupsResponse listAssociatedAttributeGroupsResponse = (ListAssociatedAttributeGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAssociatedAttributeGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAssociatedAttributeGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAssociatedAttributeGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAssociatedAttributeGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$listAssociatedAttributeGroups$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAssociatedAttributeGroupsIterable listAssociatedAttributeGroupsPaginator(ListAssociatedAttributeGroupsRequest listAssociatedAttributeGroupsRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        return new ListAssociatedAttributeGroupsIterable(this, this.applyPaginatorUserAgent(listAssociatedAttributeGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssociatedResourcesResponse listAssociatedResources(ListAssociatedResourcesRequest listAssociatedResourcesRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAssociatedResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, listAssociatedResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAssociatedResources");
            ListAssociatedResourcesResponse listAssociatedResourcesResponse = (ListAssociatedResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAssociatedResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAssociatedResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAssociatedResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAssociatedResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$listAssociatedResources$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAssociatedResourcesIterable listAssociatedResourcesPaginator(ListAssociatedResourcesRequest listAssociatedResourcesRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        return new ListAssociatedResourcesIterable(this, this.applyPaginatorUserAgent(listAssociatedResourcesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAttributeGroupsResponse listAttributeGroups(ListAttributeGroupsRequest listAttributeGroupsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAttributeGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, listAttributeGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAttributeGroups");
            ListAttributeGroupsResponse listAttributeGroupsResponse = (ListAttributeGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAttributeGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAttributeGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAttributeGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAttributeGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$listAttributeGroups$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAttributeGroupsIterable listAttributeGroupsPaginator(ListAttributeGroupsRequest listAttributeGroupsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        return new ListAttributeGroupsIterable(this, this.applyPaginatorUserAgent(listAttributeGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$listTagsForResource$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncResourceResponse syncResource(SyncResourceRequest syncResourceRequest) throws ResourceNotFoundException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SyncResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, syncResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SyncResource");
            SyncResourceResponse syncResourceResponse = (SyncResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SyncResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)syncResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SyncResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return syncResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$syncResource$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$tagResource$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$untagResource$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest) throws ResourceNotFoundException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, updateApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApplication");
            UpdateApplicationResponse updateApplicationResponse = (UpdateApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$updateApplication$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAttributeGroupResponse updateAttributeGroup(UpdateAttributeGroupRequest updateAttributeGroupRequest) throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAttributeGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceCatalogAppRegistryClient.resolveMetricPublishers(this.clientConfiguration, updateAttributeGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Catalog AppRegistry");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAttributeGroup");
            UpdateAttributeGroupResponse updateAttributeGroupResponse = (UpdateAttributeGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAttributeGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAttributeGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAttributeGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAttributeGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceCatalogAppRegistryClient.lambda$updateAttributeGroup$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ServiceCatalogAppRegistryException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends ServiceCatalogAppRegistryRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.164").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ServiceCatalogAppRegistryRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateAttributeGroup$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApplication$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$syncResource$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAttributeGroups$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAssociatedResources$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAssociatedAttributeGroups$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApplications$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAttributeGroup$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAssociatedResource$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApplication$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateResource$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateAttributeGroup$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAttributeGroup$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplication$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAttributeGroup$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApplication$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateResource$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateAttributeGroup$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

