/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ServiceCatalogAppRegistryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateAttributeGroupResponse
extends ServiceCatalogAppRegistryResponse
implements ToCopyableBuilder<Builder, AssociateAttributeGroupResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationArn").getter(AssociateAttributeGroupResponse.getter(AssociateAttributeGroupResponse::applicationArn)).setter(AssociateAttributeGroupResponse.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()}).build();
    private static final SdkField<String> ATTRIBUTE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attributeGroupArn").getter(AssociateAttributeGroupResponse.getter(AssociateAttributeGroupResponse::attributeGroupArn)).setter(AssociateAttributeGroupResponse.setter(Builder::attributeGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeGroupArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, ATTRIBUTE_GROUP_ARN_FIELD));
    private final String applicationArn;
    private final String attributeGroupArn;

    private AssociateAttributeGroupResponse(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
        this.attributeGroupArn = builder.attributeGroupArn;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final String attributeGroupArn() {
        return this.attributeGroupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeGroupArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAttributeGroupResponse)) {
            return false;
        }
        AssociateAttributeGroupResponse other = (AssociateAttributeGroupResponse)((Object)obj);
        return Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.attributeGroupArn(), other.attributeGroupArn());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateAttributeGroupResponse").add("ApplicationArn", (Object)this.applicationArn()).add("AttributeGroupArn", (Object)this.attributeGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "attributeGroupArn": {
                return Optional.ofNullable(clazz.cast(this.attributeGroupArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateAttributeGroupResponse, T> g) {
        return obj -> g.apply((AssociateAttributeGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogAppRegistryResponse.BuilderImpl
    implements Builder {
        private String applicationArn;
        private String attributeGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAttributeGroupResponse model) {
            super(model);
            this.applicationArn(model.applicationArn);
            this.attributeGroupArn(model.attributeGroupArn);
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        public final String getAttributeGroupArn() {
            return this.attributeGroupArn;
        }

        @Override
        public final Builder attributeGroupArn(String attributeGroupArn) {
            this.attributeGroupArn = attributeGroupArn;
            return this;
        }

        public final void setAttributeGroupArn(String attributeGroupArn) {
            this.attributeGroupArn = attributeGroupArn;
        }

        @Override
        public AssociateAttributeGroupResponse build() {
            return new AssociateAttributeGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogAppRegistryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateAttributeGroupResponse> {
        public Builder applicationArn(String var1);

        public Builder attributeGroupArn(String var1);
    }
}

