/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ServiceCatalogAppRegistryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApplicationRequest
extends ServiceCatalogAppRegistryRequest
implements ToCopyableBuilder<Builder, UpdateApplicationRequest> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("application").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::application)).setter(UpdateApplicationRequest.setter(Builder::application)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::name)).setter(UpdateApplicationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::description)).setter(UpdateApplicationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD, NAME_FIELD, DESCRIPTION_FIELD));
    private final String application;
    private final String name;
    private final String description;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.application = builder.application;
        this.name = builder.name;
        this.description = builder.description;
    }

    public String application() {
        return this.application;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.application());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest)((Object)obj);
        return Objects.equals(this.application(), other.application()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"UpdateApplicationRequest").add("Application", (Object)this.application()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "application": {
                return Optional.ofNullable(clazz.cast(this.application()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationRequest, T> g) {
        return obj -> g.apply((UpdateApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogAppRegistryRequest.BuilderImpl
    implements Builder {
        private String application;
        private String name;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            super(model);
            this.application(model.application);
            this.name(model.name);
            this.description(model.description);
        }

        public final String getApplication() {
            return this.application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogAppRegistryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApplicationRequest> {
        public Builder application(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

