/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.AddTagsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagKeysCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProductRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, UpdateProductRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProductRequest.getter(UpdateProductRequest::acceptLanguage)).setter(UpdateProductRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProductRequest.getter(UpdateProductRequest::id)).setter(UpdateProductRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProductRequest.getter(UpdateProductRequest::name)).setter(UpdateProductRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProductRequest.getter(UpdateProductRequest::owner)).setter(UpdateProductRequest.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProductRequest.getter(UpdateProductRequest::description)).setter(UpdateProductRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DISTRIBUTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProductRequest.getter(UpdateProductRequest::distributor)).setter(UpdateProductRequest.setter(Builder::distributor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distributor").build()}).build();
    private static final SdkField<String> SUPPORT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProductRequest.getter(UpdateProductRequest::supportDescription)).setter(UpdateProductRequest.setter(Builder::supportDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportDescription").build()}).build();
    private static final SdkField<String> SUPPORT_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProductRequest.getter(UpdateProductRequest::supportEmail)).setter(UpdateProductRequest.setter(Builder::supportEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportEmail").build()}).build();
    private static final SdkField<String> SUPPORT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProductRequest.getter(UpdateProductRequest::supportUrl)).setter(UpdateProductRequest.setter(Builder::supportUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportUrl").build()}).build();
    private static final SdkField<List<Tag>> ADD_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateProductRequest.getter(UpdateProductRequest::addTags)).setter(UpdateProductRequest.setter(Builder::addTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateProductRequest.getter(UpdateProductRequest::removeTags)).setter(UpdateProductRequest.setter(Builder::removeTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, ID_FIELD, NAME_FIELD, OWNER_FIELD, DESCRIPTION_FIELD, DISTRIBUTOR_FIELD, SUPPORT_DESCRIPTION_FIELD, SUPPORT_EMAIL_FIELD, SUPPORT_URL_FIELD, ADD_TAGS_FIELD, REMOVE_TAGS_FIELD));
    private final String acceptLanguage;
    private final String id;
    private final String name;
    private final String owner;
    private final String description;
    private final String distributor;
    private final String supportDescription;
    private final String supportEmail;
    private final String supportUrl;
    private final List<Tag> addTags;
    private final List<String> removeTags;

    private UpdateProductRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.id = builder.id;
        this.name = builder.name;
        this.owner = builder.owner;
        this.description = builder.description;
        this.distributor = builder.distributor;
        this.supportDescription = builder.supportDescription;
        this.supportEmail = builder.supportEmail;
        this.supportUrl = builder.supportUrl;
        this.addTags = builder.addTags;
        this.removeTags = builder.removeTags;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String owner() {
        return this.owner;
    }

    public String description() {
        return this.description;
    }

    public String distributor() {
        return this.distributor;
    }

    public String supportDescription() {
        return this.supportDescription;
    }

    public String supportEmail() {
        return this.supportEmail;
    }

    public String supportUrl() {
        return this.supportUrl;
    }

    public List<Tag> addTags() {
        return this.addTags;
    }

    public List<String> removeTags() {
        return this.removeTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributor());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.addTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeTags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProductRequest)) {
            return false;
        }
        UpdateProductRequest other = (UpdateProductRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.distributor(), other.distributor()) && Objects.equals(this.supportDescription(), other.supportDescription()) && Objects.equals(this.supportEmail(), other.supportEmail()) && Objects.equals(this.supportUrl(), other.supportUrl()) && Objects.equals(this.addTags(), other.addTags()) && Objects.equals(this.removeTags(), other.removeTags());
    }

    public String toString() {
        return ToString.builder((String)"UpdateProductRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Owner", (Object)this.owner()).add("Description", (Object)this.description()).add("Distributor", (Object)this.distributor()).add("SupportDescription", (Object)this.supportDescription()).add("SupportEmail", (Object)this.supportEmail()).add("SupportUrl", (Object)this.supportUrl()).add("AddTags", this.addTags()).add("RemoveTags", this.removeTags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Distributor": {
                return Optional.ofNullable(clazz.cast(this.distributor()));
            }
            case "SupportDescription": {
                return Optional.ofNullable(clazz.cast(this.supportDescription()));
            }
            case "SupportEmail": {
                return Optional.ofNullable(clazz.cast(this.supportEmail()));
            }
            case "SupportUrl": {
                return Optional.ofNullable(clazz.cast(this.supportUrl()));
            }
            case "AddTags": {
                return Optional.ofNullable(clazz.cast(this.addTags()));
            }
            case "RemoveTags": {
                return Optional.ofNullable(clazz.cast(this.removeTags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProductRequest, T> g) {
        return obj -> g.apply((UpdateProductRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String id;
        private String name;
        private String owner;
        private String description;
        private String distributor;
        private String supportDescription;
        private String supportEmail;
        private String supportUrl;
        private List<Tag> addTags = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProductRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.id(model.id);
            this.name(model.name);
            this.owner(model.owner);
            this.description(model.description);
            this.distributor(model.distributor);
            this.supportDescription(model.supportDescription);
            this.supportEmail(model.supportEmail);
            this.supportUrl(model.supportUrl);
            this.addTags(model.addTags);
            this.removeTags(model.removeTags);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDistributor() {
            return this.distributor;
        }

        @Override
        public final Builder distributor(String distributor) {
            this.distributor = distributor;
            return this;
        }

        public final void setDistributor(String distributor) {
            this.distributor = distributor;
        }

        public final String getSupportDescription() {
            return this.supportDescription;
        }

        @Override
        public final Builder supportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
            return this;
        }

        public final void setSupportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
        }

        public final String getSupportEmail() {
            return this.supportEmail;
        }

        @Override
        public final Builder supportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
            return this;
        }

        public final void setSupportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
        }

        public final String getSupportUrl() {
            return this.supportUrl;
        }

        @Override
        public final Builder supportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
            return this;
        }

        public final void setSupportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
        }

        public final Collection<Tag.Builder> getAddTags() {
            return this.addTags != null ? (Collection)this.addTags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addTags(Collection<Tag> addTags) {
            this.addTags = AddTagsCopier.copy(addTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Tag ... addTags) {
            this.addTags(Arrays.asList(addTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Consumer<Tag.Builder> ... addTags) {
            this.addTags(Stream.of(addTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAddTags(Collection<Tag.BuilderImpl> addTags) {
            this.addTags = AddTagsCopier.copyFromBuilder(addTags);
        }

        public final Collection<String> getRemoveTags() {
            return this.removeTags;
        }

        @Override
        public final Builder removeTags(Collection<String> removeTags) {
            this.removeTags = TagKeysCopier.copy(removeTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeTags(String ... removeTags) {
            this.removeTags(Arrays.asList(removeTags));
            return this;
        }

        public final void setRemoveTags(Collection<String> removeTags) {
            this.removeTags = TagKeysCopier.copy(removeTags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProductRequest build() {
            return new UpdateProductRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProductRequest> {
        public Builder acceptLanguage(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder owner(String var1);

        public Builder description(String var1);

        public Builder distributor(String var1);

        public Builder supportDescription(String var1);

        public Builder supportEmail(String var1);

        public Builder supportUrl(String var1);

        public Builder addTags(Collection<Tag> var1);

        public Builder addTags(Tag ... var1);

        public Builder addTags(Consumer<Tag.Builder> ... var1);

        public Builder removeTags(Collection<String> var1);

        public Builder removeTags(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

