/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilter;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductFiltersCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductViewFilterBy;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.services.servicecatalog.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchProvisionedProductsRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, SearchProvisionedProductsRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchProvisionedProductsRequest.getter(SearchProvisionedProductsRequest::acceptLanguage)).setter(SearchProvisionedProductsRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<AccessLevelFilter> ACCESS_LEVEL_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SearchProvisionedProductsRequest.getter(SearchProvisionedProductsRequest::accessLevelFilter)).setter(SearchProvisionedProductsRequest.setter(Builder::accessLevelFilter)).constructor(AccessLevelFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLevelFilter").build()}).build();
    private static final SdkField<Map<String, List<String>>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(SearchProvisionedProductsRequest.getter(SearchProvisionedProductsRequest::filtersAsStrings)).setter(SearchProvisionedProductsRequest.setter(Builder::filtersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchProvisionedProductsRequest.getter(SearchProvisionedProductsRequest::sortBy)).setter(SearchProvisionedProductsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchProvisionedProductsRequest.getter(SearchProvisionedProductsRequest::sortOrderAsString)).setter(SearchProvisionedProductsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SearchProvisionedProductsRequest.getter(SearchProvisionedProductsRequest::pageSize)).setter(SearchProvisionedProductsRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchProvisionedProductsRequest.getter(SearchProvisionedProductsRequest::pageToken)).setter(SearchProvisionedProductsRequest.setter(Builder::pageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, ACCESS_LEVEL_FILTER_FIELD, FILTERS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, PAGE_SIZE_FIELD, PAGE_TOKEN_FIELD));
    private final String acceptLanguage;
    private final AccessLevelFilter accessLevelFilter;
    private final Map<String, List<String>> filters;
    private final String sortBy;
    private final String sortOrder;
    private final Integer pageSize;
    private final String pageToken;

    private SearchProvisionedProductsRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.accessLevelFilter = builder.accessLevelFilter;
        this.filters = builder.filters;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.pageSize = builder.pageSize;
        this.pageToken = builder.pageToken;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public AccessLevelFilter accessLevelFilter() {
        return this.accessLevelFilter;
    }

    public Map<ProvisionedProductViewFilterBy, List<String>> filters() {
        return ProvisionedProductFiltersCopier.copyStringToEnum(this.filters);
    }

    public Map<String, List<String>> filtersAsStrings() {
        return this.filters;
    }

    public String sortBy() {
        return this.sortBy;
    }

    public SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public String sortOrderAsString() {
        return this.sortOrder;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public String pageToken() {
        return this.pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessLevelFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.filtersAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProvisionedProductsRequest)) {
            return false;
        }
        SearchProvisionedProductsRequest other = (SearchProvisionedProductsRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.accessLevelFilter(), other.accessLevelFilter()) && Objects.equals(this.filtersAsStrings(), other.filtersAsStrings()) && Objects.equals(this.sortBy(), other.sortBy()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.pageToken(), other.pageToken());
    }

    public String toString() {
        return ToString.builder((String)"SearchProvisionedProductsRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("AccessLevelFilter", (Object)this.accessLevelFilter()).add("Filters", this.filtersAsStrings()).add("SortBy", (Object)this.sortBy()).add("SortOrder", (Object)this.sortOrderAsString()).add("PageSize", (Object)this.pageSize()).add("PageToken", (Object)this.pageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "AccessLevelFilter": {
                return Optional.ofNullable(clazz.cast(this.accessLevelFilter()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filtersAsStrings()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortBy()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "PageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchProvisionedProductsRequest, T> g) {
        return obj -> g.apply((SearchProvisionedProductsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private AccessLevelFilter accessLevelFilter;
        private Map<String, List<String>> filters = DefaultSdkAutoConstructMap.getInstance();
        private String sortBy;
        private String sortOrder;
        private Integer pageSize;
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchProvisionedProductsRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.accessLevelFilter(model.accessLevelFilter);
            this.filtersWithStrings(model.filters);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.pageSize(model.pageSize);
            this.pageToken(model.pageToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final AccessLevelFilter.Builder getAccessLevelFilter() {
            return this.accessLevelFilter != null ? this.accessLevelFilter.toBuilder() : null;
        }

        @Override
        public final Builder accessLevelFilter(AccessLevelFilter accessLevelFilter) {
            this.accessLevelFilter = accessLevelFilter;
            return this;
        }

        public final void setAccessLevelFilter(AccessLevelFilter.BuilderImpl accessLevelFilter) {
            this.accessLevelFilter = accessLevelFilter != null ? accessLevelFilter.build() : null;
        }

        public final Map<String, ? extends Collection<String>> getFiltersAsStrings() {
            return this.filters;
        }

        @Override
        public final Builder filtersWithStrings(Map<String, ? extends Collection<String>> filters) {
            this.filters = ProvisionedProductFiltersCopier.copy(filters);
            return this;
        }

        @Override
        public final Builder filters(Map<ProvisionedProductViewFilterBy, ? extends Collection<String>> filters) {
            this.filters = ProvisionedProductFiltersCopier.copyEnumToString(filters);
            return this;
        }

        public final void setFiltersWithStrings(Map<String, ? extends Collection<String>> filters) {
            this.filters = ProvisionedProductFiltersCopier.copy(filters);
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getSortOrderAsString() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchProvisionedProductsRequest build() {
            return new SearchProvisionedProductsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchProvisionedProductsRequest> {
        public Builder acceptLanguage(String var1);

        public Builder accessLevelFilter(AccessLevelFilter var1);

        default public Builder accessLevelFilter(Consumer<AccessLevelFilter.Builder> accessLevelFilter) {
            return this.accessLevelFilter((AccessLevelFilter)((AccessLevelFilter.Builder)AccessLevelFilter.builder().applyMutation(accessLevelFilter)).build());
        }

        public Builder filtersWithStrings(Map<String, ? extends Collection<String>> var1);

        public Builder filters(Map<ProvisionedProductViewFilterBy, ? extends Collection<String>> var1);

        public Builder sortBy(String var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder pageSize(Integer var1);

        public Builder pageToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

