/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilter;
import software.amazon.awssdk.services.servicecatalog.model.ListRecordHistorySearchFilter;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecordHistoryRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, ListRecordHistoryRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListRecordHistoryRequest.getter(ListRecordHistoryRequest::acceptLanguage)).setter(ListRecordHistoryRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<AccessLevelFilter> ACCESS_LEVEL_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ListRecordHistoryRequest.getter(ListRecordHistoryRequest::accessLevelFilter)).setter(ListRecordHistoryRequest.setter(Builder::accessLevelFilter)).constructor(AccessLevelFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLevelFilter").build()}).build();
    private static final SdkField<ListRecordHistorySearchFilter> SEARCH_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ListRecordHistoryRequest.getter(ListRecordHistoryRequest::searchFilter)).setter(ListRecordHistoryRequest.setter(Builder::searchFilter)).constructor(ListRecordHistorySearchFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchFilter").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListRecordHistoryRequest.getter(ListRecordHistoryRequest::pageSize)).setter(ListRecordHistoryRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListRecordHistoryRequest.getter(ListRecordHistoryRequest::pageToken)).setter(ListRecordHistoryRequest.setter(Builder::pageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, ACCESS_LEVEL_FILTER_FIELD, SEARCH_FILTER_FIELD, PAGE_SIZE_FIELD, PAGE_TOKEN_FIELD));
    private final String acceptLanguage;
    private final AccessLevelFilter accessLevelFilter;
    private final ListRecordHistorySearchFilter searchFilter;
    private final Integer pageSize;
    private final String pageToken;

    private ListRecordHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.accessLevelFilter = builder.accessLevelFilter;
        this.searchFilter = builder.searchFilter;
        this.pageSize = builder.pageSize;
        this.pageToken = builder.pageToken;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public AccessLevelFilter accessLevelFilter() {
        return this.accessLevelFilter;
    }

    public ListRecordHistorySearchFilter searchFilter() {
        return this.searchFilter;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public String pageToken() {
        return this.pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessLevelFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecordHistoryRequest)) {
            return false;
        }
        ListRecordHistoryRequest other = (ListRecordHistoryRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.accessLevelFilter(), other.accessLevelFilter()) && Objects.equals(this.searchFilter(), other.searchFilter()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.pageToken(), other.pageToken());
    }

    public String toString() {
        return ToString.builder((String)"ListRecordHistoryRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("AccessLevelFilter", (Object)this.accessLevelFilter()).add("SearchFilter", (Object)this.searchFilter()).add("PageSize", (Object)this.pageSize()).add("PageToken", (Object)this.pageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "AccessLevelFilter": {
                return Optional.ofNullable(clazz.cast(this.accessLevelFilter()));
            }
            case "SearchFilter": {
                return Optional.ofNullable(clazz.cast(this.searchFilter()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "PageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecordHistoryRequest, T> g) {
        return obj -> g.apply((ListRecordHistoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private AccessLevelFilter accessLevelFilter;
        private ListRecordHistorySearchFilter searchFilter;
        private Integer pageSize;
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecordHistoryRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.accessLevelFilter(model.accessLevelFilter);
            this.searchFilter(model.searchFilter);
            this.pageSize(model.pageSize);
            this.pageToken(model.pageToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final AccessLevelFilter.Builder getAccessLevelFilter() {
            return this.accessLevelFilter != null ? this.accessLevelFilter.toBuilder() : null;
        }

        @Override
        public final Builder accessLevelFilter(AccessLevelFilter accessLevelFilter) {
            this.accessLevelFilter = accessLevelFilter;
            return this;
        }

        public final void setAccessLevelFilter(AccessLevelFilter.BuilderImpl accessLevelFilter) {
            this.accessLevelFilter = accessLevelFilter != null ? accessLevelFilter.build() : null;
        }

        public final ListRecordHistorySearchFilter.Builder getSearchFilter() {
            return this.searchFilter != null ? this.searchFilter.toBuilder() : null;
        }

        @Override
        public final Builder searchFilter(ListRecordHistorySearchFilter searchFilter) {
            this.searchFilter = searchFilter;
            return this;
        }

        public final void setSearchFilter(ListRecordHistorySearchFilter.BuilderImpl searchFilter) {
            this.searchFilter = searchFilter != null ? searchFilter.build() : null;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRecordHistoryRequest build() {
            return new ListRecordHistoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecordHistoryRequest> {
        public Builder acceptLanguage(String var1);

        public Builder accessLevelFilter(AccessLevelFilter var1);

        default public Builder accessLevelFilter(Consumer<AccessLevelFilter.Builder> accessLevelFilter) {
            return this.accessLevelFilter((AccessLevelFilter)((AccessLevelFilter.Builder)AccessLevelFilter.builder().applyMutation(accessLevelFilter)).build());
        }

        public Builder searchFilter(ListRecordHistorySearchFilter var1);

        default public Builder searchFilter(Consumer<ListRecordHistorySearchFilter.Builder> searchFilter) {
            return this.searchFilter((ListRecordHistorySearchFilter)((ListRecordHistorySearchFilter.Builder)ListRecordHistorySearchFilter.builder().applyMutation(searchFilter)).build());
        }

        public Builder pageSize(Integer var1);

        public Builder pageToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

