/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceActionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceActionSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceActionSummary.getter(ServiceActionSummary::id)).setter(ServiceActionSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceActionSummary.getter(ServiceActionSummary::name)).setter(ServiceActionSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceActionSummary.getter(ServiceActionSummary::description)).setter(ServiceActionSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DEFINITION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceActionSummary.getter(ServiceActionSummary::definitionTypeAsString)).setter(ServiceActionSummary.setter(Builder::definitionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefinitionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, DEFINITION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String description;
    private final String definitionType;

    private ServiceActionSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.definitionType = builder.definitionType;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public ServiceActionDefinitionType definitionType() {
        return ServiceActionDefinitionType.fromValue(this.definitionType);
    }

    public String definitionTypeAsString() {
        return this.definitionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.definitionTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceActionSummary)) {
            return false;
        }
        ServiceActionSummary other = (ServiceActionSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.definitionTypeAsString(), other.definitionTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"ServiceActionSummary").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DefinitionType", (Object)this.definitionTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DefinitionType": {
                return Optional.ofNullable(clazz.cast(this.definitionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceActionSummary, T> g) {
        return obj -> g.apply((ServiceActionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private String definitionType;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceActionSummary model) {
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.definitionType(model.definitionType);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDefinitionTypeAsString() {
            return this.definitionType;
        }

        @Override
        public final Builder definitionType(String definitionType) {
            this.definitionType = definitionType;
            return this;
        }

        @Override
        public final Builder definitionType(ServiceActionDefinitionType definitionType) {
            this.definitionType(definitionType.toString());
            return this;
        }

        public final void setDefinitionType(String definitionType) {
            this.definitionType = definitionType;
        }

        public ServiceActionSummary build() {
            return new ServiceActionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceActionSummary> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder definitionType(String var1);

        public Builder definitionType(ServiceActionDefinitionType var1);
    }
}

