/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionResponse;

public class ListResourcesForTagOptionPublisher
implements SdkPublisher<ListResourcesForTagOptionResponse> {
    private final ServiceCatalogAsyncClient client;
    private final ListResourcesForTagOptionRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourcesForTagOptionPublisher(ServiceCatalogAsyncClient client, ListResourcesForTagOptionRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourcesForTagOptionPublisher(ServiceCatalogAsyncClient client, ListResourcesForTagOptionRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourcesForTagOptionResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourcesForTagOptionResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListResourcesForTagOptionPublisher resume(ListResourcesForTagOptionResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListResourcesForTagOptionPublisher(this.client, (ListResourcesForTagOptionRequest)((Object)this.firstRequest.toBuilder().pageToken(lastSuccessfulPage.pageToken()).build()));
        }
        return new ListResourcesForTagOptionPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListResourcesForTagOptionResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListResourcesForTagOptionResponseFetcher
    implements AsyncPageFetcher<ListResourcesForTagOptionResponse> {
        private ListResourcesForTagOptionResponseFetcher() {
        }

        public boolean hasNextPage(ListResourcesForTagOptionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.pageToken());
        }

        public CompletableFuture<ListResourcesForTagOptionResponse> nextPage(ListResourcesForTagOptionResponse previousPage) {
            if (previousPage == null) {
                return ListResourcesForTagOptionPublisher.this.client.listResourcesForTagOption(ListResourcesForTagOptionPublisher.this.firstRequest);
            }
            return ListResourcesForTagOptionPublisher.this.client.listResourcesForTagOption((ListResourcesForTagOptionRequest)((Object)ListResourcesForTagOptionPublisher.this.firstRequest.toBuilder().pageToken(previousPage.pageToken()).build()));
        }
    }
}

