/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse;

public class SearchProvisionedProductsIterable
implements SdkIterable<SearchProvisionedProductsResponse> {
    private final ServiceCatalogClient client;
    private final SearchProvisionedProductsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchProvisionedProductsIterable(ServiceCatalogClient client, SearchProvisionedProductsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchProvisionedProductsResponseFetcher();
    }

    public Iterator<SearchProvisionedProductsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final SearchProvisionedProductsIterable resume(SearchProvisionedProductsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new SearchProvisionedProductsIterable(this.client, (SearchProvisionedProductsRequest)((Object)this.firstRequest.toBuilder().pageToken(lastSuccessfulPage.nextPageToken()).build()));
        }
        return new SearchProvisionedProductsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<SearchProvisionedProductsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class SearchProvisionedProductsResponseFetcher
    implements SyncPageFetcher<SearchProvisionedProductsResponse> {
        private SearchProvisionedProductsResponseFetcher() {
        }

        public boolean hasNextPage(SearchProvisionedProductsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public SearchProvisionedProductsResponse nextPage(SearchProvisionedProductsResponse previousPage) {
            if (previousPage == null) {
                return SearchProvisionedProductsIterable.this.client.searchProvisionedProducts(SearchProvisionedProductsIterable.this.firstRequest);
            }
            return SearchProvisionedProductsIterable.this.client.searchProvisionedProducts((SearchProvisionedProductsRequest)((Object)SearchProvisionedProductsIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

