/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewDetail;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactSummariesCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactSummary;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagOptionDetail;
import software.amazon.awssdk.services.servicecatalog.model.TagOptionDetailsCopier;
import software.amazon.awssdk.services.servicecatalog.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProductAsAdminResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, DescribeProductAsAdminResponse> {
    private static final SdkField<ProductViewDetail> PRODUCT_VIEW_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeProductAsAdminResponse.getter(DescribeProductAsAdminResponse::productViewDetail)).setter(DescribeProductAsAdminResponse.setter(Builder::productViewDetail)).constructor(ProductViewDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductViewDetail").build()}).build();
    private static final SdkField<List<ProvisioningArtifactSummary>> PROVISIONING_ARTIFACT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeProductAsAdminResponse.getter(DescribeProductAsAdminResponse::provisioningArtifactSummaries)).setter(DescribeProductAsAdminResponse.setter(Builder::provisioningArtifactSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProvisioningArtifactSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeProductAsAdminResponse.getter(DescribeProductAsAdminResponse::tags)).setter(DescribeProductAsAdminResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TagOptionDetail>> TAG_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeProductAsAdminResponse.getter(DescribeProductAsAdminResponse::tagOptions)).setter(DescribeProductAsAdminResponse.setter(Builder::tagOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagOptionDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_VIEW_DETAIL_FIELD, PROVISIONING_ARTIFACT_SUMMARIES_FIELD, TAGS_FIELD, TAG_OPTIONS_FIELD));
    private final ProductViewDetail productViewDetail;
    private final List<ProvisioningArtifactSummary> provisioningArtifactSummaries;
    private final List<Tag> tags;
    private final List<TagOptionDetail> tagOptions;

    private DescribeProductAsAdminResponse(BuilderImpl builder) {
        super(builder);
        this.productViewDetail = builder.productViewDetail;
        this.provisioningArtifactSummaries = builder.provisioningArtifactSummaries;
        this.tags = builder.tags;
        this.tagOptions = builder.tagOptions;
    }

    public ProductViewDetail productViewDetail() {
        return this.productViewDetail;
    }

    public List<ProvisioningArtifactSummary> provisioningArtifactSummaries() {
        return this.provisioningArtifactSummaries;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<TagOptionDetail> tagOptions() {
        return this.tagOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productViewDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProductAsAdminResponse)) {
            return false;
        }
        DescribeProductAsAdminResponse other = (DescribeProductAsAdminResponse)((Object)obj);
        return Objects.equals(this.productViewDetail(), other.productViewDetail()) && Objects.equals(this.provisioningArtifactSummaries(), other.provisioningArtifactSummaries()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.tagOptions(), other.tagOptions());
    }

    public String toString() {
        return ToString.builder((String)"DescribeProductAsAdminResponse").add("ProductViewDetail", (Object)this.productViewDetail()).add("ProvisioningArtifactSummaries", this.provisioningArtifactSummaries()).add("Tags", this.tags()).add("TagOptions", this.tagOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductViewDetail": {
                return Optional.ofNullable(clazz.cast(this.productViewDetail()));
            }
            case "ProvisioningArtifactSummaries": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactSummaries()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TagOptions": {
                return Optional.ofNullable(clazz.cast(this.tagOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProductAsAdminResponse, T> g) {
        return obj -> g.apply((DescribeProductAsAdminResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private ProductViewDetail productViewDetail;
        private List<ProvisioningArtifactSummary> provisioningArtifactSummaries = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<TagOptionDetail> tagOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProductAsAdminResponse model) {
            super(model);
            this.productViewDetail(model.productViewDetail);
            this.provisioningArtifactSummaries(model.provisioningArtifactSummaries);
            this.tags(model.tags);
            this.tagOptions(model.tagOptions);
        }

        public final ProductViewDetail.Builder getProductViewDetail() {
            return this.productViewDetail != null ? this.productViewDetail.toBuilder() : null;
        }

        @Override
        public final Builder productViewDetail(ProductViewDetail productViewDetail) {
            this.productViewDetail = productViewDetail;
            return this;
        }

        public final void setProductViewDetail(ProductViewDetail.BuilderImpl productViewDetail) {
            this.productViewDetail = productViewDetail != null ? productViewDetail.build() : null;
        }

        public final Collection<ProvisioningArtifactSummary.Builder> getProvisioningArtifactSummaries() {
            return this.provisioningArtifactSummaries != null ? (Collection)this.provisioningArtifactSummaries.stream().map(ProvisioningArtifactSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisioningArtifactSummaries(Collection<ProvisioningArtifactSummary> provisioningArtifactSummaries) {
            this.provisioningArtifactSummaries = ProvisioningArtifactSummariesCopier.copy(provisioningArtifactSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactSummaries(ProvisioningArtifactSummary ... provisioningArtifactSummaries) {
            this.provisioningArtifactSummaries(Arrays.asList(provisioningArtifactSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactSummaries(Consumer<ProvisioningArtifactSummary.Builder> ... provisioningArtifactSummaries) {
            this.provisioningArtifactSummaries(Stream.of(provisioningArtifactSummaries).map(c -> (ProvisioningArtifactSummary)((ProvisioningArtifactSummary.Builder)ProvisioningArtifactSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningArtifactSummaries(Collection<ProvisioningArtifactSummary.BuilderImpl> provisioningArtifactSummaries) {
            this.provisioningArtifactSummaries = ProvisioningArtifactSummariesCopier.copyFromBuilder(provisioningArtifactSummaries);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final Collection<TagOptionDetail.Builder> getTagOptions() {
            return this.tagOptions != null ? (Collection)this.tagOptions.stream().map(TagOptionDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagOptions(Collection<TagOptionDetail> tagOptions) {
            this.tagOptions = TagOptionDetailsCopier.copy(tagOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptions(TagOptionDetail ... tagOptions) {
            this.tagOptions(Arrays.asList(tagOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptions(Consumer<TagOptionDetail.Builder> ... tagOptions) {
            this.tagOptions(Stream.of(tagOptions).map(c -> (TagOptionDetail)((TagOptionDetail.Builder)TagOptionDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagOptions(Collection<TagOptionDetail.BuilderImpl> tagOptions) {
            this.tagOptions = TagOptionDetailsCopier.copyFromBuilder(tagOptions);
        }

        @Override
        public DescribeProductAsAdminResponse build() {
            return new DescribeProductAsAdminResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProductAsAdminResponse> {
        public Builder productViewDetail(ProductViewDetail var1);

        default public Builder productViewDetail(Consumer<ProductViewDetail.Builder> productViewDetail) {
            return this.productViewDetail((ProductViewDetail)((ProductViewDetail.Builder)ProductViewDetail.builder().applyMutation(productViewDetail)).build());
        }

        public Builder provisioningArtifactSummaries(Collection<ProvisioningArtifactSummary> var1);

        public Builder provisioningArtifactSummaries(ProvisioningArtifactSummary ... var1);

        public Builder provisioningArtifactSummaries(Consumer<ProvisioningArtifactSummary.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder tagOptions(Collection<TagOptionDetail> var1);

        public Builder tagOptions(TagOptionDetail ... var1);

        public Builder tagOptions(Consumer<TagOptionDetail.Builder> ... var1);
    }
}

