/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse;

public class ListPrincipalsForPortfolioIterable
implements SdkIterable<ListPrincipalsForPortfolioResponse> {
    private final ServiceCatalogClient client;
    private final ListPrincipalsForPortfolioRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPrincipalsForPortfolioIterable(ServiceCatalogClient client, ListPrincipalsForPortfolioRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPrincipalsForPortfolioResponseFetcher();
    }

    public Iterator<ListPrincipalsForPortfolioResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListPrincipalsForPortfolioIterable resume(ListPrincipalsForPortfolioResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPrincipalsForPortfolioIterable(this.client, (ListPrincipalsForPortfolioRequest)((Object)this.firstRequest.toBuilder().pageToken(lastSuccessfulPage.nextPageToken()).build()));
        }
        return new ListPrincipalsForPortfolioIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListPrincipalsForPortfolioResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListPrincipalsForPortfolioResponseFetcher
    implements SyncPageFetcher<ListPrincipalsForPortfolioResponse> {
        private ListPrincipalsForPortfolioResponseFetcher() {
        }

        public boolean hasNextPage(ListPrincipalsForPortfolioResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListPrincipalsForPortfolioResponse nextPage(ListPrincipalsForPortfolioResponse previousPage) {
            if (previousPage == null) {
                return ListPrincipalsForPortfolioIterable.this.client.listPrincipalsForPortfolio(ListPrincipalsForPortfolioIterable.this.firstRequest);
            }
            return ListPrincipalsForPortfolioIterable.this.client.listPrincipalsForPortfolio((ListPrincipalsForPortfolioRequest)((Object)ListPrincipalsForPortfolioIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

