/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanSummary;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlansCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProvisionedProductPlansResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ListProvisionedProductPlansResponse> {
    private static final SdkField<List<ProvisionedProductPlanSummary>> PROVISIONED_PRODUCT_PLANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProvisionedProductPlans").getter(ListProvisionedProductPlansResponse.getter(ListProvisionedProductPlansResponse::provisionedProductPlans)).setter(ListProvisionedProductPlansResponse.setter(Builder::provisionedProductPlans)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductPlans").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProvisionedProductPlanSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(ListProvisionedProductPlansResponse.getter(ListProvisionedProductPlansResponse::nextPageToken)).setter(ListProvisionedProductPlansResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONED_PRODUCT_PLANS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListProvisionedProductPlansResponse.memberNameToFieldInitializer();
    private final List<ProvisionedProductPlanSummary> provisionedProductPlans;
    private final String nextPageToken;

    private ListProvisionedProductPlansResponse(BuilderImpl builder) {
        super(builder);
        this.provisionedProductPlans = builder.provisionedProductPlans;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasProvisionedProductPlans() {
        return this.provisionedProductPlans != null && !(this.provisionedProductPlans instanceof SdkAutoConstructList);
    }

    public final List<ProvisionedProductPlanSummary> provisionedProductPlans() {
        return this.provisionedProductPlans;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisionedProductPlans() ? this.provisionedProductPlans() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisionedProductPlansResponse)) {
            return false;
        }
        ListProvisionedProductPlansResponse other = (ListProvisionedProductPlansResponse)((Object)obj);
        return this.hasProvisionedProductPlans() == other.hasProvisionedProductPlans() && Objects.equals(this.provisionedProductPlans(), other.provisionedProductPlans()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListProvisionedProductPlansResponse").add("ProvisionedProductPlans", this.hasProvisionedProductPlans() ? this.provisionedProductPlans() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionedProductPlans": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductPlans()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProvisionedProductPlans", PROVISIONED_PRODUCT_PLANS_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProvisionedProductPlansResponse, T> g) {
        return obj -> g.apply((ListProvisionedProductPlansResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<ProvisionedProductPlanSummary> provisionedProductPlans = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisionedProductPlansResponse model) {
            super(model);
            this.provisionedProductPlans(model.provisionedProductPlans);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<ProvisionedProductPlanSummary.Builder> getProvisionedProductPlans() {
            List<ProvisionedProductPlanSummary.Builder> result = ProvisionedProductPlansCopier.copyToBuilder(this.provisionedProductPlans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisionedProductPlans(Collection<ProvisionedProductPlanSummary.BuilderImpl> provisionedProductPlans) {
            this.provisionedProductPlans = ProvisionedProductPlansCopier.copyFromBuilder(provisionedProductPlans);
        }

        @Override
        public final Builder provisionedProductPlans(Collection<ProvisionedProductPlanSummary> provisionedProductPlans) {
            this.provisionedProductPlans = ProvisionedProductPlansCopier.copy(provisionedProductPlans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedProductPlans(ProvisionedProductPlanSummary ... provisionedProductPlans) {
            this.provisionedProductPlans(Arrays.asList(provisionedProductPlans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedProductPlans(Consumer<ProvisionedProductPlanSummary.Builder> ... provisionedProductPlans) {
            this.provisionedProductPlans(Stream.of(provisionedProductPlans).map(c -> (ProvisionedProductPlanSummary)((ProvisionedProductPlanSummary.Builder)ProvisionedProductPlanSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public ListProvisionedProductPlansResponse build() {
            return new ListProvisionedProductPlansResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProvisionedProductPlansResponse> {
        public Builder provisionedProductPlans(Collection<ProvisionedProductPlanSummary> var1);

        public Builder provisionedProductPlans(ProvisionedProductPlanSummary ... var1);

        public Builder provisionedProductPlans(Consumer<ProvisionedProductPlanSummary.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

