/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ServiceActionSummariesCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceActionSummary;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServiceActionsResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ListServiceActionsResponse> {
    private static final SdkField<List<ServiceActionSummary>> SERVICE_ACTION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceActionSummaries").getter(ListServiceActionsResponse.getter(ListServiceActionsResponse::serviceActionSummaries)).setter(ListServiceActionsResponse.setter(Builder::serviceActionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceActionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceActionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(ListServiceActionsResponse.getter(ListServiceActionsResponse::nextPageToken)).setter(ListServiceActionsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACTION_SUMMARIES_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListServiceActionsResponse.memberNameToFieldInitializer();
    private final List<ServiceActionSummary> serviceActionSummaries;
    private final String nextPageToken;

    private ListServiceActionsResponse(BuilderImpl builder) {
        super(builder);
        this.serviceActionSummaries = builder.serviceActionSummaries;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasServiceActionSummaries() {
        return this.serviceActionSummaries != null && !(this.serviceActionSummaries instanceof SdkAutoConstructList);
    }

    public final List<ServiceActionSummary> serviceActionSummaries() {
        return this.serviceActionSummaries;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceActionSummaries() ? this.serviceActionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceActionsResponse)) {
            return false;
        }
        ListServiceActionsResponse other = (ListServiceActionsResponse)((Object)obj);
        return this.hasServiceActionSummaries() == other.hasServiceActionSummaries() && Objects.equals(this.serviceActionSummaries(), other.serviceActionSummaries()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListServiceActionsResponse").add("ServiceActionSummaries", this.hasServiceActionSummaries() ? this.serviceActionSummaries() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceActionSummaries": {
                return Optional.ofNullable(clazz.cast(this.serviceActionSummaries()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServiceActionSummaries", SERVICE_ACTION_SUMMARIES_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceActionsResponse, T> g) {
        return obj -> g.apply((ListServiceActionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<ServiceActionSummary> serviceActionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceActionsResponse model) {
            super(model);
            this.serviceActionSummaries(model.serviceActionSummaries);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<ServiceActionSummary.Builder> getServiceActionSummaries() {
            List<ServiceActionSummary.Builder> result = ServiceActionSummariesCopier.copyToBuilder(this.serviceActionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceActionSummaries(Collection<ServiceActionSummary.BuilderImpl> serviceActionSummaries) {
            this.serviceActionSummaries = ServiceActionSummariesCopier.copyFromBuilder(serviceActionSummaries);
        }

        @Override
        public final Builder serviceActionSummaries(Collection<ServiceActionSummary> serviceActionSummaries) {
            this.serviceActionSummaries = ServiceActionSummariesCopier.copy(serviceActionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceActionSummaries(ServiceActionSummary ... serviceActionSummaries) {
            this.serviceActionSummaries(Arrays.asList(serviceActionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceActionSummaries(Consumer<ServiceActionSummary.Builder> ... serviceActionSummaries) {
            this.serviceActionSummaries(Stream.of(serviceActionSummaries).map(c -> (ServiceActionSummary)((ServiceActionSummary.Builder)ServiceActionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public ListServiceActionsResponse build() {
            return new ListServiceActionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServiceActionsResponse> {
        public Builder serviceActionSummaries(Collection<ServiceActionSummary> var1);

        public Builder serviceActionSummaries(ServiceActionSummary ... var1);

        public Builder serviceActionSummaries(Consumer<ServiceActionSummary.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

