/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.CloudWatchDashboard;
import software.amazon.awssdk.services.servicecatalog.model.CloudWatchDashboardsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductDetail;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProvisionedProductResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, DescribeProvisionedProductResponse> {
    private static final SdkField<ProvisionedProductDetail> PROVISIONED_PRODUCT_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedProductDetail").getter(DescribeProvisionedProductResponse.getter(DescribeProvisionedProductResponse::provisionedProductDetail)).setter(DescribeProvisionedProductResponse.setter(Builder::provisionedProductDetail)).constructor(ProvisionedProductDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductDetail").build()}).build();
    private static final SdkField<List<CloudWatchDashboard>> CLOUD_WATCH_DASHBOARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CloudWatchDashboards").getter(DescribeProvisionedProductResponse.getter(DescribeProvisionedProductResponse::cloudWatchDashboards)).setter(DescribeProvisionedProductResponse.setter(Builder::cloudWatchDashboards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchDashboards").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudWatchDashboard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONED_PRODUCT_DETAIL_FIELD, CLOUD_WATCH_DASHBOARDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeProvisionedProductResponse.memberNameToFieldInitializer();
    private final ProvisionedProductDetail provisionedProductDetail;
    private final List<CloudWatchDashboard> cloudWatchDashboards;

    private DescribeProvisionedProductResponse(BuilderImpl builder) {
        super(builder);
        this.provisionedProductDetail = builder.provisionedProductDetail;
        this.cloudWatchDashboards = builder.cloudWatchDashboards;
    }

    public final ProvisionedProductDetail provisionedProductDetail() {
        return this.provisionedProductDetail;
    }

    public final boolean hasCloudWatchDashboards() {
        return this.cloudWatchDashboards != null && !(this.cloudWatchDashboards instanceof SdkAutoConstructList);
    }

    public final List<CloudWatchDashboard> cloudWatchDashboards() {
        return this.cloudWatchDashboards;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCloudWatchDashboards() ? this.cloudWatchDashboards() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProvisionedProductResponse)) {
            return false;
        }
        DescribeProvisionedProductResponse other = (DescribeProvisionedProductResponse)((Object)obj);
        return Objects.equals(this.provisionedProductDetail(), other.provisionedProductDetail()) && this.hasCloudWatchDashboards() == other.hasCloudWatchDashboards() && Objects.equals(this.cloudWatchDashboards(), other.cloudWatchDashboards());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeProvisionedProductResponse").add("ProvisionedProductDetail", (Object)this.provisionedProductDetail()).add("CloudWatchDashboards", this.hasCloudWatchDashboards() ? this.cloudWatchDashboards() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionedProductDetail": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductDetail()));
            }
            case "CloudWatchDashboards": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchDashboards()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProvisionedProductDetail", PROVISIONED_PRODUCT_DETAIL_FIELD);
        map.put("CloudWatchDashboards", CLOUD_WATCH_DASHBOARDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeProvisionedProductResponse, T> g) {
        return obj -> g.apply((DescribeProvisionedProductResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private ProvisionedProductDetail provisionedProductDetail;
        private List<CloudWatchDashboard> cloudWatchDashboards = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProvisionedProductResponse model) {
            super(model);
            this.provisionedProductDetail(model.provisionedProductDetail);
            this.cloudWatchDashboards(model.cloudWatchDashboards);
        }

        public final ProvisionedProductDetail.Builder getProvisionedProductDetail() {
            return this.provisionedProductDetail != null ? this.provisionedProductDetail.toBuilder() : null;
        }

        public final void setProvisionedProductDetail(ProvisionedProductDetail.BuilderImpl provisionedProductDetail) {
            this.provisionedProductDetail = provisionedProductDetail != null ? provisionedProductDetail.build() : null;
        }

        @Override
        public final Builder provisionedProductDetail(ProvisionedProductDetail provisionedProductDetail) {
            this.provisionedProductDetail = provisionedProductDetail;
            return this;
        }

        public final List<CloudWatchDashboard.Builder> getCloudWatchDashboards() {
            List<CloudWatchDashboard.Builder> result = CloudWatchDashboardsCopier.copyToBuilder(this.cloudWatchDashboards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudWatchDashboards(Collection<CloudWatchDashboard.BuilderImpl> cloudWatchDashboards) {
            this.cloudWatchDashboards = CloudWatchDashboardsCopier.copyFromBuilder(cloudWatchDashboards);
        }

        @Override
        public final Builder cloudWatchDashboards(Collection<CloudWatchDashboard> cloudWatchDashboards) {
            this.cloudWatchDashboards = CloudWatchDashboardsCopier.copy(cloudWatchDashboards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchDashboards(CloudWatchDashboard ... cloudWatchDashboards) {
            this.cloudWatchDashboards(Arrays.asList(cloudWatchDashboards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchDashboards(Consumer<CloudWatchDashboard.Builder> ... cloudWatchDashboards) {
            this.cloudWatchDashboards(Stream.of(cloudWatchDashboards).map(c -> (CloudWatchDashboard)((CloudWatchDashboard.Builder)CloudWatchDashboard.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeProvisionedProductResponse build() {
            return new DescribeProvisionedProductResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProvisionedProductResponse> {
        public Builder provisionedProductDetail(ProvisionedProductDetail var1);

        default public Builder provisionedProductDetail(Consumer<ProvisionedProductDetail.Builder> provisionedProductDetail) {
            return this.provisionedProductDetail((ProvisionedProductDetail)((ProvisionedProductDetail.Builder)ProvisionedProductDetail.builder().applyMutation(provisionedProductDetail)).build());
        }

        public Builder cloudWatchDashboards(Collection<CloudWatchDashboard> var1);

        public Builder cloudWatchDashboards(CloudWatchDashboard ... var1);

        public Builder cloudWatchDashboards(Consumer<CloudWatchDashboard.Builder> ... var1);
    }
}

