/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeStarParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeStarParameters> {
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionArn").getter(CodeStarParameters.getter(CodeStarParameters::connectionArn)).setter(CodeStarParameters.setter(Builder::connectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()}).build();
    private static final SdkField<String> REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Repository").getter(CodeStarParameters.getter(CodeStarParameters::repository)).setter(CodeStarParameters.setter(Builder::repository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Repository").build()}).build();
    private static final SdkField<String> BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Branch").getter(CodeStarParameters.getter(CodeStarParameters::branch)).setter(CodeStarParameters.setter(Builder::branch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Branch").build()}).build();
    private static final SdkField<String> ARTIFACT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactPath").getter(CodeStarParameters.getter(CodeStarParameters::artifactPath)).setter(CodeStarParameters.setter(Builder::artifactPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ARN_FIELD, REPOSITORY_FIELD, BRANCH_FIELD, ARTIFACT_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeStarParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String connectionArn;
    private final String repository;
    private final String branch;
    private final String artifactPath;

    private CodeStarParameters(BuilderImpl builder) {
        this.connectionArn = builder.connectionArn;
        this.repository = builder.repository;
        this.branch = builder.branch;
        this.artifactPath = builder.artifactPath;
    }

    public final String connectionArn() {
        return this.connectionArn;
    }

    public final String repository() {
        return this.repository;
    }

    public final String branch() {
        return this.branch;
    }

    public final String artifactPath() {
        return this.artifactPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.repository());
        hashCode = 31 * hashCode + Objects.hashCode(this.branch());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeStarParameters)) {
            return false;
        }
        CodeStarParameters other = (CodeStarParameters)obj;
        return Objects.equals(this.connectionArn(), other.connectionArn()) && Objects.equals(this.repository(), other.repository()) && Objects.equals(this.branch(), other.branch()) && Objects.equals(this.artifactPath(), other.artifactPath());
    }

    public final String toString() {
        return ToString.builder((String)"CodeStarParameters").add("ConnectionArn", (Object)this.connectionArn()).add("Repository", (Object)this.repository()).add("Branch", (Object)this.branch()).add("ArtifactPath", (Object)this.artifactPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.connectionArn()));
            }
            case "Repository": {
                return Optional.ofNullable(clazz.cast(this.repository()));
            }
            case "Branch": {
                return Optional.ofNullable(clazz.cast(this.branch()));
            }
            case "ArtifactPath": {
                return Optional.ofNullable(clazz.cast(this.artifactPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ConnectionArn", CONNECTION_ARN_FIELD);
        map.put("Repository", REPOSITORY_FIELD);
        map.put("Branch", BRANCH_FIELD);
        map.put("ArtifactPath", ARTIFACT_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeStarParameters, T> g) {
        return obj -> g.apply((CodeStarParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionArn;
        private String repository;
        private String branch;
        private String artifactPath;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeStarParameters model) {
            this.connectionArn(model.connectionArn);
            this.repository(model.repository);
            this.branch(model.branch);
            this.artifactPath(model.artifactPath);
        }

        public final String getConnectionArn() {
            return this.connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getRepository() {
            return this.repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getBranch() {
            return this.branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getArtifactPath() {
            return this.artifactPath;
        }

        public final void setArtifactPath(String artifactPath) {
            this.artifactPath = artifactPath;
        }

        @Override
        public final Builder artifactPath(String artifactPath) {
            this.artifactPath = artifactPath;
            return this;
        }

        public CodeStarParameters build() {
            return new CodeStarParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeStarParameters> {
        public Builder connectionArn(String var1);

        public Builder repository(String var1);

        public Builder branch(String var1);

        public Builder artifactPath(String var1);
    }
}

