/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.AddTagsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.services.servicecatalog.model.SourceConnection;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagKeysCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProductRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, UpdateProductRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptLanguage").getter(UpdateProductRequest.getter(UpdateProductRequest::acceptLanguage)).setter(UpdateProductRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateProductRequest.getter(UpdateProductRequest::id)).setter(UpdateProductRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateProductRequest.getter(UpdateProductRequest::name)).setter(UpdateProductRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(UpdateProductRequest.getter(UpdateProductRequest::owner)).setter(UpdateProductRequest.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateProductRequest.getter(UpdateProductRequest::description)).setter(UpdateProductRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DISTRIBUTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Distributor").getter(UpdateProductRequest.getter(UpdateProductRequest::distributor)).setter(UpdateProductRequest.setter(Builder::distributor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distributor").build()}).build();
    private static final SdkField<String> SUPPORT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupportDescription").getter(UpdateProductRequest.getter(UpdateProductRequest::supportDescription)).setter(UpdateProductRequest.setter(Builder::supportDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportDescription").build()}).build();
    private static final SdkField<String> SUPPORT_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupportEmail").getter(UpdateProductRequest.getter(UpdateProductRequest::supportEmail)).setter(UpdateProductRequest.setter(Builder::supportEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportEmail").build()}).build();
    private static final SdkField<String> SUPPORT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupportUrl").getter(UpdateProductRequest.getter(UpdateProductRequest::supportUrl)).setter(UpdateProductRequest.setter(Builder::supportUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportUrl").build()}).build();
    private static final SdkField<List<Tag>> ADD_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddTags").getter(UpdateProductRequest.getter(UpdateProductRequest::addTags)).setter(UpdateProductRequest.setter(Builder::addTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveTags").getter(UpdateProductRequest.getter(UpdateProductRequest::removeTags)).setter(UpdateProductRequest.setter(Builder::removeTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SourceConnection> SOURCE_CONNECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceConnection").getter(UpdateProductRequest.getter(UpdateProductRequest::sourceConnection)).setter(UpdateProductRequest.setter(Builder::sourceConnection)).constructor(SourceConnection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceConnection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, ID_FIELD, NAME_FIELD, OWNER_FIELD, DESCRIPTION_FIELD, DISTRIBUTOR_FIELD, SUPPORT_DESCRIPTION_FIELD, SUPPORT_EMAIL_FIELD, SUPPORT_URL_FIELD, ADD_TAGS_FIELD, REMOVE_TAGS_FIELD, SOURCE_CONNECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateProductRequest.memberNameToFieldInitializer();
    private final String acceptLanguage;
    private final String id;
    private final String name;
    private final String owner;
    private final String description;
    private final String distributor;
    private final String supportDescription;
    private final String supportEmail;
    private final String supportUrl;
    private final List<Tag> addTags;
    private final List<String> removeTags;
    private final SourceConnection sourceConnection;

    private UpdateProductRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.id = builder.id;
        this.name = builder.name;
        this.owner = builder.owner;
        this.description = builder.description;
        this.distributor = builder.distributor;
        this.supportDescription = builder.supportDescription;
        this.supportEmail = builder.supportEmail;
        this.supportUrl = builder.supportUrl;
        this.addTags = builder.addTags;
        this.removeTags = builder.removeTags;
        this.sourceConnection = builder.sourceConnection;
    }

    public final String acceptLanguage() {
        return this.acceptLanguage;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String owner() {
        return this.owner;
    }

    public final String description() {
        return this.description;
    }

    public final String distributor() {
        return this.distributor;
    }

    public final String supportDescription() {
        return this.supportDescription;
    }

    public final String supportEmail() {
        return this.supportEmail;
    }

    public final String supportUrl() {
        return this.supportUrl;
    }

    public final boolean hasAddTags() {
        return this.addTags != null && !(this.addTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> addTags() {
        return this.addTags;
    }

    public final boolean hasRemoveTags() {
        return this.removeTags != null && !(this.removeTags instanceof SdkAutoConstructList);
    }

    public final List<String> removeTags() {
        return this.removeTags;
    }

    public final SourceConnection sourceConnection() {
        return this.sourceConnection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributor());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddTags() ? this.addTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveTags() ? this.removeTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConnection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProductRequest)) {
            return false;
        }
        UpdateProductRequest other = (UpdateProductRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.distributor(), other.distributor()) && Objects.equals(this.supportDescription(), other.supportDescription()) && Objects.equals(this.supportEmail(), other.supportEmail()) && Objects.equals(this.supportUrl(), other.supportUrl()) && this.hasAddTags() == other.hasAddTags() && Objects.equals(this.addTags(), other.addTags()) && this.hasRemoveTags() == other.hasRemoveTags() && Objects.equals(this.removeTags(), other.removeTags()) && Objects.equals(this.sourceConnection(), other.sourceConnection());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProductRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Owner", (Object)this.owner()).add("Description", (Object)this.description()).add("Distributor", (Object)this.distributor()).add("SupportDescription", (Object)this.supportDescription()).add("SupportEmail", (Object)this.supportEmail()).add("SupportUrl", (Object)this.supportUrl()).add("AddTags", this.hasAddTags() ? this.addTags() : null).add("RemoveTags", this.hasRemoveTags() ? this.removeTags() : null).add("SourceConnection", (Object)this.sourceConnection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Distributor": {
                return Optional.ofNullable(clazz.cast(this.distributor()));
            }
            case "SupportDescription": {
                return Optional.ofNullable(clazz.cast(this.supportDescription()));
            }
            case "SupportEmail": {
                return Optional.ofNullable(clazz.cast(this.supportEmail()));
            }
            case "SupportUrl": {
                return Optional.ofNullable(clazz.cast(this.supportUrl()));
            }
            case "AddTags": {
                return Optional.ofNullable(clazz.cast(this.addTags()));
            }
            case "RemoveTags": {
                return Optional.ofNullable(clazz.cast(this.removeTags()));
            }
            case "SourceConnection": {
                return Optional.ofNullable(clazz.cast(this.sourceConnection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AcceptLanguage", ACCEPT_LANGUAGE_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Distributor", DISTRIBUTOR_FIELD);
        map.put("SupportDescription", SUPPORT_DESCRIPTION_FIELD);
        map.put("SupportEmail", SUPPORT_EMAIL_FIELD);
        map.put("SupportUrl", SUPPORT_URL_FIELD);
        map.put("AddTags", ADD_TAGS_FIELD);
        map.put("RemoveTags", REMOVE_TAGS_FIELD);
        map.put("SourceConnection", SOURCE_CONNECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProductRequest, T> g) {
        return obj -> g.apply((UpdateProductRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String id;
        private String name;
        private String owner;
        private String description;
        private String distributor;
        private String supportDescription;
        private String supportEmail;
        private String supportUrl;
        private List<Tag> addTags = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeTags = DefaultSdkAutoConstructList.getInstance();
        private SourceConnection sourceConnection;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProductRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.id(model.id);
            this.name(model.name);
            this.owner(model.owner);
            this.description(model.description);
            this.distributor(model.distributor);
            this.supportDescription(model.supportDescription);
            this.supportEmail(model.supportEmail);
            this.supportUrl(model.supportUrl);
            this.addTags(model.addTags);
            this.removeTags(model.removeTags);
            this.sourceConnection(model.sourceConnection);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDistributor() {
            return this.distributor;
        }

        public final void setDistributor(String distributor) {
            this.distributor = distributor;
        }

        @Override
        public final Builder distributor(String distributor) {
            this.distributor = distributor;
            return this;
        }

        public final String getSupportDescription() {
            return this.supportDescription;
        }

        public final void setSupportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
        }

        @Override
        public final Builder supportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
            return this;
        }

        public final String getSupportEmail() {
            return this.supportEmail;
        }

        public final void setSupportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
        }

        @Override
        public final Builder supportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
            return this;
        }

        public final String getSupportUrl() {
            return this.supportUrl;
        }

        public final void setSupportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
        }

        @Override
        public final Builder supportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
            return this;
        }

        public final List<Tag.Builder> getAddTags() {
            List<Tag.Builder> result = AddTagsCopier.copyToBuilder(this.addTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddTags(Collection<Tag.BuilderImpl> addTags) {
            this.addTags = AddTagsCopier.copyFromBuilder(addTags);
        }

        @Override
        public final Builder addTags(Collection<Tag> addTags) {
            this.addTags = AddTagsCopier.copy(addTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Tag ... addTags) {
            this.addTags(Arrays.asList(addTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Consumer<Tag.Builder> ... addTags) {
            this.addTags(Stream.of(addTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRemoveTags() {
            if (this.removeTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeTags;
        }

        public final void setRemoveTags(Collection<String> removeTags) {
            this.removeTags = TagKeysCopier.copy(removeTags);
        }

        @Override
        public final Builder removeTags(Collection<String> removeTags) {
            this.removeTags = TagKeysCopier.copy(removeTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeTags(String ... removeTags) {
            this.removeTags(Arrays.asList(removeTags));
            return this;
        }

        public final SourceConnection.Builder getSourceConnection() {
            return this.sourceConnection != null ? this.sourceConnection.toBuilder() : null;
        }

        public final void setSourceConnection(SourceConnection.BuilderImpl sourceConnection) {
            this.sourceConnection = sourceConnection != null ? sourceConnection.build() : null;
        }

        @Override
        public final Builder sourceConnection(SourceConnection sourceConnection) {
            this.sourceConnection = sourceConnection;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProductRequest build() {
            return new UpdateProductRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProductRequest> {
        public Builder acceptLanguage(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder owner(String var1);

        public Builder description(String var1);

        public Builder distributor(String var1);

        public Builder supportDescription(String var1);

        public Builder supportEmail(String var1);

        public Builder supportUrl(String var1);

        public Builder addTags(Collection<Tag> var1);

        public Builder addTags(Tag ... var1);

        public Builder addTags(Consumer<Tag.Builder> ... var1);

        public Builder removeTags(Collection<String> var1);

        public Builder removeTags(String ... var1);

        public Builder sourceConnection(SourceConnection var1);

        default public Builder sourceConnection(Consumer<SourceConnection.Builder> sourceConnection) {
            return this.sourceConnection((SourceConnection)((SourceConnection.Builder)SourceConnection.builder().applyMutation(sourceConnection)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

