/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ProductType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductViewSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProductViewSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ProductViewSummary.getter(ProductViewSummary::id)).setter(ProductViewSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductId").getter(ProductViewSummary.getter(ProductViewSummary::productId)).setter(ProductViewSummary.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ProductViewSummary.getter(ProductViewSummary::name)).setter(ProductViewSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(ProductViewSummary.getter(ProductViewSummary::owner)).setter(ProductViewSummary.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> SHORT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShortDescription").getter(ProductViewSummary.getter(ProductViewSummary::shortDescription)).setter(ProductViewSummary.setter(Builder::shortDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShortDescription").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ProductViewSummary.getter(ProductViewSummary::typeAsString)).setter(ProductViewSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> DISTRIBUTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Distributor").getter(ProductViewSummary.getter(ProductViewSummary::distributor)).setter(ProductViewSummary.setter(Builder::distributor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distributor").build()}).build();
    private static final SdkField<Boolean> HAS_DEFAULT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HasDefaultPath").getter(ProductViewSummary.getter(ProductViewSummary::hasDefaultPath)).setter(ProductViewSummary.setter(Builder::hasDefaultPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasDefaultPath").build()}).build();
    private static final SdkField<String> SUPPORT_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupportEmail").getter(ProductViewSummary.getter(ProductViewSummary::supportEmail)).setter(ProductViewSummary.setter(Builder::supportEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportEmail").build()}).build();
    private static final SdkField<String> SUPPORT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupportDescription").getter(ProductViewSummary.getter(ProductViewSummary::supportDescription)).setter(ProductViewSummary.setter(Builder::supportDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportDescription").build()}).build();
    private static final SdkField<String> SUPPORT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupportUrl").getter(ProductViewSummary.getter(ProductViewSummary::supportUrl)).setter(ProductViewSummary.setter(Builder::supportUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PRODUCT_ID_FIELD, NAME_FIELD, OWNER_FIELD, SHORT_DESCRIPTION_FIELD, TYPE_FIELD, DISTRIBUTOR_FIELD, HAS_DEFAULT_PATH_FIELD, SUPPORT_EMAIL_FIELD, SUPPORT_DESCRIPTION_FIELD, SUPPORT_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProductViewSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String productId;
    private final String name;
    private final String owner;
    private final String shortDescription;
    private final String type;
    private final String distributor;
    private final Boolean hasDefaultPath;
    private final String supportEmail;
    private final String supportDescription;
    private final String supportUrl;

    private ProductViewSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.productId = builder.productId;
        this.name = builder.name;
        this.owner = builder.owner;
        this.shortDescription = builder.shortDescription;
        this.type = builder.type;
        this.distributor = builder.distributor;
        this.hasDefaultPath = builder.hasDefaultPath;
        this.supportEmail = builder.supportEmail;
        this.supportDescription = builder.supportDescription;
        this.supportUrl = builder.supportUrl;
    }

    public final String id() {
        return this.id;
    }

    public final String productId() {
        return this.productId;
    }

    public final String name() {
        return this.name;
    }

    public final String owner() {
        return this.owner;
    }

    public final String shortDescription() {
        return this.shortDescription;
    }

    public final ProductType type() {
        return ProductType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String distributor() {
        return this.distributor;
    }

    public final Boolean hasDefaultPath() {
        return this.hasDefaultPath;
    }

    public final String supportEmail() {
        return this.supportEmail;
    }

    public final String supportDescription() {
        return this.supportDescription;
    }

    public final String supportUrl() {
        return this.supportUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.shortDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributor());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductViewSummary)) {
            return false;
        }
        ProductViewSummary other = (ProductViewSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.shortDescription(), other.shortDescription()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.distributor(), other.distributor()) && Objects.equals(this.hasDefaultPath(), other.hasDefaultPath()) && Objects.equals(this.supportEmail(), other.supportEmail()) && Objects.equals(this.supportDescription(), other.supportDescription()) && Objects.equals(this.supportUrl(), other.supportUrl());
    }

    public final String toString() {
        return ToString.builder((String)"ProductViewSummary").add("Id", (Object)this.id()).add("ProductId", (Object)this.productId()).add("Name", (Object)this.name()).add("Owner", (Object)this.owner()).add("ShortDescription", (Object)this.shortDescription()).add("Type", (Object)this.typeAsString()).add("Distributor", (Object)this.distributor()).add("HasDefaultPath", (Object)this.hasDefaultPath()).add("SupportEmail", (Object)this.supportEmail()).add("SupportDescription", (Object)this.supportDescription()).add("SupportUrl", (Object)this.supportUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "ShortDescription": {
                return Optional.ofNullable(clazz.cast(this.shortDescription()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Distributor": {
                return Optional.ofNullable(clazz.cast(this.distributor()));
            }
            case "HasDefaultPath": {
                return Optional.ofNullable(clazz.cast(this.hasDefaultPath()));
            }
            case "SupportEmail": {
                return Optional.ofNullable(clazz.cast(this.supportEmail()));
            }
            case "SupportDescription": {
                return Optional.ofNullable(clazz.cast(this.supportDescription()));
            }
            case "SupportUrl": {
                return Optional.ofNullable(clazz.cast(this.supportUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("ProductId", PRODUCT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("ShortDescription", SHORT_DESCRIPTION_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Distributor", DISTRIBUTOR_FIELD);
        map.put("HasDefaultPath", HAS_DEFAULT_PATH_FIELD);
        map.put("SupportEmail", SUPPORT_EMAIL_FIELD);
        map.put("SupportDescription", SUPPORT_DESCRIPTION_FIELD);
        map.put("SupportUrl", SUPPORT_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProductViewSummary, T> g) {
        return obj -> g.apply((ProductViewSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String productId;
        private String name;
        private String owner;
        private String shortDescription;
        private String type;
        private String distributor;
        private Boolean hasDefaultPath;
        private String supportEmail;
        private String supportDescription;
        private String supportUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductViewSummary model) {
            this.id(model.id);
            this.productId(model.productId);
            this.name(model.name);
            this.owner(model.owner);
            this.shortDescription(model.shortDescription);
            this.type(model.type);
            this.distributor(model.distributor);
            this.hasDefaultPath(model.hasDefaultPath);
            this.supportEmail(model.supportEmail);
            this.supportDescription(model.supportDescription);
            this.supportUrl(model.supportUrl);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getProductId() {
            return this.productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getShortDescription() {
            return this.shortDescription;
        }

        public final void setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
        }

        @Override
        public final Builder shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProductType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDistributor() {
            return this.distributor;
        }

        public final void setDistributor(String distributor) {
            this.distributor = distributor;
        }

        @Override
        public final Builder distributor(String distributor) {
            this.distributor = distributor;
            return this;
        }

        public final Boolean getHasDefaultPath() {
            return this.hasDefaultPath;
        }

        public final void setHasDefaultPath(Boolean hasDefaultPath) {
            this.hasDefaultPath = hasDefaultPath;
        }

        @Override
        public final Builder hasDefaultPath(Boolean hasDefaultPath) {
            this.hasDefaultPath = hasDefaultPath;
            return this;
        }

        public final String getSupportEmail() {
            return this.supportEmail;
        }

        public final void setSupportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
        }

        @Override
        public final Builder supportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
            return this;
        }

        public final String getSupportDescription() {
            return this.supportDescription;
        }

        public final void setSupportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
        }

        @Override
        public final Builder supportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
            return this;
        }

        public final String getSupportUrl() {
            return this.supportUrl;
        }

        public final void setSupportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
        }

        @Override
        public final Builder supportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
            return this;
        }

        public ProductViewSummary build() {
            return new ProductViewSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProductViewSummary> {
        public Builder id(String var1);

        public Builder productId(String var1);

        public Builder name(String var1);

        public Builder owner(String var1);

        public Builder shortDescription(String var1);

        public Builder type(String var1);

        public Builder type(ProductType var1);

        public Builder distributor(String var1);

        public Builder hasDefaultPath(Boolean var1);

        public Builder supportEmail(String var1);

        public Builder supportDescription(String var1);

        public Builder supportUrl(String var1);
    }
}

