/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse;

public class ListPrincipalsForPortfolioPublisher
implements SdkPublisher<ListPrincipalsForPortfolioResponse> {
    private final ServiceCatalogAsyncClient client;
    private final ListPrincipalsForPortfolioRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPrincipalsForPortfolioPublisher(ServiceCatalogAsyncClient client, ListPrincipalsForPortfolioRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPrincipalsForPortfolioPublisher(ServiceCatalogAsyncClient client, ListPrincipalsForPortfolioRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPrincipalsForPortfolioResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPrincipalsForPortfolioResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListPrincipalsForPortfolioPublisher resume(ListPrincipalsForPortfolioResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPrincipalsForPortfolioPublisher(this.client, (ListPrincipalsForPortfolioRequest)((Object)this.firstRequest.toBuilder().pageToken(lastSuccessfulPage.nextPageToken()).build()));
        }
        return new ListPrincipalsForPortfolioPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListPrincipalsForPortfolioResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListPrincipalsForPortfolioResponseFetcher
    implements AsyncPageFetcher<ListPrincipalsForPortfolioResponse> {
        private ListPrincipalsForPortfolioResponseFetcher() {
        }

        public boolean hasNextPage(ListPrincipalsForPortfolioResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<ListPrincipalsForPortfolioResponse> nextPage(ListPrincipalsForPortfolioResponse previousPage) {
            if (previousPage == null) {
                return ListPrincipalsForPortfolioPublisher.this.client.listPrincipalsForPortfolio(ListPrincipalsForPortfolioPublisher.this.firstRequest);
            }
            return ListPrincipalsForPortfolioPublisher.this.client.listPrincipalsForPortfolio((ListPrincipalsForPortfolioRequest)((Object)ListPrincipalsForPortfolioPublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

