/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServiceActionsForProvisioningArtifactRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, ListServiceActionsForProvisioningArtifactRequest> {
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductId").getter(ListServiceActionsForProvisioningArtifactRequest.getter(ListServiceActionsForProvisioningArtifactRequest::productId)).setter(ListServiceActionsForProvisioningArtifactRequest.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningArtifactId").getter(ListServiceActionsForProvisioningArtifactRequest.getter(ListServiceActionsForProvisioningArtifactRequest::provisioningArtifactId)).setter(ListServiceActionsForProvisioningArtifactRequest.setter(Builder::provisioningArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSize").getter(ListServiceActionsForProvisioningArtifactRequest.getter(ListServiceActionsForProvisioningArtifactRequest::pageSize)).setter(ListServiceActionsForProvisioningArtifactRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PageToken").getter(ListServiceActionsForProvisioningArtifactRequest.getter(ListServiceActionsForProvisioningArtifactRequest::pageToken)).setter(ListServiceActionsForProvisioningArtifactRequest.setter(Builder::pageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()}).build();
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptLanguage").getter(ListServiceActionsForProvisioningArtifactRequest.getter(ListServiceActionsForProvisioningArtifactRequest::acceptLanguage)).setter(ListServiceActionsForProvisioningArtifactRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_ID_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, PAGE_SIZE_FIELD, PAGE_TOKEN_FIELD, ACCEPT_LANGUAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProductId", PRODUCT_ID_FIELD);
            this.put("ProvisioningArtifactId", PROVISIONING_ARTIFACT_ID_FIELD);
            this.put("PageSize", PAGE_SIZE_FIELD);
            this.put("PageToken", PAGE_TOKEN_FIELD);
            this.put("AcceptLanguage", ACCEPT_LANGUAGE_FIELD);
        }
    });
    private final String productId;
    private final String provisioningArtifactId;
    private final Integer pageSize;
    private final String pageToken;
    private final String acceptLanguage;

    private ListServiceActionsForProvisioningArtifactRequest(BuilderImpl builder) {
        super(builder);
        this.productId = builder.productId;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.pageSize = builder.pageSize;
        this.pageToken = builder.pageToken;
        this.acceptLanguage = builder.acceptLanguage;
    }

    public final String productId() {
        return this.productId;
    }

    public final String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public final Integer pageSize() {
        return this.pageSize;
    }

    public final String pageToken() {
        return this.pageToken;
    }

    public final String acceptLanguage() {
        return this.acceptLanguage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceActionsForProvisioningArtifactRequest)) {
            return false;
        }
        ListServiceActionsForProvisioningArtifactRequest other = (ListServiceActionsForProvisioningArtifactRequest)((Object)obj);
        return Objects.equals(this.productId(), other.productId()) && Objects.equals(this.provisioningArtifactId(), other.provisioningArtifactId()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.pageToken(), other.pageToken()) && Objects.equals(this.acceptLanguage(), other.acceptLanguage());
    }

    public final String toString() {
        return ToString.builder((String)"ListServiceActionsForProvisioningArtifactRequest").add("ProductId", (Object)this.productId()).add("ProvisioningArtifactId", (Object)this.provisioningArtifactId()).add("PageSize", (Object)this.pageSize()).add("PageToken", (Object)this.pageToken()).add("AcceptLanguage", (Object)this.acceptLanguage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "ProvisioningArtifactId": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactId()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "PageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListServiceActionsForProvisioningArtifactRequest, T> g) {
        return obj -> g.apply((ListServiceActionsForProvisioningArtifactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String productId;
        private String provisioningArtifactId;
        private Integer pageSize;
        private String pageToken;
        private String acceptLanguage;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceActionsForProvisioningArtifactRequest model) {
            super(model);
            this.productId(model.productId);
            this.provisioningArtifactId(model.provisioningArtifactId);
            this.pageSize(model.pageSize);
            this.pageToken(model.pageToken);
            this.acceptLanguage(model.acceptLanguage);
        }

        public final String getProductId() {
            return this.productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServiceActionsForProvisioningArtifactRequest build() {
            return new ListServiceActionsForProvisioningArtifactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServiceActionsForProvisioningArtifactRequest> {
        public Builder productId(String var1);

        public Builder provisioningArtifactId(String var1);

        public Builder pageSize(Integer var1);

        public Builder pageToken(String var1);

        public Builder acceptLanguage(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

