/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.OutputKeysCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProvisionedProductOutputsRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, GetProvisionedProductOutputsRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptLanguage").getter(GetProvisionedProductOutputsRequest.getter(GetProvisionedProductOutputsRequest::acceptLanguage)).setter(GetProvisionedProductOutputsRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> PROVISIONED_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionedProductId").getter(GetProvisionedProductOutputsRequest.getter(GetProvisionedProductOutputsRequest::provisionedProductId)).setter(GetProvisionedProductOutputsRequest.setter(Builder::provisionedProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductId").build()}).build();
    private static final SdkField<String> PROVISIONED_PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionedProductName").getter(GetProvisionedProductOutputsRequest.getter(GetProvisionedProductOutputsRequest::provisionedProductName)).setter(GetProvisionedProductOutputsRequest.setter(Builder::provisionedProductName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductName").build()}).build();
    private static final SdkField<List<String>> OUTPUT_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutputKeys").getter(GetProvisionedProductOutputsRequest.getter(GetProvisionedProductOutputsRequest::outputKeys)).setter(GetProvisionedProductOutputsRequest.setter(Builder::outputKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSize").getter(GetProvisionedProductOutputsRequest.getter(GetProvisionedProductOutputsRequest::pageSize)).setter(GetProvisionedProductOutputsRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PageToken").getter(GetProvisionedProductOutputsRequest.getter(GetProvisionedProductOutputsRequest::pageToken)).setter(GetProvisionedProductOutputsRequest.setter(Builder::pageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, PROVISIONED_PRODUCT_ID_FIELD, PROVISIONED_PRODUCT_NAME_FIELD, OUTPUT_KEYS_FIELD, PAGE_SIZE_FIELD, PAGE_TOKEN_FIELD));
    private final String acceptLanguage;
    private final String provisionedProductId;
    private final String provisionedProductName;
    private final List<String> outputKeys;
    private final Integer pageSize;
    private final String pageToken;

    private GetProvisionedProductOutputsRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.provisionedProductId = builder.provisionedProductId;
        this.provisionedProductName = builder.provisionedProductName;
        this.outputKeys = builder.outputKeys;
        this.pageSize = builder.pageSize;
        this.pageToken = builder.pageToken;
    }

    public final String acceptLanguage() {
        return this.acceptLanguage;
    }

    public final String provisionedProductId() {
        return this.provisionedProductId;
    }

    public final String provisionedProductName() {
        return this.provisionedProductName;
    }

    public final boolean hasOutputKeys() {
        return this.outputKeys != null && !(this.outputKeys instanceof SdkAutoConstructList);
    }

    public final List<String> outputKeys() {
        return this.outputKeys;
    }

    public final Integer pageSize() {
        return this.pageSize;
    }

    public final String pageToken() {
        return this.pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputKeys() ? this.outputKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProvisionedProductOutputsRequest)) {
            return false;
        }
        GetProvisionedProductOutputsRequest other = (GetProvisionedProductOutputsRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.provisionedProductId(), other.provisionedProductId()) && Objects.equals(this.provisionedProductName(), other.provisionedProductName()) && this.hasOutputKeys() == other.hasOutputKeys() && Objects.equals(this.outputKeys(), other.outputKeys()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.pageToken(), other.pageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetProvisionedProductOutputsRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("ProvisionedProductId", (Object)this.provisionedProductId()).add("ProvisionedProductName", (Object)this.provisionedProductName()).add("OutputKeys", this.hasOutputKeys() ? this.outputKeys() : null).add("PageSize", (Object)this.pageSize()).add("PageToken", (Object)this.pageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "ProvisionedProductId": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductId()));
            }
            case "ProvisionedProductName": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductName()));
            }
            case "OutputKeys": {
                return Optional.ofNullable(clazz.cast(this.outputKeys()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "PageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProvisionedProductOutputsRequest, T> g) {
        return obj -> g.apply((GetProvisionedProductOutputsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String provisionedProductId;
        private String provisionedProductName;
        private List<String> outputKeys = DefaultSdkAutoConstructList.getInstance();
        private Integer pageSize;
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProvisionedProductOutputsRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.provisionedProductId(model.provisionedProductId);
            this.provisionedProductName(model.provisionedProductName);
            this.outputKeys(model.outputKeys);
            this.pageSize(model.pageSize);
            this.pageToken(model.pageToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getProvisionedProductId() {
            return this.provisionedProductId;
        }

        public final void setProvisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
        }

        @Override
        public final Builder provisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
            return this;
        }

        public final String getProvisionedProductName() {
            return this.provisionedProductName;
        }

        public final void setProvisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
        }

        @Override
        public final Builder provisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
            return this;
        }

        public final Collection<String> getOutputKeys() {
            if (this.outputKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.outputKeys;
        }

        public final void setOutputKeys(Collection<String> outputKeys) {
            this.outputKeys = OutputKeysCopier.copy(outputKeys);
        }

        @Override
        public final Builder outputKeys(Collection<String> outputKeys) {
            this.outputKeys = OutputKeysCopier.copy(outputKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputKeys(String ... outputKeys) {
            this.outputKeys(Arrays.asList(outputKeys));
            return this;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetProvisionedProductOutputsRequest build() {
            return new GetProvisionedProductOutputsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProvisionedProductOutputsRequest> {
        public Builder acceptLanguage(String var1);

        public Builder provisionedProductId(String var1);

        public Builder provisionedProductName(String var1);

        public Builder outputKeys(Collection<String> var1);

        public Builder outputKeys(String ... var1);

        public Builder pageSize(Integer var1);

        public Builder pageToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

