/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.BudgetDetail;
import software.amazon.awssdk.services.servicecatalog.model.BudgetsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBudgetsForResourceResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ListBudgetsForResourceResponse> {
    private static final SdkField<List<BudgetDetail>> BUDGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Budgets").getter(ListBudgetsForResourceResponse.getter(ListBudgetsForResourceResponse::budgets)).setter(ListBudgetsForResourceResponse.setter(Builder::budgets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Budgets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BudgetDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(ListBudgetsForResourceResponse.getter(ListBudgetsForResourceResponse::nextPageToken)).setter(ListBudgetsForResourceResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUDGETS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<BudgetDetail> budgets;
    private final String nextPageToken;

    private ListBudgetsForResourceResponse(BuilderImpl builder) {
        super(builder);
        this.budgets = builder.budgets;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasBudgets() {
        return this.budgets != null && !(this.budgets instanceof SdkAutoConstructList);
    }

    public final List<BudgetDetail> budgets() {
        return this.budgets;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBudgets() ? this.budgets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBudgetsForResourceResponse)) {
            return false;
        }
        ListBudgetsForResourceResponse other = (ListBudgetsForResourceResponse)((Object)obj);
        return this.hasBudgets() == other.hasBudgets() && Objects.equals(this.budgets(), other.budgets()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBudgetsForResourceResponse").add("Budgets", this.hasBudgets() ? this.budgets() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Budgets": {
                return Optional.ofNullable(clazz.cast(this.budgets()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBudgetsForResourceResponse, T> g) {
        return obj -> g.apply((ListBudgetsForResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<BudgetDetail> budgets = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBudgetsForResourceResponse model) {
            super(model);
            this.budgets(model.budgets);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<BudgetDetail.Builder> getBudgets() {
            List<BudgetDetail.Builder> result = BudgetsCopier.copyToBuilder(this.budgets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBudgets(Collection<BudgetDetail.BuilderImpl> budgets) {
            this.budgets = BudgetsCopier.copyFromBuilder(budgets);
        }

        @Override
        public final Builder budgets(Collection<BudgetDetail> budgets) {
            this.budgets = BudgetsCopier.copy(budgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgets(BudgetDetail ... budgets) {
            this.budgets(Arrays.asList(budgets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgets(Consumer<BudgetDetail.Builder> ... budgets) {
            this.budgets(Stream.of(budgets).map(c -> (BudgetDetail)((BudgetDetail.Builder)BudgetDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public ListBudgetsForResourceResponse build() {
            return new ListBudgetsForResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBudgetsForResourceResponse> {
        public Builder budgets(Collection<BudgetDetail> var1);

        public Builder budgets(BudgetDetail ... var1);

        public Builder budgets(Consumer<BudgetDetail.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

