/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.FailedServiceActionAssociation;
import software.amazon.awssdk.services.servicecatalog.model.FailedServiceActionAssociationsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchAssociateServiceActionWithProvisioningArtifactResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, BatchAssociateServiceActionWithProvisioningArtifactResponse> {
    private static final SdkField<List<FailedServiceActionAssociation>> FAILED_SERVICE_ACTION_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedServiceActionAssociations").getter(BatchAssociateServiceActionWithProvisioningArtifactResponse.getter(BatchAssociateServiceActionWithProvisioningArtifactResponse::failedServiceActionAssociations)).setter(BatchAssociateServiceActionWithProvisioningArtifactResponse.setter(Builder::failedServiceActionAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedServiceActionAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedServiceActionAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_SERVICE_ACTION_ASSOCIATIONS_FIELD));
    private final List<FailedServiceActionAssociation> failedServiceActionAssociations;

    private BatchAssociateServiceActionWithProvisioningArtifactResponse(BuilderImpl builder) {
        super(builder);
        this.failedServiceActionAssociations = builder.failedServiceActionAssociations;
    }

    public final boolean hasFailedServiceActionAssociations() {
        return this.failedServiceActionAssociations != null && !(this.failedServiceActionAssociations instanceof SdkAutoConstructList);
    }

    public final List<FailedServiceActionAssociation> failedServiceActionAssociations() {
        return this.failedServiceActionAssociations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedServiceActionAssociations() ? this.failedServiceActionAssociations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateServiceActionWithProvisioningArtifactResponse)) {
            return false;
        }
        BatchAssociateServiceActionWithProvisioningArtifactResponse other = (BatchAssociateServiceActionWithProvisioningArtifactResponse)((Object)obj);
        return this.hasFailedServiceActionAssociations() == other.hasFailedServiceActionAssociations() && Objects.equals(this.failedServiceActionAssociations(), other.failedServiceActionAssociations());
    }

    public final String toString() {
        return ToString.builder((String)"BatchAssociateServiceActionWithProvisioningArtifactResponse").add("FailedServiceActionAssociations", this.hasFailedServiceActionAssociations() ? this.failedServiceActionAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedServiceActionAssociations": {
                return Optional.ofNullable(clazz.cast(this.failedServiceActionAssociations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateServiceActionWithProvisioningArtifactResponse, T> g) {
        return obj -> g.apply((BatchAssociateServiceActionWithProvisioningArtifactResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<FailedServiceActionAssociation> failedServiceActionAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateServiceActionWithProvisioningArtifactResponse model) {
            super(model);
            this.failedServiceActionAssociations(model.failedServiceActionAssociations);
        }

        public final List<FailedServiceActionAssociation.Builder> getFailedServiceActionAssociations() {
            List<FailedServiceActionAssociation.Builder> result = FailedServiceActionAssociationsCopier.copyToBuilder(this.failedServiceActionAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedServiceActionAssociations(Collection<FailedServiceActionAssociation.BuilderImpl> failedServiceActionAssociations) {
            this.failedServiceActionAssociations = FailedServiceActionAssociationsCopier.copyFromBuilder(failedServiceActionAssociations);
        }

        @Override
        public final Builder failedServiceActionAssociations(Collection<FailedServiceActionAssociation> failedServiceActionAssociations) {
            this.failedServiceActionAssociations = FailedServiceActionAssociationsCopier.copy(failedServiceActionAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedServiceActionAssociations(FailedServiceActionAssociation ... failedServiceActionAssociations) {
            this.failedServiceActionAssociations(Arrays.asList(failedServiceActionAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedServiceActionAssociations(Consumer<FailedServiceActionAssociation.Builder> ... failedServiceActionAssociations) {
            this.failedServiceActionAssociations(Stream.of(failedServiceActionAssociations).map(c -> (FailedServiceActionAssociation)((FailedServiceActionAssociation.Builder)FailedServiceActionAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchAssociateServiceActionWithProvisioningArtifactResponse build() {
            return new BatchAssociateServiceActionWithProvisioningArtifactResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchAssociateServiceActionWithProvisioningArtifactResponse> {
        public Builder failedServiceActionAssociations(Collection<FailedServiceActionAssociation> var1);

        public Builder failedServiceActionAssociations(FailedServiceActionAssociation ... var1);

        public Builder failedServiceActionAssociations(Consumer<FailedServiceActionAssociation.Builder> ... var1);
    }
}

