/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceAttribute {
    PROPERTIES("PROPERTIES"),
    METADATA("METADATA"),
    CREATIONPOLICY("CREATIONPOLICY"),
    UPDATEPOLICY("UPDATEPOLICY"),
    DELETIONPOLICY("DELETIONPOLICY"),
    TAGS("TAGS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceAttribute> VALUE_MAP;
    private final String value;

    private ResourceAttribute(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceAttribute fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceAttribute> knownValues() {
        EnumSet<ResourceAttribute> knownValues = EnumSet.allOf(ResourceAttribute.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceAttribute.class, ResourceAttribute::toString);
    }
}

