/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAcceptedPortfolioSharesResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<ListAcceptedPortfolioSharesResponse.Builder, ListAcceptedPortfolioSharesResponse> {
    private static final SdkField<List<PortfolioDetail>> PORTFOLIO_DETAILS_FIELD = SdkField
            .<List<PortfolioDetail>> builder(MarshallingType.LIST)
            .memberName("PortfolioDetails")
            .getter(getter(ListAcceptedPortfolioSharesResponse::portfolioDetails))
            .setter(setter(Builder::portfolioDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PortfolioDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortfolioDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(ListAcceptedPortfolioSharesResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTFOLIO_DETAILS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<PortfolioDetail> portfolioDetails;

    private final String nextPageToken;

    private ListAcceptedPortfolioSharesResponse(BuilderImpl builder) {
        super(builder);
        this.portfolioDetails = builder.portfolioDetails;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PortfolioDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPortfolioDetails() {
        return portfolioDetails != null && !(portfolioDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the portfolios.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPortfolioDetails} method.
     * </p>
     * 
     * @return Information about the portfolios.
     */
    public final List<PortfolioDetail> portfolioDetails() {
        return portfolioDetails;
    }

    /**
     * <p>
     * The page token to use to retrieve the next set of results. If there are no additional results, this value is
     * null.
     * </p>
     * 
     * @return The page token to use to retrieve the next set of results. If there are no additional results, this value
     *         is null.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPortfolioDetails() ? portfolioDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAcceptedPortfolioSharesResponse)) {
            return false;
        }
        ListAcceptedPortfolioSharesResponse other = (ListAcceptedPortfolioSharesResponse) obj;
        return hasPortfolioDetails() == other.hasPortfolioDetails()
                && Objects.equals(portfolioDetails(), other.portfolioDetails())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAcceptedPortfolioSharesResponse")
                .add("PortfolioDetails", hasPortfolioDetails() ? portfolioDetails() : null).add("NextPageToken", nextPageToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PortfolioDetails":
            return Optional.ofNullable(clazz.cast(portfolioDetails()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAcceptedPortfolioSharesResponse, T> g) {
        return obj -> g.apply((ListAcceptedPortfolioSharesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAcceptedPortfolioSharesResponse> {
        /**
         * <p>
         * Information about the portfolios.
         * </p>
         * 
         * @param portfolioDetails
         *        Information about the portfolios.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portfolioDetails(Collection<PortfolioDetail> portfolioDetails);

        /**
         * <p>
         * Information about the portfolios.
         * </p>
         * 
         * @param portfolioDetails
         *        Information about the portfolios.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portfolioDetails(PortfolioDetail... portfolioDetails);

        /**
         * <p>
         * Information about the portfolios.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #portfolioDetails(List<PortfolioDetail>)}.
         * 
         * @param portfolioDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portfolioDetails(java.util.Collection<PortfolioDetail>)
         */
        Builder portfolioDetails(Consumer<PortfolioDetail.Builder>... portfolioDetails);

        /**
         * <p>
         * The page token to use to retrieve the next set of results. If there are no additional results, this value is
         * null.
         * </p>
         * 
         * @param nextPageToken
         *        The page token to use to retrieve the next set of results. If there are no additional results, this
         *        value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private List<PortfolioDetail> portfolioDetails = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAcceptedPortfolioSharesResponse model) {
            super(model);
            portfolioDetails(model.portfolioDetails);
            nextPageToken(model.nextPageToken);
        }

        public final List<PortfolioDetail.Builder> getPortfolioDetails() {
            List<PortfolioDetail.Builder> result = PortfolioDetailsCopier.copyToBuilder(this.portfolioDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortfolioDetails(Collection<PortfolioDetail.BuilderImpl> portfolioDetails) {
            this.portfolioDetails = PortfolioDetailsCopier.copyFromBuilder(portfolioDetails);
        }

        @Override
        public final Builder portfolioDetails(Collection<PortfolioDetail> portfolioDetails) {
            this.portfolioDetails = PortfolioDetailsCopier.copy(portfolioDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portfolioDetails(PortfolioDetail... portfolioDetails) {
            portfolioDetails(Arrays.asList(portfolioDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portfolioDetails(Consumer<PortfolioDetail.Builder>... portfolioDetails) {
            portfolioDetails(Stream.of(portfolioDetails).map(c -> PortfolioDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public ListAcceptedPortfolioSharesResponse build() {
            return new ListAcceptedPortfolioSharesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
