/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.servicecatalog.model.AcceptPortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.AcceptPortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociateBudgetWithResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociateBudgetWithResourceResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociatePrincipalWithPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociatePrincipalWithPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociateProductWithPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociateProductWithPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociateTagOptionWithResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociateTagOptionWithResourceResponse;
import software.amazon.awssdk.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.CopyProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.CopyProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateConstraintRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateConstraintResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateTagOptionResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteConstraintRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteConstraintResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProvisionedProductPlanRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProvisionedProductPlanResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteTagOptionResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeConstraintRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeConstraintResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeCopyProductStatusRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeCopyProductStatusResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductPlanRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductPlanResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeRecordRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeRecordResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionExecutionParametersRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionExecutionParametersResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeTagOptionResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisableAwsOrganizationsAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisableAwsOrganizationsAccessResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateBudgetFromResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateBudgetFromResourceResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociatePrincipalFromPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociatePrincipalFromPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateProductFromPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateProductFromPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateTagOptionFromResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateTagOptionFromResourceResponse;
import software.amazon.awssdk.services.servicecatalog.model.DuplicateResourceException;
import software.amazon.awssdk.services.servicecatalog.model.EnableAwsOrganizationsAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.EnableAwsOrganizationsAccessResponse;
import software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductPlanRequest;
import software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductPlanResponse;
import software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.GetAwsOrganizationsAccessStatusRequest;
import software.amazon.awssdk.services.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse;
import software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest;
import software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ImportAsProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ImportAsProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.InvalidParametersException;
import software.amazon.awssdk.services.servicecatalog.model.InvalidStateException;
import software.amazon.awssdk.services.servicecatalog.model.LimitExceededException;
import software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListStackInstancesForProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListStackInstancesForProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse;
import software.amazon.awssdk.services.servicecatalog.model.NotifyProvisionProductEngineWorkflowResultRequest;
import software.amazon.awssdk.services.servicecatalog.model.NotifyProvisionProductEngineWorkflowResultResponse;
import software.amazon.awssdk.services.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultRequest;
import software.amazon.awssdk.services.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultResponse;
import software.amazon.awssdk.services.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultRequest;
import software.amazon.awssdk.services.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultResponse;
import software.amazon.awssdk.services.servicecatalog.model.OperationNotSupportedException;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.RejectPortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.RejectPortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.ResourceInUseException;
import software.amazon.awssdk.services.servicecatalog.model.ResourceNotFoundException;
import software.amazon.awssdk.services.servicecatalog.model.ScanProvisionedProductsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ScanProvisionedProductsResponse;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse;
import software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogException;
import software.amazon.awssdk.services.servicecatalog.model.TagOptionNotMigratedException;
import software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateTagOptionResponse;
import software.amazon.awssdk.services.servicecatalog.paginators.DescribePortfolioSharesIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.GetProvisionedProductOutputsIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListBudgetsForResourceIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListConstraintsForPortfolioIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListLaunchPathsIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListOrganizationPortfolioAccessIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListPortfolioAccessIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosForProductIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListPrincipalsForPortfolioIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListProvisioningArtifactsForServiceActionIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListResourcesForTagOptionIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsForProvisioningArtifactIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsIterable;

/**
 * Service client for accessing AWS Service Catalog. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Service Catalog</fullname>
 * <p>
 * <a href="http://aws.amazon.com/servicecatalog">Service Catalog</a> enables organizations to create and manage
 * catalogs of IT services that are approved for Amazon Web Services. To get the most out of this documentation, you
 * should be familiar with the terminology discussed in <a
 * href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/what-is_concepts.html">Service Catalog
 * Concepts</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ServiceCatalogClient extends AwsClient {
    String SERVICE_NAME = "servicecatalog";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "servicecatalog";

    /**
     * <p>
     * Accepts an offer to share the specified portfolio.
     * </p>
     *
     * @param acceptPortfolioShareRequest
     * @return Result of the AcceptPortfolioShare operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.AcceptPortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AcceptPortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptPortfolioShareResponse acceptPortfolioShare(AcceptPortfolioShareRequest acceptPortfolioShareRequest)
            throws InvalidParametersException, ResourceNotFoundException, LimitExceededException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts an offer to share the specified portfolio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptPortfolioShareRequest.Builder} avoiding the
     * need to create one manually via {@link AcceptPortfolioShareRequest#builder()}
     * </p>
     *
     * @param acceptPortfolioShareRequest
     *        A {@link Consumer} that will call methods on {@link AcceptPortfolioShareInput.Builder} to create a
     *        request.
     * @return Result of the AcceptPortfolioShare operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.AcceptPortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AcceptPortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptPortfolioShareResponse acceptPortfolioShare(
            Consumer<AcceptPortfolioShareRequest.Builder> acceptPortfolioShareRequest) throws InvalidParametersException,
            ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return acceptPortfolioShare(AcceptPortfolioShareRequest.builder().applyMutation(acceptPortfolioShareRequest).build());
    }

    /**
     * <p>
     * Associates the specified budget with the specified resource.
     * </p>
     *
     * @param associateBudgetWithResourceRequest
     * @return Result of the AssociateBudgetWithResource operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.AssociateBudgetWithResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateBudgetWithResource"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateBudgetWithResourceResponse associateBudgetWithResource(
            AssociateBudgetWithResourceRequest associateBudgetWithResourceRequest) throws InvalidParametersException,
            DuplicateResourceException, LimitExceededException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified budget with the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateBudgetWithResourceRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateBudgetWithResourceRequest#builder()}
     * </p>
     *
     * @param associateBudgetWithResourceRequest
     *        A {@link Consumer} that will call methods on {@link AssociateBudgetWithResourceInput.Builder} to create a
     *        request.
     * @return Result of the AssociateBudgetWithResource operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.AssociateBudgetWithResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateBudgetWithResource"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateBudgetWithResourceResponse associateBudgetWithResource(
            Consumer<AssociateBudgetWithResourceRequest.Builder> associateBudgetWithResourceRequest)
            throws InvalidParametersException, DuplicateResourceException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        return associateBudgetWithResource(AssociateBudgetWithResourceRequest.builder()
                .applyMutation(associateBudgetWithResourceRequest).build());
    }

    /**
     * <p>
     * Associates the specified principal ARN with the specified portfolio.
     * </p>
     * <p>
     * If you share the portfolio with principal name sharing enabled, the <code>PrincipalARN</code> association is
     * included in the share.
     * </p>
     * <p>
     * The <code>PortfolioID</code>, <code>PrincipalARN</code>, and <code>PrincipalType</code> parameters are required.
     * </p>
     * <p>
     * You can associate a maximum of 10 Principals with a portfolio using <code>PrincipalType</code> as
     * <code>IAM_PATTERN</code>
     * </p>
     * <note>
     * <p>
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that
     * portfolio is then shared with other accounts. For a user in a recipient account who is <i>not</i> an Service
     * Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role
     * that matches a principal name association for the portfolio. Although this user may not know which principal
     * names are associated through Service Catalog, they may be able to guess the user. If this potential escalation
     * path is a concern, then Service Catalog recommends using <code>PrincipalType</code> as <code>IAM</code>. With
     * this configuration, the <code>PrincipalARN</code> must already exist in the recipient account before it can be
     * associated.
     * </p>
     * </note>
     *
     * @param associatePrincipalWithPortfolioRequest
     * @return Result of the AssociatePrincipalWithPortfolio operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.AssociatePrincipalWithPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociatePrincipalWithPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociatePrincipalWithPortfolioResponse associatePrincipalWithPortfolio(
            AssociatePrincipalWithPortfolioRequest associatePrincipalWithPortfolioRequest) throws InvalidParametersException,
            ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified principal ARN with the specified portfolio.
     * </p>
     * <p>
     * If you share the portfolio with principal name sharing enabled, the <code>PrincipalARN</code> association is
     * included in the share.
     * </p>
     * <p>
     * The <code>PortfolioID</code>, <code>PrincipalARN</code>, and <code>PrincipalType</code> parameters are required.
     * </p>
     * <p>
     * You can associate a maximum of 10 Principals with a portfolio using <code>PrincipalType</code> as
     * <code>IAM_PATTERN</code>
     * </p>
     * <note>
     * <p>
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that
     * portfolio is then shared with other accounts. For a user in a recipient account who is <i>not</i> an Service
     * Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role
     * that matches a principal name association for the portfolio. Although this user may not know which principal
     * names are associated through Service Catalog, they may be able to guess the user. If this potential escalation
     * path is a concern, then Service Catalog recommends using <code>PrincipalType</code> as <code>IAM</code>. With
     * this configuration, the <code>PrincipalARN</code> must already exist in the recipient account before it can be
     * associated.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociatePrincipalWithPortfolioRequest.Builder}
     * avoiding the need to create one manually via {@link AssociatePrincipalWithPortfolioRequest#builder()}
     * </p>
     *
     * @param associatePrincipalWithPortfolioRequest
     *        A {@link Consumer} that will call methods on {@link AssociatePrincipalWithPortfolioInput.Builder} to
     *        create a request.
     * @return Result of the AssociatePrincipalWithPortfolio operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.AssociatePrincipalWithPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociatePrincipalWithPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociatePrincipalWithPortfolioResponse associatePrincipalWithPortfolio(
            Consumer<AssociatePrincipalWithPortfolioRequest.Builder> associatePrincipalWithPortfolioRequest)
            throws InvalidParametersException, ResourceNotFoundException, LimitExceededException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return associatePrincipalWithPortfolio(AssociatePrincipalWithPortfolioRequest.builder()
                .applyMutation(associatePrincipalWithPortfolioRequest).build());
    }

    /**
     * <p>
     * Associates the specified product with the specified portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param associateProductWithPortfolioRequest
     * @return Result of the AssociateProductWithPortfolio operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.AssociateProductWithPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateProductWithPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateProductWithPortfolioResponse associateProductWithPortfolio(
            AssociateProductWithPortfolioRequest associateProductWithPortfolioRequest) throws InvalidParametersException,
            ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified product with the specified portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateProductWithPortfolioRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateProductWithPortfolioRequest#builder()}
     * </p>
     *
     * @param associateProductWithPortfolioRequest
     *        A {@link Consumer} that will call methods on {@link AssociateProductWithPortfolioInput.Builder} to create
     *        a request.
     * @return Result of the AssociateProductWithPortfolio operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.AssociateProductWithPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateProductWithPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateProductWithPortfolioResponse associateProductWithPortfolio(
            Consumer<AssociateProductWithPortfolioRequest.Builder> associateProductWithPortfolioRequest)
            throws InvalidParametersException, ResourceNotFoundException, LimitExceededException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return associateProductWithPortfolio(AssociateProductWithPortfolioRequest.builder()
                .applyMutation(associateProductWithPortfolioRequest).build());
    }

    /**
     * <p>
     * Associates a self-service action with a provisioning artifact.
     * </p>
     *
     * @param associateServiceActionWithProvisioningArtifactRequest
     * @return Result of the AssociateServiceActionWithProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.AssociateServiceActionWithProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateServiceActionWithProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateServiceActionWithProvisioningArtifactResponse associateServiceActionWithProvisioningArtifact(
            AssociateServiceActionWithProvisioningArtifactRequest associateServiceActionWithProvisioningArtifactRequest)
            throws ResourceNotFoundException, DuplicateResourceException, LimitExceededException, InvalidParametersException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a self-service action with a provisioning artifact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateServiceActionWithProvisioningArtifactRequest.Builder} avoiding the need to create one manually
     * via {@link AssociateServiceActionWithProvisioningArtifactRequest#builder()}
     * </p>
     *
     * @param associateServiceActionWithProvisioningArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link AssociateServiceActionWithProvisioningArtifactInput.Builder} to create a request.
     * @return Result of the AssociateServiceActionWithProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.AssociateServiceActionWithProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateServiceActionWithProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateServiceActionWithProvisioningArtifactResponse associateServiceActionWithProvisioningArtifact(
            Consumer<AssociateServiceActionWithProvisioningArtifactRequest.Builder> associateServiceActionWithProvisioningArtifactRequest)
            throws ResourceNotFoundException, DuplicateResourceException, LimitExceededException, InvalidParametersException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        return associateServiceActionWithProvisioningArtifact(AssociateServiceActionWithProvisioningArtifactRequest.builder()
                .applyMutation(associateServiceActionWithProvisioningArtifactRequest).build());
    }

    /**
     * <p>
     * Associate the specified TagOption with the specified portfolio or product.
     * </p>
     *
     * @param associateTagOptionWithResourceRequest
     * @return Result of the AssociateTagOptionWithResource operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.AssociateTagOptionWithResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateTagOptionWithResource"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateTagOptionWithResourceResponse associateTagOptionWithResource(
            AssociateTagOptionWithResourceRequest associateTagOptionWithResourceRequest) throws TagOptionNotMigratedException,
            ResourceNotFoundException, InvalidParametersException, LimitExceededException, DuplicateResourceException,
            InvalidStateException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate the specified TagOption with the specified portfolio or product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateTagOptionWithResourceRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateTagOptionWithResourceRequest#builder()}
     * </p>
     *
     * @param associateTagOptionWithResourceRequest
     *        A {@link Consumer} that will call methods on {@link AssociateTagOptionWithResourceInput.Builder} to create
     *        a request.
     * @return Result of the AssociateTagOptionWithResource operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.AssociateTagOptionWithResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateTagOptionWithResource"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateTagOptionWithResourceResponse associateTagOptionWithResource(
            Consumer<AssociateTagOptionWithResourceRequest.Builder> associateTagOptionWithResourceRequest)
            throws TagOptionNotMigratedException, ResourceNotFoundException, InvalidParametersException, LimitExceededException,
            DuplicateResourceException, InvalidStateException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return associateTagOptionWithResource(AssociateTagOptionWithResourceRequest.builder()
                .applyMutation(associateTagOptionWithResourceRequest).build());
    }

    /**
     * <p>
     * Associates multiple self-service actions with provisioning artifacts.
     * </p>
     *
     * @param batchAssociateServiceActionWithProvisioningArtifactRequest
     * @return Result of the BatchAssociateServiceActionWithProvisioningArtifact operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.BatchAssociateServiceActionWithProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/BatchAssociateServiceActionWithProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchAssociateServiceActionWithProvisioningArtifactResponse batchAssociateServiceActionWithProvisioningArtifact(
            BatchAssociateServiceActionWithProvisioningArtifactRequest batchAssociateServiceActionWithProvisioningArtifactRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates multiple self-service actions with provisioning artifacts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchAssociateServiceActionWithProvisioningArtifactRequest.Builder} avoiding the need to create one
     * manually via {@link BatchAssociateServiceActionWithProvisioningArtifactRequest#builder()}
     * </p>
     *
     * @param batchAssociateServiceActionWithProvisioningArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link BatchAssociateServiceActionWithProvisioningArtifactInput.Builder} to create a request.
     * @return Result of the BatchAssociateServiceActionWithProvisioningArtifact operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.BatchAssociateServiceActionWithProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/BatchAssociateServiceActionWithProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchAssociateServiceActionWithProvisioningArtifactResponse batchAssociateServiceActionWithProvisioningArtifact(
            Consumer<BatchAssociateServiceActionWithProvisioningArtifactRequest.Builder> batchAssociateServiceActionWithProvisioningArtifactRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return batchAssociateServiceActionWithProvisioningArtifact(BatchAssociateServiceActionWithProvisioningArtifactRequest
                .builder().applyMutation(batchAssociateServiceActionWithProvisioningArtifactRequest).build());
    }

    /**
     * <p>
     * Disassociates a batch of self-service actions from the specified provisioning artifact.
     * </p>
     *
     * @param batchDisassociateServiceActionFromProvisioningArtifactRequest
     * @return Result of the BatchDisassociateServiceActionFromProvisioningArtifact operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.BatchDisassociateServiceActionFromProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/BatchDisassociateServiceActionFromProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisassociateServiceActionFromProvisioningArtifactResponse batchDisassociateServiceActionFromProvisioningArtifact(
            BatchDisassociateServiceActionFromProvisioningArtifactRequest batchDisassociateServiceActionFromProvisioningArtifactRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a batch of self-service actions from the specified provisioning artifact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchDisassociateServiceActionFromProvisioningArtifactRequest.Builder} avoiding the need to create one
     * manually via {@link BatchDisassociateServiceActionFromProvisioningArtifactRequest#builder()}
     * </p>
     *
     * @param batchDisassociateServiceActionFromProvisioningArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link BatchDisassociateServiceActionFromProvisioningArtifactInput.Builder} to create a request.
     * @return Result of the BatchDisassociateServiceActionFromProvisioningArtifact operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.BatchDisassociateServiceActionFromProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/BatchDisassociateServiceActionFromProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisassociateServiceActionFromProvisioningArtifactResponse batchDisassociateServiceActionFromProvisioningArtifact(
            Consumer<BatchDisassociateServiceActionFromProvisioningArtifactRequest.Builder> batchDisassociateServiceActionFromProvisioningArtifactRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return batchDisassociateServiceActionFromProvisioningArtifact(BatchDisassociateServiceActionFromProvisioningArtifactRequest
                .builder().applyMutation(batchDisassociateServiceActionFromProvisioningArtifactRequest).build());
    }

    /**
     * <p>
     * Copies the specified source product to the specified target product or a new product.
     * </p>
     * <p>
     * You can copy a product to the same account or another account. You can copy a product to the same Region or
     * another Region. If you copy a product to another account, you must first share the product in a portfolio using
     * <a>CreatePortfolioShare</a>.
     * </p>
     * <p>
     * This operation is performed asynchronously. To track the progress of the operation, use
     * <a>DescribeCopyProductStatus</a>.
     * </p>
     *
     * @param copyProductRequest
     * @return Result of the CopyProduct operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CopyProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CopyProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CopyProductResponse copyProduct(CopyProductRequest copyProductRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified source product to the specified target product or a new product.
     * </p>
     * <p>
     * You can copy a product to the same account or another account. You can copy a product to the same Region or
     * another Region. If you copy a product to another account, you must first share the product in a portfolio using
     * <a>CreatePortfolioShare</a>.
     * </p>
     * <p>
     * This operation is performed asynchronously. To track the progress of the operation, use
     * <a>DescribeCopyProductStatus</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyProductRequest.Builder} avoiding the need to
     * create one manually via {@link CopyProductRequest#builder()}
     * </p>
     *
     * @param copyProductRequest
     *        A {@link Consumer} that will call methods on {@link CopyProductInput.Builder} to create a request.
     * @return Result of the CopyProduct operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CopyProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CopyProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CopyProductResponse copyProduct(Consumer<CopyProductRequest.Builder> copyProductRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return copyProduct(CopyProductRequest.builder().applyMutation(copyProductRequest).build());
    }

    /**
     * <p>
     * Creates a constraint.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param createConstraintRequest
     * @return Result of the CreateConstraint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreateConstraint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConstraintResponse createConstraint(CreateConstraintRequest createConstraintRequest)
            throws ResourceNotFoundException, InvalidParametersException, LimitExceededException, DuplicateResourceException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a constraint.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConstraintRequest.Builder} avoiding the need
     * to create one manually via {@link CreateConstraintRequest#builder()}
     * </p>
     *
     * @param createConstraintRequest
     *        A {@link Consumer} that will call methods on {@link CreateConstraintInput.Builder} to create a request.
     * @return Result of the CreateConstraint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreateConstraint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConstraintResponse createConstraint(Consumer<CreateConstraintRequest.Builder> createConstraintRequest)
            throws ResourceNotFoundException, InvalidParametersException, LimitExceededException, DuplicateResourceException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        return createConstraint(CreateConstraintRequest.builder().applyMutation(createConstraintRequest).build());
    }

    /**
     * <p>
     * Creates a portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param createPortfolioRequest
     * @return Result of the CreatePortfolio operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreatePortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreatePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePortfolioResponse createPortfolio(CreatePortfolioRequest createPortfolioRequest)
            throws InvalidParametersException, LimitExceededException, TagOptionNotMigratedException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePortfolioRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePortfolioRequest#builder()}
     * </p>
     *
     * @param createPortfolioRequest
     *        A {@link Consumer} that will call methods on {@link CreatePortfolioInput.Builder} to create a request.
     * @return Result of the CreatePortfolio operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreatePortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreatePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePortfolioResponse createPortfolio(Consumer<CreatePortfolioRequest.Builder> createPortfolioRequest)
            throws InvalidParametersException, LimitExceededException, TagOptionNotMigratedException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return createPortfolio(CreatePortfolioRequest.builder().applyMutation(createPortfolioRequest).build());
    }

    /**
     * <p>
     * Shares the specified portfolio with the specified account or organization node. Shares to an organization node
     * can only be created by the management account of an organization or by a delegated administrator. You can share
     * portfolios to an organization, an organizational unit, or a specific account.
     * </p>
     * <p>
     * Note that if a delegated admin is de-registered, they can no longer create portfolio shares.
     * </p>
     * <p>
     * <code>AWSOrganizationsAccess</code> must be enabled in order to create a portfolio share to an organization node.
     * </p>
     * <p>
     * You can't share a shared resource, including portfolios that contain a shared product.
     * </p>
     * <p>
     * If the portfolio share with the specified account or organization node already exists, this action will have no
     * effect and will not return an error. To update an existing share, you must use the
     * <code> UpdatePortfolioShare</code> API instead.
     * </p>
     * <note>
     * <p>
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that
     * portfolio is then shared with other accounts. For a user in a recipient account who is <i>not</i> an Service
     * Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role
     * that matches a principal name association for the portfolio. Although this user may not know which principal
     * names are associated through Service Catalog, they may be able to guess the user. If this potential escalation
     * path is a concern, then Service Catalog recommends using <code>PrincipalType</code> as <code>IAM</code>. With
     * this configuration, the <code>PrincipalARN</code> must already exist in the recipient account before it can be
     * associated.
     * </p>
     * </note>
     *
     * @param createPortfolioShareRequest
     * @return Result of the CreatePortfolioShare operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreatePortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreatePortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePortfolioShareResponse createPortfolioShare(CreatePortfolioShareRequest createPortfolioShareRequest)
            throws ResourceNotFoundException, LimitExceededException, InvalidParametersException, OperationNotSupportedException,
            InvalidStateException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Shares the specified portfolio with the specified account or organization node. Shares to an organization node
     * can only be created by the management account of an organization or by a delegated administrator. You can share
     * portfolios to an organization, an organizational unit, or a specific account.
     * </p>
     * <p>
     * Note that if a delegated admin is de-registered, they can no longer create portfolio shares.
     * </p>
     * <p>
     * <code>AWSOrganizationsAccess</code> must be enabled in order to create a portfolio share to an organization node.
     * </p>
     * <p>
     * You can't share a shared resource, including portfolios that contain a shared product.
     * </p>
     * <p>
     * If the portfolio share with the specified account or organization node already exists, this action will have no
     * effect and will not return an error. To update an existing share, you must use the
     * <code> UpdatePortfolioShare</code> API instead.
     * </p>
     * <note>
     * <p>
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that
     * portfolio is then shared with other accounts. For a user in a recipient account who is <i>not</i> an Service
     * Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role
     * that matches a principal name association for the portfolio. Although this user may not know which principal
     * names are associated through Service Catalog, they may be able to guess the user. If this potential escalation
     * path is a concern, then Service Catalog recommends using <code>PrincipalType</code> as <code>IAM</code>. With
     * this configuration, the <code>PrincipalARN</code> must already exist in the recipient account before it can be
     * associated.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePortfolioShareRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePortfolioShareRequest#builder()}
     * </p>
     *
     * @param createPortfolioShareRequest
     *        A {@link Consumer} that will call methods on {@link CreatePortfolioShareInput.Builder} to create a
     *        request.
     * @return Result of the CreatePortfolioShare operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreatePortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreatePortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePortfolioShareResponse createPortfolioShare(
            Consumer<CreatePortfolioShareRequest.Builder> createPortfolioShareRequest) throws ResourceNotFoundException,
            LimitExceededException, InvalidParametersException, OperationNotSupportedException, InvalidStateException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        return createPortfolioShare(CreatePortfolioShareRequest.builder().applyMutation(createPortfolioShareRequest).build());
    }

    /**
     * <p>
     * Creates a product.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <p>
     * The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> IAM policy
     * permission. This policy permission is required when using the <code>ImportFromPhysicalId</code> template source
     * in the information data section.
     * </p>
     *
     * @param createProductRequest
     * @return Result of the CreateProduct operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreateProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateProductResponse createProduct(CreateProductRequest createProductRequest) throws InvalidParametersException,
            LimitExceededException, TagOptionNotMigratedException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a product.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <p>
     * The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> IAM policy
     * permission. This policy permission is required when using the <code>ImportFromPhysicalId</code> template source
     * in the information data section.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProductRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProductRequest#builder()}
     * </p>
     *
     * @param createProductRequest
     *        A {@link Consumer} that will call methods on {@link CreateProductInput.Builder} to create a request.
     * @return Result of the CreateProduct operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreateProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateProductResponse createProduct(Consumer<CreateProductRequest.Builder> createProductRequest)
            throws InvalidParametersException, LimitExceededException, TagOptionNotMigratedException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return createProduct(CreateProductRequest.builder().applyMutation(createProductRequest).build());
    }

    /**
     * <p>
     * Creates a plan.
     * </p>
     * <p>
     * A plan includes the list of resources to be created (when provisioning a new product) or modified (when updating
     * a provisioned product) when the plan is executed.
     * </p>
     * <p>
     * You can create one plan for each provisioned product. To create a plan for an existing provisioned product, the
     * product status must be AVAILABLE or TAINTED.
     * </p>
     * <p>
     * To view the resource changes in the change set, use <a>DescribeProvisionedProductPlan</a>. To create or modify
     * the provisioned product, use <a>ExecuteProvisionedProductPlan</a>.
     * </p>
     *
     * @param createProvisionedProductPlanRequest
     * @return Result of the CreateProvisionedProductPlan operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreateProvisionedProductPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProvisionedProductPlanResponse createProvisionedProductPlan(
            CreateProvisionedProductPlanRequest createProvisionedProductPlanRequest) throws InvalidParametersException,
            ResourceNotFoundException, InvalidStateException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a plan.
     * </p>
     * <p>
     * A plan includes the list of resources to be created (when provisioning a new product) or modified (when updating
     * a provisioned product) when the plan is executed.
     * </p>
     * <p>
     * You can create one plan for each provisioned product. To create a plan for an existing provisioned product, the
     * product status must be AVAILABLE or TAINTED.
     * </p>
     * <p>
     * To view the resource changes in the change set, use <a>DescribeProvisionedProductPlan</a>. To create or modify
     * the provisioned product, use <a>ExecuteProvisionedProductPlan</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProvisionedProductPlanRequest.Builder}
     * avoiding the need to create one manually via {@link CreateProvisionedProductPlanRequest#builder()}
     * </p>
     *
     * @param createProvisionedProductPlanRequest
     *        A {@link Consumer} that will call methods on {@link CreateProvisionedProductPlanInput.Builder} to create a
     *        request.
     * @return Result of the CreateProvisionedProductPlan operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreateProvisionedProductPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProvisionedProductPlanResponse createProvisionedProductPlan(
            Consumer<CreateProvisionedProductPlanRequest.Builder> createProvisionedProductPlanRequest)
            throws InvalidParametersException, ResourceNotFoundException, InvalidStateException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return createProvisionedProductPlan(CreateProvisionedProductPlanRequest.builder()
                .applyMutation(createProvisionedProductPlanRequest).build());
    }

    /**
     * <p>
     * Creates a provisioning artifact (also known as a version) for the specified product.
     * </p>
     * <p>
     * You cannot create a provisioning artifact for a product that was shared with you.
     * </p>
     * <p>
     * The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> IAM policy
     * permission. This policy permission is required when using the <code>ImportFromPhysicalId</code> template source
     * in the information data section.
     * </p>
     *
     * @param createProvisioningArtifactRequest
     * @return Result of the CreateProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreateProvisioningArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProvisioningArtifactResponse createProvisioningArtifact(
            CreateProvisioningArtifactRequest createProvisioningArtifactRequest) throws ResourceNotFoundException,
            InvalidParametersException, LimitExceededException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a provisioning artifact (also known as a version) for the specified product.
     * </p>
     * <p>
     * You cannot create a provisioning artifact for a product that was shared with you.
     * </p>
     * <p>
     * The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> IAM policy
     * permission. This policy permission is required when using the <code>ImportFromPhysicalId</code> template source
     * in the information data section.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProvisioningArtifactRequest.Builder} avoiding
     * the need to create one manually via {@link CreateProvisioningArtifactRequest#builder()}
     * </p>
     *
     * @param createProvisioningArtifactRequest
     *        A {@link Consumer} that will call methods on {@link CreateProvisioningArtifactInput.Builder} to create a
     *        request.
     * @return Result of the CreateProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreateProvisioningArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProvisioningArtifactResponse createProvisioningArtifact(
            Consumer<CreateProvisioningArtifactRequest.Builder> createProvisioningArtifactRequest)
            throws ResourceNotFoundException, InvalidParametersException, LimitExceededException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return createProvisioningArtifact(CreateProvisioningArtifactRequest.builder()
                .applyMutation(createProvisioningArtifactRequest).build());
    }

    /**
     * <p>
     * Creates a self-service action.
     * </p>
     *
     * @param createServiceActionRequest
     * @return Result of the CreateServiceAction operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreateServiceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateServiceActionResponse createServiceAction(CreateServiceActionRequest createServiceActionRequest)
            throws InvalidParametersException, LimitExceededException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a self-service action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceActionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateServiceActionRequest#builder()}
     * </p>
     *
     * @param createServiceActionRequest
     *        A {@link Consumer} that will call methods on {@link CreateServiceActionInput.Builder} to create a request.
     * @return Result of the CreateServiceAction operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreateServiceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateServiceActionResponse createServiceAction(
            Consumer<CreateServiceActionRequest.Builder> createServiceActionRequest) throws InvalidParametersException,
            LimitExceededException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return createServiceAction(CreateServiceActionRequest.builder().applyMutation(createServiceActionRequest).build());
    }

    /**
     * <p>
     * Creates a TagOption.
     * </p>
     *
     * @param createTagOptionRequest
     * @return Result of the CreateTagOption operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreateTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTagOptionResponse createTagOption(CreateTagOptionRequest createTagOptionRequest)
            throws TagOptionNotMigratedException, DuplicateResourceException, LimitExceededException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a TagOption.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTagOptionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTagOptionRequest#builder()}
     * </p>
     *
     * @param createTagOptionRequest
     *        A {@link Consumer} that will call methods on {@link CreateTagOptionInput.Builder} to create a request.
     * @return Result of the CreateTagOption operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreateTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTagOptionResponse createTagOption(Consumer<CreateTagOptionRequest.Builder> createTagOptionRequest)
            throws TagOptionNotMigratedException, DuplicateResourceException, LimitExceededException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return createTagOption(CreateTagOptionRequest.builder().applyMutation(createTagOptionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified constraint.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param deleteConstraintRequest
     * @return Result of the DeleteConstraint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeleteConstraint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConstraintResponse deleteConstraint(DeleteConstraintRequest deleteConstraintRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified constraint.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConstraintRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConstraintRequest#builder()}
     * </p>
     *
     * @param deleteConstraintRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConstraintInput.Builder} to create a request.
     * @return Result of the DeleteConstraint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeleteConstraint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConstraintResponse deleteConstraint(Consumer<DeleteConstraintRequest.Builder> deleteConstraintRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return deleteConstraint(DeleteConstraintRequest.builder().applyMutation(deleteConstraintRequest).build());
    }

    /**
     * <p>
     * Deletes the specified portfolio.
     * </p>
     * <p>
     * You cannot delete a portfolio if it was shared with you or if it has associated products, users, constraints, or
     * shared accounts.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param deletePortfolioRequest
     * @return Result of the DeletePortfolio operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceInUseException
     *         A resource that is currently in use. Ensure that the resource is not in use and retry the operation.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeletePortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePortfolioResponse deletePortfolio(DeletePortfolioRequest deletePortfolioRequest)
            throws ResourceNotFoundException, InvalidParametersException, ResourceInUseException, TagOptionNotMigratedException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified portfolio.
     * </p>
     * <p>
     * You cannot delete a portfolio if it was shared with you or if it has associated products, users, constraints, or
     * shared accounts.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePortfolioRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePortfolioRequest#builder()}
     * </p>
     *
     * @param deletePortfolioRequest
     *        A {@link Consumer} that will call methods on {@link DeletePortfolioInput.Builder} to create a request.
     * @return Result of the DeletePortfolio operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceInUseException
     *         A resource that is currently in use. Ensure that the resource is not in use and retry the operation.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeletePortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePortfolioResponse deletePortfolio(Consumer<DeletePortfolioRequest.Builder> deletePortfolioRequest)
            throws ResourceNotFoundException, InvalidParametersException, ResourceInUseException, TagOptionNotMigratedException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        return deletePortfolio(DeletePortfolioRequest.builder().applyMutation(deletePortfolioRequest).build());
    }

    /**
     * <p>
     * Stops sharing the specified portfolio with the specified account or organization node. Shares to an organization
     * node can only be deleted by the management account of an organization or by a delegated administrator.
     * </p>
     * <p>
     * Note that if a delegated admin is de-registered, portfolio shares created from that account are removed.
     * </p>
     *
     * @param deletePortfolioShareRequest
     * @return Result of the DeletePortfolioShare operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeletePortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePortfolioShareResponse deletePortfolioShare(DeletePortfolioShareRequest deletePortfolioShareRequest)
            throws ResourceNotFoundException, InvalidParametersException, OperationNotSupportedException, InvalidStateException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops sharing the specified portfolio with the specified account or organization node. Shares to an organization
     * node can only be deleted by the management account of an organization or by a delegated administrator.
     * </p>
     * <p>
     * Note that if a delegated admin is de-registered, portfolio shares created from that account are removed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePortfolioShareRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePortfolioShareRequest#builder()}
     * </p>
     *
     * @param deletePortfolioShareRequest
     *        A {@link Consumer} that will call methods on {@link DeletePortfolioShareInput.Builder} to create a
     *        request.
     * @return Result of the DeletePortfolioShare operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeletePortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePortfolioShareResponse deletePortfolioShare(
            Consumer<DeletePortfolioShareRequest.Builder> deletePortfolioShareRequest) throws ResourceNotFoundException,
            InvalidParametersException, OperationNotSupportedException, InvalidStateException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return deletePortfolioShare(DeletePortfolioShareRequest.builder().applyMutation(deletePortfolioShareRequest).build());
    }

    /**
     * <p>
     * Deletes the specified product.
     * </p>
     * <p>
     * You cannot delete a product if it was shared with you or is associated with a portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param deleteProductRequest
     * @return Result of the DeleteProduct operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         A resource that is currently in use. Ensure that the resource is not in use and retry the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeleteProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteProductResponse deleteProduct(DeleteProductRequest deleteProductRequest) throws ResourceNotFoundException,
            ResourceInUseException, InvalidParametersException, TagOptionNotMigratedException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified product.
     * </p>
     * <p>
     * You cannot delete a product if it was shared with you or is associated with a portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProductRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProductRequest#builder()}
     * </p>
     *
     * @param deleteProductRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProductInput.Builder} to create a request.
     * @return Result of the DeleteProduct operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         A resource that is currently in use. Ensure that the resource is not in use and retry the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeleteProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteProductResponse deleteProduct(Consumer<DeleteProductRequest.Builder> deleteProductRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidParametersException, TagOptionNotMigratedException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        return deleteProduct(DeleteProductRequest.builder().applyMutation(deleteProductRequest).build());
    }

    /**
     * <p>
     * Deletes the specified plan.
     * </p>
     *
     * @param deleteProvisionedProductPlanRequest
     * @return Result of the DeleteProvisionedProductPlan operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeleteProvisionedProductPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProvisionedProductPlanResponse deleteProvisionedProductPlan(
            DeleteProvisionedProductPlanRequest deleteProvisionedProductPlanRequest) throws InvalidParametersException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProvisionedProductPlanRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteProvisionedProductPlanRequest#builder()}
     * </p>
     *
     * @param deleteProvisionedProductPlanRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProvisionedProductPlanInput.Builder} to create a
     *        request.
     * @return Result of the DeleteProvisionedProductPlan operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeleteProvisionedProductPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProvisionedProductPlanResponse deleteProvisionedProductPlan(
            Consumer<DeleteProvisionedProductPlanRequest.Builder> deleteProvisionedProductPlanRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return deleteProvisionedProductPlan(DeleteProvisionedProductPlanRequest.builder()
                .applyMutation(deleteProvisionedProductPlanRequest).build());
    }

    /**
     * <p>
     * Deletes the specified provisioning artifact (also known as a version) for the specified product.
     * </p>
     * <p>
     * You cannot delete a provisioning artifact associated with a product that was shared with you. You cannot delete
     * the last provisioning artifact for a product, because a product must have at least one provisioning artifact.
     * </p>
     *
     * @param deleteProvisioningArtifactRequest
     * @return Result of the DeleteProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         A resource that is currently in use. Ensure that the resource is not in use and retry the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeleteProvisioningArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProvisioningArtifactResponse deleteProvisioningArtifact(
            DeleteProvisioningArtifactRequest deleteProvisioningArtifactRequest) throws ResourceNotFoundException,
            ResourceInUseException, InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified provisioning artifact (also known as a version) for the specified product.
     * </p>
     * <p>
     * You cannot delete a provisioning artifact associated with a product that was shared with you. You cannot delete
     * the last provisioning artifact for a product, because a product must have at least one provisioning artifact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProvisioningArtifactRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteProvisioningArtifactRequest#builder()}
     * </p>
     *
     * @param deleteProvisioningArtifactRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProvisioningArtifactInput.Builder} to create a
     *        request.
     * @return Result of the DeleteProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         A resource that is currently in use. Ensure that the resource is not in use and retry the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeleteProvisioningArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProvisioningArtifactResponse deleteProvisioningArtifact(
            Consumer<DeleteProvisioningArtifactRequest.Builder> deleteProvisioningArtifactRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidParametersException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return deleteProvisioningArtifact(DeleteProvisioningArtifactRequest.builder()
                .applyMutation(deleteProvisioningArtifactRequest).build());
    }

    /**
     * <p>
     * Deletes a self-service action.
     * </p>
     *
     * @param deleteServiceActionRequest
     * @return Result of the DeleteServiceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         A resource that is currently in use. Ensure that the resource is not in use and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeleteServiceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServiceActionResponse deleteServiceAction(DeleteServiceActionRequest deleteServiceActionRequest)
            throws ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a self-service action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceActionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteServiceActionRequest#builder()}
     * </p>
     *
     * @param deleteServiceActionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteServiceActionInput.Builder} to create a request.
     * @return Result of the DeleteServiceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         A resource that is currently in use. Ensure that the resource is not in use and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeleteServiceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServiceActionResponse deleteServiceAction(
            Consumer<DeleteServiceActionRequest.Builder> deleteServiceActionRequest) throws ResourceNotFoundException,
            ResourceInUseException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return deleteServiceAction(DeleteServiceActionRequest.builder().applyMutation(deleteServiceActionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified TagOption.
     * </p>
     * <p>
     * You cannot delete a TagOption if it is associated with a product or portfolio.
     * </p>
     *
     * @param deleteTagOptionRequest
     * @return Result of the DeleteTagOption operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceInUseException
     *         A resource that is currently in use. Ensure that the resource is not in use and retry the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeleteTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTagOptionResponse deleteTagOption(DeleteTagOptionRequest deleteTagOptionRequest)
            throws TagOptionNotMigratedException, ResourceInUseException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified TagOption.
     * </p>
     * <p>
     * You cannot delete a TagOption if it is associated with a product or portfolio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagOptionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTagOptionRequest#builder()}
     * </p>
     *
     * @param deleteTagOptionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTagOptionInput.Builder} to create a request.
     * @return Result of the DeleteTagOption operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceInUseException
     *         A resource that is currently in use. Ensure that the resource is not in use and retry the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeleteTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTagOptionResponse deleteTagOption(Consumer<DeleteTagOptionRequest.Builder> deleteTagOptionRequest)
            throws TagOptionNotMigratedException, ResourceInUseException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return deleteTagOption(DeleteTagOptionRequest.builder().applyMutation(deleteTagOptionRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified constraint.
     * </p>
     *
     * @param describeConstraintRequest
     * @return Result of the DescribeConstraint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeConstraint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConstraintResponse describeConstraint(DescribeConstraintRequest describeConstraintRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified constraint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConstraintRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConstraintRequest#builder()}
     * </p>
     *
     * @param describeConstraintRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConstraintInput.Builder} to create a request.
     * @return Result of the DescribeConstraint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeConstraint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConstraintResponse describeConstraint(Consumer<DescribeConstraintRequest.Builder> describeConstraintRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return describeConstraint(DescribeConstraintRequest.builder().applyMutation(describeConstraintRequest).build());
    }

    /**
     * <p>
     * Gets the status of the specified copy product operation.
     * </p>
     *
     * @param describeCopyProductStatusRequest
     * @return Result of the DescribeCopyProductStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeCopyProductStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeCopyProductStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCopyProductStatusResponse describeCopyProductStatus(
            DescribeCopyProductStatusRequest describeCopyProductStatusRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of the specified copy product operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCopyProductStatusRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeCopyProductStatusRequest#builder()}
     * </p>
     *
     * @param describeCopyProductStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCopyProductStatusInput.Builder} to create a
     *        request.
     * @return Result of the DescribeCopyProductStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeCopyProductStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeCopyProductStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCopyProductStatusResponse describeCopyProductStatus(
            Consumer<DescribeCopyProductStatusRequest.Builder> describeCopyProductStatusRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return describeCopyProductStatus(DescribeCopyProductStatusRequest.builder()
                .applyMutation(describeCopyProductStatusRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param describePortfolioRequest
     * @return Result of the DescribePortfolio operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribePortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePortfolioResponse describePortfolio(DescribePortfolioRequest describePortfolioRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePortfolioRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePortfolioRequest#builder()}
     * </p>
     *
     * @param describePortfolioRequest
     *        A {@link Consumer} that will call methods on {@link DescribePortfolioInput.Builder} to create a request.
     * @return Result of the DescribePortfolio operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribePortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePortfolioResponse describePortfolio(Consumer<DescribePortfolioRequest.Builder> describePortfolioRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return describePortfolio(DescribePortfolioRequest.builder().applyMutation(describePortfolioRequest).build());
    }

    /**
     * <p>
     * Gets the status of the specified portfolio share operation. This API can only be called by the management account
     * in the organization or by a delegated admin.
     * </p>
     *
     * @param describePortfolioShareStatusRequest
     * @return Result of the DescribePortfolioShareStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribePortfolioShareStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolioShareStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePortfolioShareStatusResponse describePortfolioShareStatus(
            DescribePortfolioShareStatusRequest describePortfolioShareStatusRequest) throws ResourceNotFoundException,
            InvalidParametersException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of the specified portfolio share operation. This API can only be called by the management account
     * in the organization or by a delegated admin.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePortfolioShareStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePortfolioShareStatusRequest#builder()}
     * </p>
     *
     * @param describePortfolioShareStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribePortfolioShareStatusInput.Builder} to create a
     *        request.
     * @return Result of the DescribePortfolioShareStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribePortfolioShareStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolioShareStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePortfolioShareStatusResponse describePortfolioShareStatus(
            Consumer<DescribePortfolioShareStatusRequest.Builder> describePortfolioShareStatusRequest)
            throws ResourceNotFoundException, InvalidParametersException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return describePortfolioShareStatus(DescribePortfolioShareStatusRequest.builder()
                .applyMutation(describePortfolioShareStatusRequest).build());
    }

    /**
     * <p>
     * Returns a summary of each of the portfolio shares that were created for the specified portfolio.
     * </p>
     * <p>
     * You can use this API to determine which accounts or organizational nodes this portfolio have been shared, whether
     * the recipient entity has imported the share, and whether TagOptions are included with the share.
     * </p>
     * <p>
     * The <code>PortfolioId</code> and <code>Type</code> parameters are both required.
     * </p>
     *
     * @param describePortfolioSharesRequest
     * @return Result of the DescribePortfolioShares operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribePortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePortfolioSharesResponse describePortfolioShares(DescribePortfolioSharesRequest describePortfolioSharesRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a summary of each of the portfolio shares that were created for the specified portfolio.
     * </p>
     * <p>
     * You can use this API to determine which accounts or organizational nodes this portfolio have been shared, whether
     * the recipient entity has imported the share, and whether TagOptions are included with the share.
     * </p>
     * <p>
     * The <code>PortfolioId</code> and <code>Type</code> parameters are both required.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePortfolioSharesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePortfolioSharesRequest#builder()}
     * </p>
     *
     * @param describePortfolioSharesRequest
     *        A {@link Consumer} that will call methods on {@link DescribePortfolioSharesInput.Builder} to create a
     *        request.
     * @return Result of the DescribePortfolioShares operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribePortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePortfolioSharesResponse describePortfolioShares(
            Consumer<DescribePortfolioSharesRequest.Builder> describePortfolioSharesRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return describePortfolioShares(DescribePortfolioSharesRequest.builder().applyMutation(describePortfolioSharesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a summary of each of the portfolio shares that were created for the specified portfolio.
     * </p>
     * <p>
     * You can use this API to determine which accounts or organizational nodes this portfolio have been shared, whether
     * the recipient entity has imported the share, and whether TagOptions are included with the share.
     * </p>
     * <p>
     * The <code>PortfolioId</code> and <code>Type</code> parameters are both required.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePortfolioShares(software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.DescribePortfolioSharesIterable responses = client.describePortfolioSharesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.DescribePortfolioSharesIterable responses = client
     *             .describePortfolioSharesPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.DescribePortfolioSharesIterable responses = client.describePortfolioSharesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePortfolioShares(software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePortfolioSharesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribePortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePortfolioSharesIterable describePortfolioSharesPaginator(
            DescribePortfolioSharesRequest describePortfolioSharesRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return new DescribePortfolioSharesIterable(this, describePortfolioSharesRequest);
    }

    /**
     * <p>
     * Returns a summary of each of the portfolio shares that were created for the specified portfolio.
     * </p>
     * <p>
     * You can use this API to determine which accounts or organizational nodes this portfolio have been shared, whether
     * the recipient entity has imported the share, and whether TagOptions are included with the share.
     * </p>
     * <p>
     * The <code>PortfolioId</code> and <code>Type</code> parameters are both required.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePortfolioShares(software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.DescribePortfolioSharesIterable responses = client.describePortfolioSharesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.DescribePortfolioSharesIterable responses = client
     *             .describePortfolioSharesPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.DescribePortfolioSharesIterable responses = client.describePortfolioSharesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePortfolioShares(software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePortfolioSharesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePortfolioSharesRequest#builder()}
     * </p>
     *
     * @param describePortfolioSharesRequest
     *        A {@link Consumer} that will call methods on {@link DescribePortfolioSharesInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribePortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePortfolioSharesIterable describePortfolioSharesPaginator(
            Consumer<DescribePortfolioSharesRequest.Builder> describePortfolioSharesRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return describePortfolioSharesPaginator(DescribePortfolioSharesRequest.builder()
                .applyMutation(describePortfolioSharesRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified product.
     * </p>
     * <note>
     * <p>
     * Running this operation with administrator access results in a failure. <a>DescribeProductAsAdmin</a> should be
     * used instead.
     * </p>
     * </note>
     *
     * @param describeProductRequest
     * @return Result of the DescribeProduct operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProductResponse describeProduct(DescribeProductRequest describeProductRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified product.
     * </p>
     * <note>
     * <p>
     * Running this operation with administrator access results in a failure. <a>DescribeProductAsAdmin</a> should be
     * used instead.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProductRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProductRequest#builder()}
     * </p>
     *
     * @param describeProductRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProductInput.Builder} to create a request.
     * @return Result of the DescribeProduct operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProductResponse describeProduct(Consumer<DescribeProductRequest.Builder> describeProductRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return describeProduct(DescribeProductRequest.builder().applyMutation(describeProductRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified product. This operation is run with administrator access.
     * </p>
     *
     * @param describeProductAsAdminRequest
     * @return Result of the DescribeProductAsAdmin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProductAsAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProductAsAdminResponse describeProductAsAdmin(DescribeProductAsAdminRequest describeProductAsAdminRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified product. This operation is run with administrator access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProductAsAdminRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeProductAsAdminRequest#builder()}
     * </p>
     *
     * @param describeProductAsAdminRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProductAsAdminInput.Builder} to create a
     *        request.
     * @return Result of the DescribeProductAsAdmin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProductAsAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProductAsAdminResponse describeProductAsAdmin(
            Consumer<DescribeProductAsAdminRequest.Builder> describeProductAsAdminRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return describeProductAsAdmin(DescribeProductAsAdminRequest.builder().applyMutation(describeProductAsAdminRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about the specified product.
     * </p>
     *
     * @param describeProductViewRequest
     * @return Result of the DescribeProductView operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProductView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductView"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProductViewResponse describeProductView(DescribeProductViewRequest describeProductViewRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProductViewRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeProductViewRequest#builder()}
     * </p>
     *
     * @param describeProductViewRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProductViewInput.Builder} to create a request.
     * @return Result of the DescribeProductView operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProductView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductView"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProductViewResponse describeProductView(
            Consumer<DescribeProductViewRequest.Builder> describeProductViewRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return describeProductView(DescribeProductViewRequest.builder().applyMutation(describeProductViewRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified provisioned product.
     * </p>
     *
     * @param describeProvisionedProductRequest
     *        DescribeProvisionedProductAPI input structure. AcceptLanguage - [Optional] The language code for
     *        localization. Id - [Optional] The provisioned product identifier. Name - [Optional] Another provisioned
     *        product identifier. Customers must provide either Id or Name.
     * @return Result of the DescribeProvisionedProduct operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProvisionedProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProvisionedProductResponse describeProvisionedProduct(
            DescribeProvisionedProductRequest describeProvisionedProductRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified provisioned product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProvisionedProductRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeProvisionedProductRequest#builder()}
     * </p>
     *
     * @param describeProvisionedProductRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProvisionedProductInput.Builder} to create a
     *        request. DescribeProvisionedProductAPI input structure. AcceptLanguage - [Optional] The language code for
     *        localization. Id - [Optional] The provisioned product identifier. Name - [Optional] Another provisioned
     *        product identifier. Customers must provide either Id or Name.
     * @return Result of the DescribeProvisionedProduct operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProvisionedProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProvisionedProductResponse describeProvisionedProduct(
            Consumer<DescribeProvisionedProductRequest.Builder> describeProvisionedProductRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return describeProvisionedProduct(DescribeProvisionedProductRequest.builder()
                .applyMutation(describeProvisionedProductRequest).build());
    }

    /**
     * <p>
     * Gets information about the resource changes for the specified plan.
     * </p>
     *
     * @param describeProvisionedProductPlanRequest
     * @return Result of the DescribeProvisionedProductPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProvisionedProductPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProvisionedProductPlanResponse describeProvisionedProductPlan(
            DescribeProvisionedProductPlanRequest describeProvisionedProductPlanRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the resource changes for the specified plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProvisionedProductPlanRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeProvisionedProductPlanRequest#builder()}
     * </p>
     *
     * @param describeProvisionedProductPlanRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProvisionedProductPlanInput.Builder} to create
     *        a request.
     * @return Result of the DescribeProvisionedProductPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProvisionedProductPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProvisionedProductPlanResponse describeProvisionedProductPlan(
            Consumer<DescribeProvisionedProductPlanRequest.Builder> describeProvisionedProductPlanRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return describeProvisionedProductPlan(DescribeProvisionedProductPlanRequest.builder()
                .applyMutation(describeProvisionedProductPlanRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified provisioning artifact (also known as a version) for the specified product.
     * </p>
     *
     * @param describeProvisioningArtifactRequest
     * @return Result of the DescribeProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProvisioningArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProvisioningArtifactResponse describeProvisioningArtifact(
            DescribeProvisioningArtifactRequest describeProvisioningArtifactRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified provisioning artifact (also known as a version) for the specified product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProvisioningArtifactRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeProvisioningArtifactRequest#builder()}
     * </p>
     *
     * @param describeProvisioningArtifactRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProvisioningArtifactInput.Builder} to create a
     *        request.
     * @return Result of the DescribeProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProvisioningArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProvisioningArtifactResponse describeProvisioningArtifact(
            Consumer<DescribeProvisioningArtifactRequest.Builder> describeProvisioningArtifactRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return describeProvisioningArtifact(DescribeProvisioningArtifactRequest.builder()
                .applyMutation(describeProvisioningArtifactRequest).build());
    }

    /**
     * <p>
     * Gets information about the configuration required to provision the specified product using the specified
     * provisioning artifact.
     * </p>
     * <p>
     * If the output contains a TagOption key with an empty list of values, there is a TagOption conflict for that key.
     * The end user cannot take action to fix the conflict, and launch is not blocked. In subsequent calls to
     * <a>ProvisionProduct</a>, do not include conflicted TagOption keys as tags, or this causes the error
     * "Parameter validation failed: Missing required parameter in Tags[<i>N</i>]:<i>Value</i>". Tag the provisioned
     * product with the value <code>sc-tagoption-conflict-portfolioId-productId</code>.
     * </p>
     *
     * @param describeProvisioningParametersRequest
     * @return Result of the DescribeProvisioningParameters operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProvisioningParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProvisioningParametersResponse describeProvisioningParameters(
            DescribeProvisioningParametersRequest describeProvisioningParametersRequest) throws InvalidParametersException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the configuration required to provision the specified product using the specified
     * provisioning artifact.
     * </p>
     * <p>
     * If the output contains a TagOption key with an empty list of values, there is a TagOption conflict for that key.
     * The end user cannot take action to fix the conflict, and launch is not blocked. In subsequent calls to
     * <a>ProvisionProduct</a>, do not include conflicted TagOption keys as tags, or this causes the error
     * "Parameter validation failed: Missing required parameter in Tags[<i>N</i>]:<i>Value</i>". Tag the provisioned
     * product with the value <code>sc-tagoption-conflict-portfolioId-productId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProvisioningParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeProvisioningParametersRequest#builder()}
     * </p>
     *
     * @param describeProvisioningParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProvisioningParametersInput.Builder} to create
     *        a request.
     * @return Result of the DescribeProvisioningParameters operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProvisioningParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProvisioningParametersResponse describeProvisioningParameters(
            Consumer<DescribeProvisioningParametersRequest.Builder> describeProvisioningParametersRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return describeProvisioningParameters(DescribeProvisioningParametersRequest.builder()
                .applyMutation(describeProvisioningParametersRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified request operation.
     * </p>
     * <p>
     * Use this operation after calling a request operation (for example, <a>ProvisionProduct</a>,
     * <a>TerminateProvisionedProduct</a>, or <a>UpdateProvisionedProduct</a>).
     * </p>
     * <note>
     * <p>
     * If a provisioned product was transferred to a new owner using <a>UpdateProvisionedProductProperties</a>, the new
     * owner will be able to describe all past records for that product. The previous owner will no longer be able to
     * describe the records, but will be able to use <a>ListRecordHistory</a> to see the product's history from when he
     * was the owner.
     * </p>
     * </note>
     *
     * @param describeRecordRequest
     * @return Result of the DescribeRecord operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeRecord" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecordResponse describeRecord(DescribeRecordRequest describeRecordRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified request operation.
     * </p>
     * <p>
     * Use this operation after calling a request operation (for example, <a>ProvisionProduct</a>,
     * <a>TerminateProvisionedProduct</a>, or <a>UpdateProvisionedProduct</a>).
     * </p>
     * <note>
     * <p>
     * If a provisioned product was transferred to a new owner using <a>UpdateProvisionedProductProperties</a>, the new
     * owner will be able to describe all past records for that product. The previous owner will no longer be able to
     * describe the records, but will be able to use <a>ListRecordHistory</a> to see the product's history from when he
     * was the owner.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecordRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeRecordRequest#builder()}
     * </p>
     *
     * @param describeRecordRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRecordInput.Builder} to create a request.
     * @return Result of the DescribeRecord operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeRecord" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecordResponse describeRecord(Consumer<DescribeRecordRequest.Builder> describeRecordRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return describeRecord(DescribeRecordRequest.builder().applyMutation(describeRecordRequest).build());
    }

    /**
     * <p>
     * Describes a self-service action.
     * </p>
     *
     * @param describeServiceActionRequest
     * @return Result of the DescribeServiceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeServiceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeServiceActionResponse describeServiceAction(DescribeServiceActionRequest describeServiceActionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a self-service action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeServiceActionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeServiceActionRequest#builder()}
     * </p>
     *
     * @param describeServiceActionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeServiceActionInput.Builder} to create a
     *        request.
     * @return Result of the DescribeServiceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeServiceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeServiceActionResponse describeServiceAction(
            Consumer<DescribeServiceActionRequest.Builder> describeServiceActionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        return describeServiceAction(DescribeServiceActionRequest.builder().applyMutation(describeServiceActionRequest).build());
    }

    /**
     * <p>
     * Finds the default parameters for a specific self-service action on a specific provisioned product and returns a
     * map of the results to the user.
     * </p>
     *
     * @param describeServiceActionExecutionParametersRequest
     * @return Result of the DescribeServiceActionExecutionParameters operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeServiceActionExecutionParameters
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeServiceActionExecutionParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeServiceActionExecutionParametersResponse describeServiceActionExecutionParameters(
            DescribeServiceActionExecutionParametersRequest describeServiceActionExecutionParametersRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Finds the default parameters for a specific self-service action on a specific provisioned product and returns a
     * map of the results to the user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeServiceActionExecutionParametersRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeServiceActionExecutionParametersRequest#builder()}
     * </p>
     *
     * @param describeServiceActionExecutionParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeServiceActionExecutionParametersInput.Builder}
     *        to create a request.
     * @return Result of the DescribeServiceActionExecutionParameters operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeServiceActionExecutionParameters
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeServiceActionExecutionParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeServiceActionExecutionParametersResponse describeServiceActionExecutionParameters(
            Consumer<DescribeServiceActionExecutionParametersRequest.Builder> describeServiceActionExecutionParametersRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return describeServiceActionExecutionParameters(DescribeServiceActionExecutionParametersRequest.builder()
                .applyMutation(describeServiceActionExecutionParametersRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified TagOption.
     * </p>
     *
     * @param describeTagOptionRequest
     * @return Result of the DescribeTagOption operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTagOptionResponse describeTagOption(DescribeTagOptionRequest describeTagOptionRequest)
            throws TagOptionNotMigratedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified TagOption.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTagOptionRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeTagOptionRequest#builder()}
     * </p>
     *
     * @param describeTagOptionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTagOptionInput.Builder} to create a request.
     * @return Result of the DescribeTagOption operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTagOptionResponse describeTagOption(Consumer<DescribeTagOptionRequest.Builder> describeTagOptionRequest)
            throws TagOptionNotMigratedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return describeTagOption(DescribeTagOptionRequest.builder().applyMutation(describeTagOptionRequest).build());
    }

    /**
     * <p>
     * Disable portfolio sharing through the Organizations service. This command will not delete your current shares,
     * but prevents you from creating new shares throughout your organization. Current shares are not kept in sync with
     * your organization structure if the structure changes after calling this API. Only the management account in the
     * organization can call this API.
     * </p>
     * <p>
     * You cannot call this API if there are active delegated administrators in the organization.
     * </p>
     * <p>
     * Note that a delegated administrator is not authorized to invoke <code>DisableAWSOrganizationsAccess</code>.
     * </p>
     * <important>
     * <p>
     * If you share an Service Catalog portfolio in an organization within Organizations, and then disable Organizations
     * access for Service Catalog, the portfolio access permissions will not sync with the latest changes to the
     * organization structure. Specifically, accounts that you removed from the organization after disabling Service
     * Catalog access will retain access to the previously shared portfolio.
     * </p>
     * </important>
     *
     * @param disableAwsOrganizationsAccessRequest
     * @return Result of the DisableAWSOrganizationsAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DisableAWSOrganizationsAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisableAWSOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableAwsOrganizationsAccessResponse disableAWSOrganizationsAccess(
            DisableAwsOrganizationsAccessRequest disableAwsOrganizationsAccessRequest) throws ResourceNotFoundException,
            InvalidStateException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disable portfolio sharing through the Organizations service. This command will not delete your current shares,
     * but prevents you from creating new shares throughout your organization. Current shares are not kept in sync with
     * your organization structure if the structure changes after calling this API. Only the management account in the
     * organization can call this API.
     * </p>
     * <p>
     * You cannot call this API if there are active delegated administrators in the organization.
     * </p>
     * <p>
     * Note that a delegated administrator is not authorized to invoke <code>DisableAWSOrganizationsAccess</code>.
     * </p>
     * <important>
     * <p>
     * If you share an Service Catalog portfolio in an organization within Organizations, and then disable Organizations
     * access for Service Catalog, the portfolio access permissions will not sync with the latest changes to the
     * organization structure. Specifically, accounts that you removed from the organization after disabling Service
     * Catalog access will retain access to the previously shared portfolio.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableAwsOrganizationsAccessRequest.Builder}
     * avoiding the need to create one manually via {@link DisableAwsOrganizationsAccessRequest#builder()}
     * </p>
     *
     * @param disableAwsOrganizationsAccessRequest
     *        A {@link Consumer} that will call methods on {@link DisableAWSOrganizationsAccessInput.Builder} to create
     *        a request.
     * @return Result of the DisableAWSOrganizationsAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DisableAWSOrganizationsAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisableAWSOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableAwsOrganizationsAccessResponse disableAWSOrganizationsAccess(
            Consumer<DisableAwsOrganizationsAccessRequest.Builder> disableAwsOrganizationsAccessRequest)
            throws ResourceNotFoundException, InvalidStateException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return disableAWSOrganizationsAccess(DisableAwsOrganizationsAccessRequest.builder()
                .applyMutation(disableAwsOrganizationsAccessRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified budget from the specified resource.
     * </p>
     *
     * @param disassociateBudgetFromResourceRequest
     * @return Result of the DisassociateBudgetFromResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DisassociateBudgetFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateBudgetFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateBudgetFromResourceResponse disassociateBudgetFromResource(
            DisassociateBudgetFromResourceRequest disassociateBudgetFromResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified budget from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateBudgetFromResourceRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateBudgetFromResourceRequest#builder()}
     * </p>
     *
     * @param disassociateBudgetFromResourceRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateBudgetFromResourceInput.Builder} to create
     *        a request.
     * @return Result of the DisassociateBudgetFromResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DisassociateBudgetFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateBudgetFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateBudgetFromResourceResponse disassociateBudgetFromResource(
            Consumer<DisassociateBudgetFromResourceRequest.Builder> disassociateBudgetFromResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return disassociateBudgetFromResource(DisassociateBudgetFromResourceRequest.builder()
                .applyMutation(disassociateBudgetFromResourceRequest).build());
    }

    /**
     * <p>
     * Disassociates a previously associated principal ARN from a specified portfolio.
     * </p>
     * <p>
     * The <code>PrincipalType</code> and <code>PrincipalARN</code> must match the
     * <code>AssociatePrincipalWithPortfolio</code> call request details. For example, to disassociate an association
     * created with a <code>PrincipalARN</code> of <code>PrincipalType</code> IAM you must use the
     * <code>PrincipalType</code> IAM when calling <code>DisassociatePrincipalFromPortfolio</code>.
     * </p>
     * <p>
     * For portfolios that have been shared with principal name sharing enabled: after disassociating a principal, share
     * recipient accounts will no longer be able to provision products in this portfolio using a role matching the name
     * of the associated principal.
     * </p>
     * <p>
     * For more information, review <a href=
     * "https://docs.aws.amazon.com/cli/latest/reference/servicecatalog/associate-principal-with-portfolio.html#options"
     * >associate-principal-with-portfolio</a> in the Amazon Web Services CLI Command Reference.
     * </p>
     * <note>
     * <p>
     * If you disassociate a principal from a portfolio, with PrincipalType as <code>IAM</code>, the same principal will
     * still have access to the portfolio if it matches one of the associated principals of type
     * <code>IAM_PATTERN</code>. To fully remove access for a principal, verify all the associated Principals of type
     * <code>IAM_PATTERN</code>, and then ensure you disassociate any <code>IAM_PATTERN</code> principals that match the
     * principal whose access you are removing.
     * </p>
     * </note>
     *
     * @param disassociatePrincipalFromPortfolioRequest
     * @return Result of the DisassociatePrincipalFromPortfolio operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DisassociatePrincipalFromPortfolio
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociatePrincipalFromPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociatePrincipalFromPortfolioResponse disassociatePrincipalFromPortfolio(
            DisassociatePrincipalFromPortfolioRequest disassociatePrincipalFromPortfolioRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a previously associated principal ARN from a specified portfolio.
     * </p>
     * <p>
     * The <code>PrincipalType</code> and <code>PrincipalARN</code> must match the
     * <code>AssociatePrincipalWithPortfolio</code> call request details. For example, to disassociate an association
     * created with a <code>PrincipalARN</code> of <code>PrincipalType</code> IAM you must use the
     * <code>PrincipalType</code> IAM when calling <code>DisassociatePrincipalFromPortfolio</code>.
     * </p>
     * <p>
     * For portfolios that have been shared with principal name sharing enabled: after disassociating a principal, share
     * recipient accounts will no longer be able to provision products in this portfolio using a role matching the name
     * of the associated principal.
     * </p>
     * <p>
     * For more information, review <a href=
     * "https://docs.aws.amazon.com/cli/latest/reference/servicecatalog/associate-principal-with-portfolio.html#options"
     * >associate-principal-with-portfolio</a> in the Amazon Web Services CLI Command Reference.
     * </p>
     * <note>
     * <p>
     * If you disassociate a principal from a portfolio, with PrincipalType as <code>IAM</code>, the same principal will
     * still have access to the portfolio if it matches one of the associated principals of type
     * <code>IAM_PATTERN</code>. To fully remove access for a principal, verify all the associated Principals of type
     * <code>IAM_PATTERN</code>, and then ensure you disassociate any <code>IAM_PATTERN</code> principals that match the
     * principal whose access you are removing.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociatePrincipalFromPortfolioRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociatePrincipalFromPortfolioRequest#builder()}
     * </p>
     *
     * @param disassociatePrincipalFromPortfolioRequest
     *        A {@link Consumer} that will call methods on {@link DisassociatePrincipalFromPortfolioInput.Builder} to
     *        create a request.
     * @return Result of the DisassociatePrincipalFromPortfolio operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DisassociatePrincipalFromPortfolio
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociatePrincipalFromPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociatePrincipalFromPortfolioResponse disassociatePrincipalFromPortfolio(
            Consumer<DisassociatePrincipalFromPortfolioRequest.Builder> disassociatePrincipalFromPortfolioRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return disassociatePrincipalFromPortfolio(DisassociatePrincipalFromPortfolioRequest.builder()
                .applyMutation(disassociatePrincipalFromPortfolioRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified product from the specified portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param disassociateProductFromPortfolioRequest
     * @return Result of the DisassociateProductFromPortfolio operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         A resource that is currently in use. Ensure that the resource is not in use and retry the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DisassociateProductFromPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateProductFromPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateProductFromPortfolioResponse disassociateProductFromPortfolio(
            DisassociateProductFromPortfolioRequest disassociateProductFromPortfolioRequest) throws ResourceNotFoundException,
            ResourceInUseException, InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified product from the specified portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateProductFromPortfolioRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateProductFromPortfolioRequest#builder()}
     * </p>
     *
     * @param disassociateProductFromPortfolioRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateProductFromPortfolioInput.Builder} to
     *        create a request.
     * @return Result of the DisassociateProductFromPortfolio operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         A resource that is currently in use. Ensure that the resource is not in use and retry the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DisassociateProductFromPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateProductFromPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateProductFromPortfolioResponse disassociateProductFromPortfolio(
            Consumer<DisassociateProductFromPortfolioRequest.Builder> disassociateProductFromPortfolioRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidParametersException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return disassociateProductFromPortfolio(DisassociateProductFromPortfolioRequest.builder()
                .applyMutation(disassociateProductFromPortfolioRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified self-service action association from the specified provisioning artifact.
     * </p>
     *
     * @param disassociateServiceActionFromProvisioningArtifactRequest
     * @return Result of the DisassociateServiceActionFromProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DisassociateServiceActionFromProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateServiceActionFromProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateServiceActionFromProvisioningArtifactResponse disassociateServiceActionFromProvisioningArtifact(
            DisassociateServiceActionFromProvisioningArtifactRequest disassociateServiceActionFromProvisioningArtifactRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified self-service action association from the specified provisioning artifact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateServiceActionFromProvisioningArtifactRequest.Builder} avoiding the need to create one manually
     * via {@link DisassociateServiceActionFromProvisioningArtifactRequest#builder()}
     * </p>
     *
     * @param disassociateServiceActionFromProvisioningArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateServiceActionFromProvisioningArtifactInput.Builder} to create a request.
     * @return Result of the DisassociateServiceActionFromProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DisassociateServiceActionFromProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateServiceActionFromProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateServiceActionFromProvisioningArtifactResponse disassociateServiceActionFromProvisioningArtifact(
            Consumer<DisassociateServiceActionFromProvisioningArtifactRequest.Builder> disassociateServiceActionFromProvisioningArtifactRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return disassociateServiceActionFromProvisioningArtifact(DisassociateServiceActionFromProvisioningArtifactRequest
                .builder().applyMutation(disassociateServiceActionFromProvisioningArtifactRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified TagOption from the specified resource.
     * </p>
     *
     * @param disassociateTagOptionFromResourceRequest
     * @return Result of the DisassociateTagOptionFromResource operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DisassociateTagOptionFromResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateTagOptionFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateTagOptionFromResourceResponse disassociateTagOptionFromResource(
            DisassociateTagOptionFromResourceRequest disassociateTagOptionFromResourceRequest)
            throws TagOptionNotMigratedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified TagOption from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateTagOptionFromResourceRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateTagOptionFromResourceRequest#builder()}
     * </p>
     *
     * @param disassociateTagOptionFromResourceRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateTagOptionFromResourceInput.Builder} to
     *        create a request.
     * @return Result of the DisassociateTagOptionFromResource operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DisassociateTagOptionFromResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateTagOptionFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateTagOptionFromResourceResponse disassociateTagOptionFromResource(
            Consumer<DisassociateTagOptionFromResourceRequest.Builder> disassociateTagOptionFromResourceRequest)
            throws TagOptionNotMigratedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return disassociateTagOptionFromResource(DisassociateTagOptionFromResourceRequest.builder()
                .applyMutation(disassociateTagOptionFromResourceRequest).build());
    }

    /**
     * <p>
     * Enable portfolio sharing feature through Organizations. This API will allow Service Catalog to receive updates on
     * your organization in order to sync your shares with the current structure. This API can only be called by the
     * management account in the organization.
     * </p>
     * <p>
     * When you call this API, Service Catalog calls <code>organizations:EnableAWSServiceAccess</code> on your behalf so
     * that your shares stay in sync with any changes in your Organizations structure.
     * </p>
     * <p>
     * Note that a delegated administrator is not authorized to invoke <code>EnableAWSOrganizationsAccess</code>.
     * </p>
     * <important>
     * <p>
     * If you have previously disabled Organizations access for Service Catalog, and then enable access again, the
     * portfolio access permissions might not sync with the latest changes to the organization structure. Specifically,
     * accounts that you removed from the organization after disabling Service Catalog access, and before you enabled
     * access again, can retain access to the previously shared portfolio. As a result, an account that has been removed
     * from the organization might still be able to create or manage Amazon Web Services resources when it is no longer
     * authorized to do so. Amazon Web Services is working to resolve this issue.
     * </p>
     * </important>
     *
     * @param enableAwsOrganizationsAccessRequest
     * @return Result of the EnableAWSOrganizationsAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.EnableAWSOrganizationsAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/EnableAWSOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableAwsOrganizationsAccessResponse enableAWSOrganizationsAccess(
            EnableAwsOrganizationsAccessRequest enableAwsOrganizationsAccessRequest) throws ResourceNotFoundException,
            InvalidStateException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable portfolio sharing feature through Organizations. This API will allow Service Catalog to receive updates on
     * your organization in order to sync your shares with the current structure. This API can only be called by the
     * management account in the organization.
     * </p>
     * <p>
     * When you call this API, Service Catalog calls <code>organizations:EnableAWSServiceAccess</code> on your behalf so
     * that your shares stay in sync with any changes in your Organizations structure.
     * </p>
     * <p>
     * Note that a delegated administrator is not authorized to invoke <code>EnableAWSOrganizationsAccess</code>.
     * </p>
     * <important>
     * <p>
     * If you have previously disabled Organizations access for Service Catalog, and then enable access again, the
     * portfolio access permissions might not sync with the latest changes to the organization structure. Specifically,
     * accounts that you removed from the organization after disabling Service Catalog access, and before you enabled
     * access again, can retain access to the previously shared portfolio. As a result, an account that has been removed
     * from the organization might still be able to create or manage Amazon Web Services resources when it is no longer
     * authorized to do so. Amazon Web Services is working to resolve this issue.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableAwsOrganizationsAccessRequest.Builder}
     * avoiding the need to create one manually via {@link EnableAwsOrganizationsAccessRequest#builder()}
     * </p>
     *
     * @param enableAwsOrganizationsAccessRequest
     *        A {@link Consumer} that will call methods on {@link EnableAWSOrganizationsAccessInput.Builder} to create a
     *        request.
     * @return Result of the EnableAWSOrganizationsAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.EnableAWSOrganizationsAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/EnableAWSOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableAwsOrganizationsAccessResponse enableAWSOrganizationsAccess(
            Consumer<EnableAwsOrganizationsAccessRequest.Builder> enableAwsOrganizationsAccessRequest)
            throws ResourceNotFoundException, InvalidStateException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return enableAWSOrganizationsAccess(EnableAwsOrganizationsAccessRequest.builder()
                .applyMutation(enableAwsOrganizationsAccessRequest).build());
    }

    /**
     * <p>
     * Provisions or modifies a product based on the resource changes for the specified plan.
     * </p>
     *
     * @param executeProvisionedProductPlanRequest
     * @return Result of the ExecuteProvisionedProductPlan operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ExecuteProvisionedProductPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ExecuteProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default ExecuteProvisionedProductPlanResponse executeProvisionedProductPlan(
            ExecuteProvisionedProductPlanRequest executeProvisionedProductPlanRequest) throws InvalidParametersException,
            ResourceNotFoundException, InvalidStateException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provisions or modifies a product based on the resource changes for the specified plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteProvisionedProductPlanRequest.Builder}
     * avoiding the need to create one manually via {@link ExecuteProvisionedProductPlanRequest#builder()}
     * </p>
     *
     * @param executeProvisionedProductPlanRequest
     *        A {@link Consumer} that will call methods on {@link ExecuteProvisionedProductPlanInput.Builder} to create
     *        a request.
     * @return Result of the ExecuteProvisionedProductPlan operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ExecuteProvisionedProductPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ExecuteProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default ExecuteProvisionedProductPlanResponse executeProvisionedProductPlan(
            Consumer<ExecuteProvisionedProductPlanRequest.Builder> executeProvisionedProductPlanRequest)
            throws InvalidParametersException, ResourceNotFoundException, InvalidStateException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return executeProvisionedProductPlan(ExecuteProvisionedProductPlanRequest.builder()
                .applyMutation(executeProvisionedProductPlanRequest).build());
    }

    /**
     * <p>
     * Executes a self-service action against a provisioned product.
     * </p>
     *
     * @param executeProvisionedProductServiceActionRequest
     * @return Result of the ExecuteProvisionedProductServiceAction operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ExecuteProvisionedProductServiceAction
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ExecuteProvisionedProductServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default ExecuteProvisionedProductServiceActionResponse executeProvisionedProductServiceAction(
            ExecuteProvisionedProductServiceActionRequest executeProvisionedProductServiceActionRequest)
            throws InvalidParametersException, ResourceNotFoundException, InvalidStateException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Executes a self-service action against a provisioned product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ExecuteProvisionedProductServiceActionRequest.Builder} avoiding the need to create one manually via
     * {@link ExecuteProvisionedProductServiceActionRequest#builder()}
     * </p>
     *
     * @param executeProvisionedProductServiceActionRequest
     *        A {@link Consumer} that will call methods on {@link ExecuteProvisionedProductServiceActionInput.Builder}
     *        to create a request.
     * @return Result of the ExecuteProvisionedProductServiceAction operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ExecuteProvisionedProductServiceAction
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ExecuteProvisionedProductServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default ExecuteProvisionedProductServiceActionResponse executeProvisionedProductServiceAction(
            Consumer<ExecuteProvisionedProductServiceActionRequest.Builder> executeProvisionedProductServiceActionRequest)
            throws InvalidParametersException, ResourceNotFoundException, InvalidStateException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return executeProvisionedProductServiceAction(ExecuteProvisionedProductServiceActionRequest.builder()
                .applyMutation(executeProvisionedProductServiceActionRequest).build());
    }

    /**
     * <p>
     * Get the Access Status for Organizations portfolio share feature. This API can only be called by the management
     * account in the organization or by a delegated admin.
     * </p>
     *
     * @param getAwsOrganizationsAccessStatusRequest
     * @return Result of the GetAWSOrganizationsAccessStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.GetAWSOrganizationsAccessStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetAWSOrganizationsAccessStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAwsOrganizationsAccessStatusResponse getAWSOrganizationsAccessStatus(
            GetAwsOrganizationsAccessStatusRequest getAwsOrganizationsAccessStatusRequest) throws ResourceNotFoundException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the Access Status for Organizations portfolio share feature. This API can only be called by the management
     * account in the organization or by a delegated admin.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAwsOrganizationsAccessStatusRequest.Builder}
     * avoiding the need to create one manually via {@link GetAwsOrganizationsAccessStatusRequest#builder()}
     * </p>
     *
     * @param getAwsOrganizationsAccessStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetAWSOrganizationsAccessStatusInput.Builder} to
     *        create a request.
     * @return Result of the GetAWSOrganizationsAccessStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.GetAWSOrganizationsAccessStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetAWSOrganizationsAccessStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAwsOrganizationsAccessStatusResponse getAWSOrganizationsAccessStatus(
            Consumer<GetAwsOrganizationsAccessStatusRequest.Builder> getAwsOrganizationsAccessStatusRequest)
            throws ResourceNotFoundException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return getAWSOrganizationsAccessStatus(GetAwsOrganizationsAccessStatusRequest.builder()
                .applyMutation(getAwsOrganizationsAccessStatusRequest).build());
    }

    /**
     * <p>
     * Get the Access Status for Organizations portfolio share feature. This API can only be called by the management
     * account in the organization or by a delegated admin.
     * </p>
     *
     * @return Result of the GetAWSOrganizationsAccessStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.GetAWSOrganizationsAccessStatus
     * @see #getAWSOrganizationsAccessStatus(GetAwsOrganizationsAccessStatusRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetAWSOrganizationsAccessStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAwsOrganizationsAccessStatusResponse getAWSOrganizationsAccessStatus() throws ResourceNotFoundException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return getAWSOrganizationsAccessStatus(GetAwsOrganizationsAccessStatusRequest.builder().build());
    }

    /**
     * <p>
     * This API takes either a <code>ProvisonedProductId</code> or a <code>ProvisionedProductName</code>, along with a
     * list of one or more output keys, and responds with the key/value pairs of those outputs.
     * </p>
     *
     * @param getProvisionedProductOutputsRequest
     * @return Result of the GetProvisionedProductOutputs operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.GetProvisionedProductOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetProvisionedProductOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProvisionedProductOutputsResponse getProvisionedProductOutputs(
            GetProvisionedProductOutputsRequest getProvisionedProductOutputsRequest) throws InvalidParametersException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API takes either a <code>ProvisonedProductId</code> or a <code>ProvisionedProductName</code>, along with a
     * list of one or more output keys, and responds with the key/value pairs of those outputs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProvisionedProductOutputsRequest.Builder}
     * avoiding the need to create one manually via {@link GetProvisionedProductOutputsRequest#builder()}
     * </p>
     *
     * @param getProvisionedProductOutputsRequest
     *        A {@link Consumer} that will call methods on {@link GetProvisionedProductOutputsInput.Builder} to create a
     *        request.
     * @return Result of the GetProvisionedProductOutputs operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.GetProvisionedProductOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetProvisionedProductOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProvisionedProductOutputsResponse getProvisionedProductOutputs(
            Consumer<GetProvisionedProductOutputsRequest.Builder> getProvisionedProductOutputsRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return getProvisionedProductOutputs(GetProvisionedProductOutputsRequest.builder()
                .applyMutation(getProvisionedProductOutputsRequest).build());
    }

    /**
     * <p>
     * This API takes either a <code>ProvisonedProductId</code> or a <code>ProvisionedProductName</code>, along with a
     * list of one or more output keys, and responds with the key/value pairs of those outputs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getProvisionedProductOutputs(software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.GetProvisionedProductOutputsIterable responses = client.getProvisionedProductOutputsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.GetProvisionedProductOutputsIterable responses = client
     *             .getProvisionedProductOutputsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.GetProvisionedProductOutputsIterable responses = client.getProvisionedProductOutputsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getProvisionedProductOutputs(software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getProvisionedProductOutputsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.GetProvisionedProductOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetProvisionedProductOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProvisionedProductOutputsIterable getProvisionedProductOutputsPaginator(
            GetProvisionedProductOutputsRequest getProvisionedProductOutputsRequest) throws InvalidParametersException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return new GetProvisionedProductOutputsIterable(this, getProvisionedProductOutputsRequest);
    }

    /**
     * <p>
     * This API takes either a <code>ProvisonedProductId</code> or a <code>ProvisionedProductName</code>, along with a
     * list of one or more output keys, and responds with the key/value pairs of those outputs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getProvisionedProductOutputs(software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.GetProvisionedProductOutputsIterable responses = client.getProvisionedProductOutputsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.GetProvisionedProductOutputsIterable responses = client
     *             .getProvisionedProductOutputsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.GetProvisionedProductOutputsIterable responses = client.getProvisionedProductOutputsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getProvisionedProductOutputs(software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProvisionedProductOutputsRequest.Builder}
     * avoiding the need to create one manually via {@link GetProvisionedProductOutputsRequest#builder()}
     * </p>
     *
     * @param getProvisionedProductOutputsRequest
     *        A {@link Consumer} that will call methods on {@link GetProvisionedProductOutputsInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.GetProvisionedProductOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetProvisionedProductOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProvisionedProductOutputsIterable getProvisionedProductOutputsPaginator(
            Consumer<GetProvisionedProductOutputsRequest.Builder> getProvisionedProductOutputsRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return getProvisionedProductOutputsPaginator(GetProvisionedProductOutputsRequest.builder()
                .applyMutation(getProvisionedProductOutputsRequest).build());
    }

    /**
     * <p>
     * Requests the import of a resource as an Service Catalog provisioned product that is associated to an Service
     * Catalog product and provisioning artifact. Once imported, all supported governance actions are supported on the
     * provisioned product.
     * </p>
     * <p>
     * Resource import only supports CloudFormation stack ARNs. CloudFormation StackSets, and non-root nested stacks are
     * not supported.
     * </p>
     * <p>
     * The CloudFormation stack must have one of the following statuses to be imported: <code>CREATE_COMPLETE</code>,
     * <code>UPDATE_COMPLETE</code>, <code>UPDATE_ROLLBACK_COMPLETE</code>, <code>IMPORT_COMPLETE</code>, and
     * <code>IMPORT_ROLLBACK_COMPLETE</code>.
     * </p>
     * <p>
     * Import of the resource requires that the CloudFormation stack template matches the associated Service Catalog
     * product provisioning artifact.
     * </p>
     * <note>
     * <p>
     * When you import an existing CloudFormation stack into a portfolio, constraints that are associated with the
     * product aren't applied during the import process. The constraints are applied after you call
     * <code>UpdateProvisionedProduct</code> for the provisioned product.
     * </p>
     * </note>
     * <p>
     * The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> and
     * <code>cloudformation:DescribeStacks</code> IAM policy permissions.
     * </p>
     *
     * @param importAsProvisionedProductRequest
     * @return Result of the ImportAsProvisionedProduct operation returned by the service.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ImportAsProvisionedProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ImportAsProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportAsProvisionedProductResponse importAsProvisionedProduct(
            ImportAsProvisionedProductRequest importAsProvisionedProductRequest) throws DuplicateResourceException,
            InvalidStateException, ResourceNotFoundException, InvalidParametersException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests the import of a resource as an Service Catalog provisioned product that is associated to an Service
     * Catalog product and provisioning artifact. Once imported, all supported governance actions are supported on the
     * provisioned product.
     * </p>
     * <p>
     * Resource import only supports CloudFormation stack ARNs. CloudFormation StackSets, and non-root nested stacks are
     * not supported.
     * </p>
     * <p>
     * The CloudFormation stack must have one of the following statuses to be imported: <code>CREATE_COMPLETE</code>,
     * <code>UPDATE_COMPLETE</code>, <code>UPDATE_ROLLBACK_COMPLETE</code>, <code>IMPORT_COMPLETE</code>, and
     * <code>IMPORT_ROLLBACK_COMPLETE</code>.
     * </p>
     * <p>
     * Import of the resource requires that the CloudFormation stack template matches the associated Service Catalog
     * product provisioning artifact.
     * </p>
     * <note>
     * <p>
     * When you import an existing CloudFormation stack into a portfolio, constraints that are associated with the
     * product aren't applied during the import process. The constraints are applied after you call
     * <code>UpdateProvisionedProduct</code> for the provisioned product.
     * </p>
     * </note>
     * <p>
     * The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> and
     * <code>cloudformation:DescribeStacks</code> IAM policy permissions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportAsProvisionedProductRequest.Builder} avoiding
     * the need to create one manually via {@link ImportAsProvisionedProductRequest#builder()}
     * </p>
     *
     * @param importAsProvisionedProductRequest
     *        A {@link Consumer} that will call methods on {@link ImportAsProvisionedProductInput.Builder} to create a
     *        request.
     * @return Result of the ImportAsProvisionedProduct operation returned by the service.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ImportAsProvisionedProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ImportAsProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportAsProvisionedProductResponse importAsProvisionedProduct(
            Consumer<ImportAsProvisionedProductRequest.Builder> importAsProvisionedProductRequest)
            throws DuplicateResourceException, InvalidStateException, ResourceNotFoundException, InvalidParametersException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        return importAsProvisionedProduct(ImportAsProvisionedProductRequest.builder()
                .applyMutation(importAsProvisionedProductRequest).build());
    }

    /**
     * <p>
     * Lists all imported portfolios for which account-to-account shares were accepted by this account. By specifying
     * the <code>PortfolioShareType</code>, you can list portfolios for which organizational shares were accepted by
     * this account.
     * </p>
     *
     * @param listAcceptedPortfolioSharesRequest
     * @return Result of the ListAcceptedPortfolioShares operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListAcceptedPortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListAcceptedPortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAcceptedPortfolioSharesResponse listAcceptedPortfolioShares(
            ListAcceptedPortfolioSharesRequest listAcceptedPortfolioSharesRequest) throws InvalidParametersException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all imported portfolios for which account-to-account shares were accepted by this account. By specifying
     * the <code>PortfolioShareType</code>, you can list portfolios for which organizational shares were accepted by
     * this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAcceptedPortfolioSharesRequest.Builder}
     * avoiding the need to create one manually via {@link ListAcceptedPortfolioSharesRequest#builder()}
     * </p>
     *
     * @param listAcceptedPortfolioSharesRequest
     *        A {@link Consumer} that will call methods on {@link ListAcceptedPortfolioSharesInput.Builder} to create a
     *        request.
     * @return Result of the ListAcceptedPortfolioShares operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListAcceptedPortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListAcceptedPortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAcceptedPortfolioSharesResponse listAcceptedPortfolioShares(
            Consumer<ListAcceptedPortfolioSharesRequest.Builder> listAcceptedPortfolioSharesRequest)
            throws InvalidParametersException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return listAcceptedPortfolioShares(ListAcceptedPortfolioSharesRequest.builder()
                .applyMutation(listAcceptedPortfolioSharesRequest).build());
    }

    /**
     * <p>
     * Lists all imported portfolios for which account-to-account shares were accepted by this account. By specifying
     * the <code>PortfolioShareType</code>, you can list portfolios for which organizational shares were accepted by
     * this account.
     * </p>
     *
     * @return Result of the ListAcceptedPortfolioShares operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListAcceptedPortfolioShares
     * @see #listAcceptedPortfolioShares(ListAcceptedPortfolioSharesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListAcceptedPortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAcceptedPortfolioSharesResponse listAcceptedPortfolioShares() throws InvalidParametersException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return listAcceptedPortfolioShares(ListAcceptedPortfolioSharesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all imported portfolios for which account-to-account shares were accepted by this account. By specifying
     * the <code>PortfolioShareType</code>, you can list portfolios for which organizational shares were accepted by
     * this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAcceptedPortfolioShares(software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesIterable responses = client.listAcceptedPortfolioSharesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesIterable responses = client
     *             .listAcceptedPortfolioSharesPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesIterable responses = client.listAcceptedPortfolioSharesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAcceptedPortfolioShares(software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListAcceptedPortfolioShares
     * @see #listAcceptedPortfolioSharesPaginator(ListAcceptedPortfolioSharesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListAcceptedPortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAcceptedPortfolioSharesIterable listAcceptedPortfolioSharesPaginator() throws InvalidParametersException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return listAcceptedPortfolioSharesPaginator(ListAcceptedPortfolioSharesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all imported portfolios for which account-to-account shares were accepted by this account. By specifying
     * the <code>PortfolioShareType</code>, you can list portfolios for which organizational shares were accepted by
     * this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAcceptedPortfolioShares(software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesIterable responses = client.listAcceptedPortfolioSharesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesIterable responses = client
     *             .listAcceptedPortfolioSharesPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesIterable responses = client.listAcceptedPortfolioSharesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAcceptedPortfolioShares(software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAcceptedPortfolioSharesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListAcceptedPortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListAcceptedPortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAcceptedPortfolioSharesIterable listAcceptedPortfolioSharesPaginator(
            ListAcceptedPortfolioSharesRequest listAcceptedPortfolioSharesRequest) throws InvalidParametersException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return new ListAcceptedPortfolioSharesIterable(this, listAcceptedPortfolioSharesRequest);
    }

    /**
     * <p>
     * Lists all imported portfolios for which account-to-account shares were accepted by this account. By specifying
     * the <code>PortfolioShareType</code>, you can list portfolios for which organizational shares were accepted by
     * this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAcceptedPortfolioShares(software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesIterable responses = client.listAcceptedPortfolioSharesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesIterable responses = client
     *             .listAcceptedPortfolioSharesPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesIterable responses = client.listAcceptedPortfolioSharesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAcceptedPortfolioShares(software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAcceptedPortfolioSharesRequest.Builder}
     * avoiding the need to create one manually via {@link ListAcceptedPortfolioSharesRequest#builder()}
     * </p>
     *
     * @param listAcceptedPortfolioSharesRequest
     *        A {@link Consumer} that will call methods on {@link ListAcceptedPortfolioSharesInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListAcceptedPortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListAcceptedPortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAcceptedPortfolioSharesIterable listAcceptedPortfolioSharesPaginator(
            Consumer<ListAcceptedPortfolioSharesRequest.Builder> listAcceptedPortfolioSharesRequest)
            throws InvalidParametersException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return listAcceptedPortfolioSharesPaginator(ListAcceptedPortfolioSharesRequest.builder()
                .applyMutation(listAcceptedPortfolioSharesRequest).build());
    }

    /**
     * <p>
     * Lists all the budgets associated to the specified resource.
     * </p>
     *
     * @param listBudgetsForResourceRequest
     * @return Result of the ListBudgetsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListBudgetsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListBudgetsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBudgetsForResourceResponse listBudgetsForResource(ListBudgetsForResourceRequest listBudgetsForResourceRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the budgets associated to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBudgetsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListBudgetsForResourceRequest#builder()}
     * </p>
     *
     * @param listBudgetsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListBudgetsForResourceInput.Builder} to create a
     *        request.
     * @return Result of the ListBudgetsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListBudgetsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListBudgetsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBudgetsForResourceResponse listBudgetsForResource(
            Consumer<ListBudgetsForResourceRequest.Builder> listBudgetsForResourceRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return listBudgetsForResource(ListBudgetsForResourceRequest.builder().applyMutation(listBudgetsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the budgets associated to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBudgetsForResource(software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListBudgetsForResourceIterable responses = client.listBudgetsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListBudgetsForResourceIterable responses = client
     *             .listBudgetsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListBudgetsForResourceIterable responses = client.listBudgetsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBudgetsForResource(software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBudgetsForResourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListBudgetsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListBudgetsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBudgetsForResourceIterable listBudgetsForResourcePaginator(
            ListBudgetsForResourceRequest listBudgetsForResourceRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return new ListBudgetsForResourceIterable(this, listBudgetsForResourceRequest);
    }

    /**
     * <p>
     * Lists all the budgets associated to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBudgetsForResource(software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListBudgetsForResourceIterable responses = client.listBudgetsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListBudgetsForResourceIterable responses = client
     *             .listBudgetsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListBudgetsForResourceIterable responses = client.listBudgetsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBudgetsForResource(software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBudgetsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListBudgetsForResourceRequest#builder()}
     * </p>
     *
     * @param listBudgetsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListBudgetsForResourceInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListBudgetsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListBudgetsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBudgetsForResourceIterable listBudgetsForResourcePaginator(
            Consumer<ListBudgetsForResourceRequest.Builder> listBudgetsForResourceRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return listBudgetsForResourcePaginator(ListBudgetsForResourceRequest.builder()
                .applyMutation(listBudgetsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the constraints for the specified portfolio and product.
     * </p>
     *
     * @param listConstraintsForPortfolioRequest
     * @return Result of the ListConstraintsForPortfolio operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListConstraintsForPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListConstraintsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConstraintsForPortfolioResponse listConstraintsForPortfolio(
            ListConstraintsForPortfolioRequest listConstraintsForPortfolioRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the constraints for the specified portfolio and product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConstraintsForPortfolioRequest.Builder}
     * avoiding the need to create one manually via {@link ListConstraintsForPortfolioRequest#builder()}
     * </p>
     *
     * @param listConstraintsForPortfolioRequest
     *        A {@link Consumer} that will call methods on {@link ListConstraintsForPortfolioInput.Builder} to create a
     *        request.
     * @return Result of the ListConstraintsForPortfolio operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListConstraintsForPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListConstraintsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConstraintsForPortfolioResponse listConstraintsForPortfolio(
            Consumer<ListConstraintsForPortfolioRequest.Builder> listConstraintsForPortfolioRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return listConstraintsForPortfolio(ListConstraintsForPortfolioRequest.builder()
                .applyMutation(listConstraintsForPortfolioRequest).build());
    }

    /**
     * <p>
     * Lists the constraints for the specified portfolio and product.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConstraintsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListConstraintsForPortfolioIterable responses = client.listConstraintsForPortfolioPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListConstraintsForPortfolioIterable responses = client
     *             .listConstraintsForPortfolioPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListConstraintsForPortfolioIterable responses = client.listConstraintsForPortfolioPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConstraintsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConstraintsForPortfolioRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListConstraintsForPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListConstraintsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConstraintsForPortfolioIterable listConstraintsForPortfolioPaginator(
            ListConstraintsForPortfolioRequest listConstraintsForPortfolioRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return new ListConstraintsForPortfolioIterable(this, listConstraintsForPortfolioRequest);
    }

    /**
     * <p>
     * Lists the constraints for the specified portfolio and product.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConstraintsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListConstraintsForPortfolioIterable responses = client.listConstraintsForPortfolioPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListConstraintsForPortfolioIterable responses = client
     *             .listConstraintsForPortfolioPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListConstraintsForPortfolioIterable responses = client.listConstraintsForPortfolioPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConstraintsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConstraintsForPortfolioRequest.Builder}
     * avoiding the need to create one manually via {@link ListConstraintsForPortfolioRequest#builder()}
     * </p>
     *
     * @param listConstraintsForPortfolioRequest
     *        A {@link Consumer} that will call methods on {@link ListConstraintsForPortfolioInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListConstraintsForPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListConstraintsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConstraintsForPortfolioIterable listConstraintsForPortfolioPaginator(
            Consumer<ListConstraintsForPortfolioRequest.Builder> listConstraintsForPortfolioRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return listConstraintsForPortfolioPaginator(ListConstraintsForPortfolioRequest.builder()
                .applyMutation(listConstraintsForPortfolioRequest).build());
    }

    /**
     * <p>
     * Lists the paths to the specified product. A path describes how the user gets access to a specified product and is
     * necessary when provisioning a product. A path also determines the constraints that are put on a product. A path
     * is dependent on a specific product, porfolio, and principal.
     * </p>
     * <note>
     * <p>
     * When provisioning a product that's been added to a portfolio, you must grant your user, group, or role access to
     * the portfolio. For more information, see <a
     * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/catalogs_portfolios_users.html">Granting users
     * access</a> in the <i>Service Catalog User Guide</i>.
     * </p>
     * </note>
     *
     * @param listLaunchPathsRequest
     * @return Result of the ListLaunchPaths operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListLaunchPaths
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListLaunchPaths"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLaunchPathsResponse listLaunchPaths(ListLaunchPathsRequest listLaunchPathsRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the paths to the specified product. A path describes how the user gets access to a specified product and is
     * necessary when provisioning a product. A path also determines the constraints that are put on a product. A path
     * is dependent on a specific product, porfolio, and principal.
     * </p>
     * <note>
     * <p>
     * When provisioning a product that's been added to a portfolio, you must grant your user, group, or role access to
     * the portfolio. For more information, see <a
     * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/catalogs_portfolios_users.html">Granting users
     * access</a> in the <i>Service Catalog User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLaunchPathsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLaunchPathsRequest#builder()}
     * </p>
     *
     * @param listLaunchPathsRequest
     *        A {@link Consumer} that will call methods on {@link ListLaunchPathsInput.Builder} to create a request.
     * @return Result of the ListLaunchPaths operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListLaunchPaths
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListLaunchPaths"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLaunchPathsResponse listLaunchPaths(Consumer<ListLaunchPathsRequest.Builder> listLaunchPathsRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return listLaunchPaths(ListLaunchPathsRequest.builder().applyMutation(listLaunchPathsRequest).build());
    }

    /**
     * <p>
     * Lists the paths to the specified product. A path describes how the user gets access to a specified product and is
     * necessary when provisioning a product. A path also determines the constraints that are put on a product. A path
     * is dependent on a specific product, porfolio, and principal.
     * </p>
     * <note>
     * <p>
     * When provisioning a product that's been added to a portfolio, you must grant your user, group, or role access to
     * the portfolio. For more information, see <a
     * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/catalogs_portfolios_users.html">Granting users
     * access</a> in the <i>Service Catalog User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listLaunchPaths(software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListLaunchPathsIterable responses = client.listLaunchPathsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListLaunchPathsIterable responses = client
     *             .listLaunchPathsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListLaunchPathsIterable responses = client.listLaunchPathsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLaunchPaths(software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLaunchPathsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListLaunchPaths
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListLaunchPaths"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLaunchPathsIterable listLaunchPathsPaginator(ListLaunchPathsRequest listLaunchPathsRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return new ListLaunchPathsIterable(this, listLaunchPathsRequest);
    }

    /**
     * <p>
     * Lists the paths to the specified product. A path describes how the user gets access to a specified product and is
     * necessary when provisioning a product. A path also determines the constraints that are put on a product. A path
     * is dependent on a specific product, porfolio, and principal.
     * </p>
     * <note>
     * <p>
     * When provisioning a product that's been added to a portfolio, you must grant your user, group, or role access to
     * the portfolio. For more information, see <a
     * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/catalogs_portfolios_users.html">Granting users
     * access</a> in the <i>Service Catalog User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listLaunchPaths(software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListLaunchPathsIterable responses = client.listLaunchPathsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListLaunchPathsIterable responses = client
     *             .listLaunchPathsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListLaunchPathsIterable responses = client.listLaunchPathsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLaunchPaths(software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLaunchPathsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLaunchPathsRequest#builder()}
     * </p>
     *
     * @param listLaunchPathsRequest
     *        A {@link Consumer} that will call methods on {@link ListLaunchPathsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListLaunchPaths
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListLaunchPaths"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLaunchPathsIterable listLaunchPathsPaginator(Consumer<ListLaunchPathsRequest.Builder> listLaunchPathsRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return listLaunchPathsPaginator(ListLaunchPathsRequest.builder().applyMutation(listLaunchPathsRequest).build());
    }

    /**
     * <p>
     * Lists the organization nodes that have access to the specified portfolio. This API can only be called by the
     * management account in the organization or by a delegated admin.
     * </p>
     * <p>
     * If a delegated admin is de-registered, they can no longer perform this operation.
     * </p>
     *
     * @param listOrganizationPortfolioAccessRequest
     * @return Result of the ListOrganizationPortfolioAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListOrganizationPortfolioAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListOrganizationPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationPortfolioAccessResponse listOrganizationPortfolioAccess(
            ListOrganizationPortfolioAccessRequest listOrganizationPortfolioAccessRequest) throws ResourceNotFoundException,
            InvalidParametersException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the organization nodes that have access to the specified portfolio. This API can only be called by the
     * management account in the organization or by a delegated admin.
     * </p>
     * <p>
     * If a delegated admin is de-registered, they can no longer perform this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationPortfolioAccessRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationPortfolioAccessRequest#builder()}
     * </p>
     *
     * @param listOrganizationPortfolioAccessRequest
     *        A {@link Consumer} that will call methods on {@link ListOrganizationPortfolioAccessInput.Builder} to
     *        create a request.
     * @return Result of the ListOrganizationPortfolioAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListOrganizationPortfolioAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListOrganizationPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationPortfolioAccessResponse listOrganizationPortfolioAccess(
            Consumer<ListOrganizationPortfolioAccessRequest.Builder> listOrganizationPortfolioAccessRequest)
            throws ResourceNotFoundException, InvalidParametersException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return listOrganizationPortfolioAccess(ListOrganizationPortfolioAccessRequest.builder()
                .applyMutation(listOrganizationPortfolioAccessRequest).build());
    }

    /**
     * <p>
     * Lists the organization nodes that have access to the specified portfolio. This API can only be called by the
     * management account in the organization or by a delegated admin.
     * </p>
     * <p>
     * If a delegated admin is de-registered, they can no longer perform this operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizationPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListOrganizationPortfolioAccessIterable responses = client.listOrganizationPortfolioAccessPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListOrganizationPortfolioAccessIterable responses = client
     *             .listOrganizationPortfolioAccessPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListOrganizationPortfolioAccessIterable responses = client.listOrganizationPortfolioAccessPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationPortfolioAccessRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListOrganizationPortfolioAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListOrganizationPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationPortfolioAccessIterable listOrganizationPortfolioAccessPaginator(
            ListOrganizationPortfolioAccessRequest listOrganizationPortfolioAccessRequest) throws ResourceNotFoundException,
            InvalidParametersException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return new ListOrganizationPortfolioAccessIterable(this, listOrganizationPortfolioAccessRequest);
    }

    /**
     * <p>
     * Lists the organization nodes that have access to the specified portfolio. This API can only be called by the
     * management account in the organization or by a delegated admin.
     * </p>
     * <p>
     * If a delegated admin is de-registered, they can no longer perform this operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizationPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListOrganizationPortfolioAccessIterable responses = client.listOrganizationPortfolioAccessPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListOrganizationPortfolioAccessIterable responses = client
     *             .listOrganizationPortfolioAccessPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListOrganizationPortfolioAccessIterable responses = client.listOrganizationPortfolioAccessPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationPortfolioAccessRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationPortfolioAccessRequest#builder()}
     * </p>
     *
     * @param listOrganizationPortfolioAccessRequest
     *        A {@link Consumer} that will call methods on {@link ListOrganizationPortfolioAccessInput.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListOrganizationPortfolioAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListOrganizationPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationPortfolioAccessIterable listOrganizationPortfolioAccessPaginator(
            Consumer<ListOrganizationPortfolioAccessRequest.Builder> listOrganizationPortfolioAccessRequest)
            throws ResourceNotFoundException, InvalidParametersException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return listOrganizationPortfolioAccessPaginator(ListOrganizationPortfolioAccessRequest.builder()
                .applyMutation(listOrganizationPortfolioAccessRequest).build());
    }

    /**
     * <p>
     * Lists the account IDs that have access to the specified portfolio.
     * </p>
     * <p>
     * A delegated admin can list the accounts that have access to the shared portfolio. Note that if a delegated admin
     * is de-registered, they can no longer perform this operation.
     * </p>
     *
     * @param listPortfolioAccessRequest
     * @return Result of the ListPortfolioAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPortfolioAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPortfolioAccessResponse listPortfolioAccess(ListPortfolioAccessRequest listPortfolioAccessRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the account IDs that have access to the specified portfolio.
     * </p>
     * <p>
     * A delegated admin can list the accounts that have access to the shared portfolio. Note that if a delegated admin
     * is de-registered, they can no longer perform this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPortfolioAccessRequest.Builder} avoiding the
     * need to create one manually via {@link ListPortfolioAccessRequest#builder()}
     * </p>
     *
     * @param listPortfolioAccessRequest
     *        A {@link Consumer} that will call methods on {@link ListPortfolioAccessInput.Builder} to create a request.
     * @return Result of the ListPortfolioAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPortfolioAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPortfolioAccessResponse listPortfolioAccess(
            Consumer<ListPortfolioAccessRequest.Builder> listPortfolioAccessRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return listPortfolioAccess(ListPortfolioAccessRequest.builder().applyMutation(listPortfolioAccessRequest).build());
    }

    /**
     * <p>
     * Lists the account IDs that have access to the specified portfolio.
     * </p>
     * <p>
     * A delegated admin can list the accounts that have access to the shared portfolio. Note that if a delegated admin
     * is de-registered, they can no longer perform this operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfolioAccessIterable responses = client.listPortfolioAccessPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListPortfolioAccessIterable responses = client
     *             .listPortfolioAccessPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfolioAccessIterable responses = client.listPortfolioAccessPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPortfolioAccessRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPortfolioAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPortfolioAccessIterable listPortfolioAccessPaginator(ListPortfolioAccessRequest listPortfolioAccessRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return new ListPortfolioAccessIterable(this, listPortfolioAccessRequest);
    }

    /**
     * <p>
     * Lists the account IDs that have access to the specified portfolio.
     * </p>
     * <p>
     * A delegated admin can list the accounts that have access to the shared portfolio. Note that if a delegated admin
     * is de-registered, they can no longer perform this operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfolioAccessIterable responses = client.listPortfolioAccessPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListPortfolioAccessIterable responses = client
     *             .listPortfolioAccessPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfolioAccessIterable responses = client.listPortfolioAccessPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPortfolioAccessRequest.Builder} avoiding the
     * need to create one manually via {@link ListPortfolioAccessRequest#builder()}
     * </p>
     *
     * @param listPortfolioAccessRequest
     *        A {@link Consumer} that will call methods on {@link ListPortfolioAccessInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPortfolioAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPortfolioAccessIterable listPortfolioAccessPaginator(
            Consumer<ListPortfolioAccessRequest.Builder> listPortfolioAccessRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return listPortfolioAccessPaginator(ListPortfolioAccessRequest.builder().applyMutation(listPortfolioAccessRequest)
                .build());
    }

    /**
     * <p>
     * Lists all portfolios in the catalog.
     * </p>
     *
     * @param listPortfoliosRequest
     * @return Result of the ListPortfolios operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPortfolios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolios" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPortfoliosResponse listPortfolios(ListPortfoliosRequest listPortfoliosRequest) throws InvalidParametersException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all portfolios in the catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPortfoliosRequest.Builder} avoiding the need to
     * create one manually via {@link ListPortfoliosRequest#builder()}
     * </p>
     *
     * @param listPortfoliosRequest
     *        A {@link Consumer} that will call methods on {@link ListPortfoliosInput.Builder} to create a request.
     * @return Result of the ListPortfolios operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPortfolios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolios" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPortfoliosResponse listPortfolios(Consumer<ListPortfoliosRequest.Builder> listPortfoliosRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return listPortfolios(ListPortfoliosRequest.builder().applyMutation(listPortfoliosRequest).build());
    }

    /**
     * <p>
     * Lists all portfolios in the catalog.
     * </p>
     *
     * @return Result of the ListPortfolios operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPortfolios
     * @see #listPortfolios(ListPortfoliosRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolios" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPortfoliosResponse listPortfolios() throws InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return listPortfolios(ListPortfoliosRequest.builder().build());
    }

    /**
     * <p>
     * Lists all portfolios in the catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPortfolios(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosIterable responses = client.listPortfoliosPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosIterable responses = client
     *             .listPortfoliosPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosIterable responses = client.listPortfoliosPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortfolios(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPortfolios
     * @see #listPortfoliosPaginator(ListPortfoliosRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolios" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPortfoliosIterable listPortfoliosPaginator() throws InvalidParametersException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return listPortfoliosPaginator(ListPortfoliosRequest.builder().build());
    }

    /**
     * <p>
     * Lists all portfolios in the catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPortfolios(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosIterable responses = client.listPortfoliosPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosIterable responses = client
     *             .listPortfoliosPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosIterable responses = client.listPortfoliosPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortfolios(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPortfoliosRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPortfolios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolios" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPortfoliosIterable listPortfoliosPaginator(ListPortfoliosRequest listPortfoliosRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return new ListPortfoliosIterable(this, listPortfoliosRequest);
    }

    /**
     * <p>
     * Lists all portfolios in the catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPortfolios(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosIterable responses = client.listPortfoliosPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosIterable responses = client
     *             .listPortfoliosPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosIterable responses = client.listPortfoliosPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortfolios(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPortfoliosRequest.Builder} avoiding the need to
     * create one manually via {@link ListPortfoliosRequest#builder()}
     * </p>
     *
     * @param listPortfoliosRequest
     *        A {@link Consumer} that will call methods on {@link ListPortfoliosInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPortfolios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolios" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPortfoliosIterable listPortfoliosPaginator(Consumer<ListPortfoliosRequest.Builder> listPortfoliosRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return listPortfoliosPaginator(ListPortfoliosRequest.builder().applyMutation(listPortfoliosRequest).build());
    }

    /**
     * <p>
     * Lists all portfolios that the specified product is associated with.
     * </p>
     *
     * @param listPortfoliosForProductRequest
     * @return Result of the ListPortfoliosForProduct operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPortfoliosForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPortfoliosForProductResponse listPortfoliosForProduct(
            ListPortfoliosForProductRequest listPortfoliosForProductRequest) throws InvalidParametersException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all portfolios that the specified product is associated with.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPortfoliosForProductRequest.Builder} avoiding
     * the need to create one manually via {@link ListPortfoliosForProductRequest#builder()}
     * </p>
     *
     * @param listPortfoliosForProductRequest
     *        A {@link Consumer} that will call methods on {@link ListPortfoliosForProductInput.Builder} to create a
     *        request.
     * @return Result of the ListPortfoliosForProduct operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPortfoliosForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPortfoliosForProductResponse listPortfoliosForProduct(
            Consumer<ListPortfoliosForProductRequest.Builder> listPortfoliosForProductRequest) throws InvalidParametersException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return listPortfoliosForProduct(ListPortfoliosForProductRequest.builder().applyMutation(listPortfoliosForProductRequest)
                .build());
    }

    /**
     * <p>
     * Lists all portfolios that the specified product is associated with.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPortfoliosForProduct(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosForProductIterable responses = client.listPortfoliosForProductPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosForProductIterable responses = client
     *             .listPortfoliosForProductPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosForProductIterable responses = client.listPortfoliosForProductPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortfoliosForProduct(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPortfoliosForProductRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPortfoliosForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPortfoliosForProductIterable listPortfoliosForProductPaginator(
            ListPortfoliosForProductRequest listPortfoliosForProductRequest) throws InvalidParametersException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return new ListPortfoliosForProductIterable(this, listPortfoliosForProductRequest);
    }

    /**
     * <p>
     * Lists all portfolios that the specified product is associated with.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPortfoliosForProduct(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosForProductIterable responses = client.listPortfoliosForProductPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosForProductIterable responses = client
     *             .listPortfoliosForProductPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosForProductIterable responses = client.listPortfoliosForProductPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortfoliosForProduct(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPortfoliosForProductRequest.Builder} avoiding
     * the need to create one manually via {@link ListPortfoliosForProductRequest#builder()}
     * </p>
     *
     * @param listPortfoliosForProductRequest
     *        A {@link Consumer} that will call methods on {@link ListPortfoliosForProductInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPortfoliosForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPortfoliosForProductIterable listPortfoliosForProductPaginator(
            Consumer<ListPortfoliosForProductRequest.Builder> listPortfoliosForProductRequest) throws InvalidParametersException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return listPortfoliosForProductPaginator(ListPortfoliosForProductRequest.builder()
                .applyMutation(listPortfoliosForProductRequest).build());
    }

    /**
     * <p>
     * Lists all <code>PrincipalARN</code>s and corresponding <code>PrincipalType</code>s associated with the specified
     * portfolio.
     * </p>
     *
     * @param listPrincipalsForPortfolioRequest
     * @return Result of the ListPrincipalsForPortfolio operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPrincipalsForPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPrincipalsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPrincipalsForPortfolioResponse listPrincipalsForPortfolio(
            ListPrincipalsForPortfolioRequest listPrincipalsForPortfolioRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all <code>PrincipalARN</code>s and corresponding <code>PrincipalType</code>s associated with the specified
     * portfolio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPrincipalsForPortfolioRequest.Builder} avoiding
     * the need to create one manually via {@link ListPrincipalsForPortfolioRequest#builder()}
     * </p>
     *
     * @param listPrincipalsForPortfolioRequest
     *        A {@link Consumer} that will call methods on {@link ListPrincipalsForPortfolioInput.Builder} to create a
     *        request.
     * @return Result of the ListPrincipalsForPortfolio operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPrincipalsForPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPrincipalsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPrincipalsForPortfolioResponse listPrincipalsForPortfolio(
            Consumer<ListPrincipalsForPortfolioRequest.Builder> listPrincipalsForPortfolioRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return listPrincipalsForPortfolio(ListPrincipalsForPortfolioRequest.builder()
                .applyMutation(listPrincipalsForPortfolioRequest).build());
    }

    /**
     * <p>
     * Lists all <code>PrincipalARN</code>s and corresponding <code>PrincipalType</code>s associated with the specified
     * portfolio.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPrincipalsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPrincipalsForPortfolioIterable responses = client.listPrincipalsForPortfolioPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListPrincipalsForPortfolioIterable responses = client
     *             .listPrincipalsForPortfolioPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPrincipalsForPortfolioIterable responses = client.listPrincipalsForPortfolioPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrincipalsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPrincipalsForPortfolioRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPrincipalsForPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPrincipalsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPrincipalsForPortfolioIterable listPrincipalsForPortfolioPaginator(
            ListPrincipalsForPortfolioRequest listPrincipalsForPortfolioRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return new ListPrincipalsForPortfolioIterable(this, listPrincipalsForPortfolioRequest);
    }

    /**
     * <p>
     * Lists all <code>PrincipalARN</code>s and corresponding <code>PrincipalType</code>s associated with the specified
     * portfolio.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPrincipalsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPrincipalsForPortfolioIterable responses = client.listPrincipalsForPortfolioPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListPrincipalsForPortfolioIterable responses = client
     *             .listPrincipalsForPortfolioPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPrincipalsForPortfolioIterable responses = client.listPrincipalsForPortfolioPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrincipalsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPrincipalsForPortfolioRequest.Builder} avoiding
     * the need to create one manually via {@link ListPrincipalsForPortfolioRequest#builder()}
     * </p>
     *
     * @param listPrincipalsForPortfolioRequest
     *        A {@link Consumer} that will call methods on {@link ListPrincipalsForPortfolioInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPrincipalsForPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPrincipalsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPrincipalsForPortfolioIterable listPrincipalsForPortfolioPaginator(
            Consumer<ListPrincipalsForPortfolioRequest.Builder> listPrincipalsForPortfolioRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return listPrincipalsForPortfolioPaginator(ListPrincipalsForPortfolioRequest.builder()
                .applyMutation(listPrincipalsForPortfolioRequest).build());
    }

    /**
     * <p>
     * Lists the plans for the specified provisioned product or all plans to which the user has access.
     * </p>
     *
     * @param listProvisionedProductPlansRequest
     * @return Result of the ListProvisionedProductPlans operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListProvisionedProductPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisionedProductPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisionedProductPlansResponse listProvisionedProductPlans(
            ListProvisionedProductPlansRequest listProvisionedProductPlansRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the plans for the specified provisioned product or all plans to which the user has access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProvisionedProductPlansRequest.Builder}
     * avoiding the need to create one manually via {@link ListProvisionedProductPlansRequest#builder()}
     * </p>
     *
     * @param listProvisionedProductPlansRequest
     *        A {@link Consumer} that will call methods on {@link ListProvisionedProductPlansInput.Builder} to create a
     *        request.
     * @return Result of the ListProvisionedProductPlans operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListProvisionedProductPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisionedProductPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisionedProductPlansResponse listProvisionedProductPlans(
            Consumer<ListProvisionedProductPlansRequest.Builder> listProvisionedProductPlansRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return listProvisionedProductPlans(ListProvisionedProductPlansRequest.builder()
                .applyMutation(listProvisionedProductPlansRequest).build());
    }

    /**
     * <p>
     * Lists the plans for the specified provisioned product or all plans to which the user has access.
     * </p>
     *
     * @return Result of the ListProvisionedProductPlans operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListProvisionedProductPlans
     * @see #listProvisionedProductPlans(ListProvisionedProductPlansRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisionedProductPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisionedProductPlansResponse listProvisionedProductPlans() throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return listProvisionedProductPlans(ListProvisionedProductPlansRequest.builder().build());
    }

    /**
     * <p>
     * Lists all provisioning artifacts (also known as versions) for the specified product.
     * </p>
     *
     * @param listProvisioningArtifactsRequest
     * @return Result of the ListProvisioningArtifacts operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListProvisioningArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifacts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisioningArtifactsResponse listProvisioningArtifacts(
            ListProvisioningArtifactsRequest listProvisioningArtifactsRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all provisioning artifacts (also known as versions) for the specified product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProvisioningArtifactsRequest.Builder} avoiding
     * the need to create one manually via {@link ListProvisioningArtifactsRequest#builder()}
     * </p>
     *
     * @param listProvisioningArtifactsRequest
     *        A {@link Consumer} that will call methods on {@link ListProvisioningArtifactsInput.Builder} to create a
     *        request.
     * @return Result of the ListProvisioningArtifacts operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListProvisioningArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifacts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisioningArtifactsResponse listProvisioningArtifacts(
            Consumer<ListProvisioningArtifactsRequest.Builder> listProvisioningArtifactsRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return listProvisioningArtifacts(ListProvisioningArtifactsRequest.builder()
                .applyMutation(listProvisioningArtifactsRequest).build());
    }

    /**
     * <p>
     * Lists all provisioning artifacts (also known as versions) for the specified self-service action.
     * </p>
     *
     * @param listProvisioningArtifactsForServiceActionRequest
     * @return Result of the ListProvisioningArtifactsForServiceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListProvisioningArtifactsForServiceAction
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifactsForServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisioningArtifactsForServiceActionResponse listProvisioningArtifactsForServiceAction(
            ListProvisioningArtifactsForServiceActionRequest listProvisioningArtifactsForServiceActionRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all provisioning artifacts (also known as versions) for the specified self-service action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListProvisioningArtifactsForServiceActionRequest.Builder} avoiding the need to create one manually via
     * {@link ListProvisioningArtifactsForServiceActionRequest#builder()}
     * </p>
     *
     * @param listProvisioningArtifactsForServiceActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListProvisioningArtifactsForServiceActionInput.Builder} to create a request.
     * @return Result of the ListProvisioningArtifactsForServiceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListProvisioningArtifactsForServiceAction
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifactsForServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisioningArtifactsForServiceActionResponse listProvisioningArtifactsForServiceAction(
            Consumer<ListProvisioningArtifactsForServiceActionRequest.Builder> listProvisioningArtifactsForServiceActionRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return listProvisioningArtifactsForServiceAction(ListProvisioningArtifactsForServiceActionRequest.builder()
                .applyMutation(listProvisioningArtifactsForServiceActionRequest).build());
    }

    /**
     * <p>
     * Lists all provisioning artifacts (also known as versions) for the specified self-service action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProvisioningArtifactsForServiceAction(software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListProvisioningArtifactsForServiceActionIterable responses = client.listProvisioningArtifactsForServiceActionPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListProvisioningArtifactsForServiceActionIterable responses = client
     *             .listProvisioningArtifactsForServiceActionPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListProvisioningArtifactsForServiceActionIterable responses = client.listProvisioningArtifactsForServiceActionPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProvisioningArtifactsForServiceAction(software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProvisioningArtifactsForServiceActionRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListProvisioningArtifactsForServiceAction
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifactsForServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisioningArtifactsForServiceActionIterable listProvisioningArtifactsForServiceActionPaginator(
            ListProvisioningArtifactsForServiceActionRequest listProvisioningArtifactsForServiceActionRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return new ListProvisioningArtifactsForServiceActionIterable(this, listProvisioningArtifactsForServiceActionRequest);
    }

    /**
     * <p>
     * Lists all provisioning artifacts (also known as versions) for the specified self-service action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProvisioningArtifactsForServiceAction(software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListProvisioningArtifactsForServiceActionIterable responses = client.listProvisioningArtifactsForServiceActionPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListProvisioningArtifactsForServiceActionIterable responses = client
     *             .listProvisioningArtifactsForServiceActionPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListProvisioningArtifactsForServiceActionIterable responses = client.listProvisioningArtifactsForServiceActionPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProvisioningArtifactsForServiceAction(software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListProvisioningArtifactsForServiceActionRequest.Builder} avoiding the need to create one manually via
     * {@link ListProvisioningArtifactsForServiceActionRequest#builder()}
     * </p>
     *
     * @param listProvisioningArtifactsForServiceActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListProvisioningArtifactsForServiceActionInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListProvisioningArtifactsForServiceAction
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifactsForServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisioningArtifactsForServiceActionIterable listProvisioningArtifactsForServiceActionPaginator(
            Consumer<ListProvisioningArtifactsForServiceActionRequest.Builder> listProvisioningArtifactsForServiceActionRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return listProvisioningArtifactsForServiceActionPaginator(ListProvisioningArtifactsForServiceActionRequest.builder()
                .applyMutation(listProvisioningArtifactsForServiceActionRequest).build());
    }

    /**
     * <p>
     * Lists the specified requests or all performed requests.
     * </p>
     *
     * @param listRecordHistoryRequest
     * @return Result of the ListRecordHistory operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListRecordHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListRecordHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecordHistoryResponse listRecordHistory(ListRecordHistoryRequest listRecordHistoryRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the specified requests or all performed requests.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecordHistoryRequest.Builder} avoiding the need
     * to create one manually via {@link ListRecordHistoryRequest#builder()}
     * </p>
     *
     * @param listRecordHistoryRequest
     *        A {@link Consumer} that will call methods on {@link ListRecordHistoryInput.Builder} to create a request.
     * @return Result of the ListRecordHistory operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListRecordHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListRecordHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecordHistoryResponse listRecordHistory(Consumer<ListRecordHistoryRequest.Builder> listRecordHistoryRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return listRecordHistory(ListRecordHistoryRequest.builder().applyMutation(listRecordHistoryRequest).build());
    }

    /**
     * <p>
     * Lists the specified requests or all performed requests.
     * </p>
     *
     * @return Result of the ListRecordHistory operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListRecordHistory
     * @see #listRecordHistory(ListRecordHistoryRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListRecordHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecordHistoryResponse listRecordHistory() throws InvalidParametersException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return listRecordHistory(ListRecordHistoryRequest.builder().build());
    }

    /**
     * <p>
     * Lists the resources associated with the specified TagOption.
     * </p>
     *
     * @param listResourcesForTagOptionRequest
     * @return Result of the ListResourcesForTagOption operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListResourcesForTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListResourcesForTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourcesForTagOptionResponse listResourcesForTagOption(
            ListResourcesForTagOptionRequest listResourcesForTagOptionRequest) throws TagOptionNotMigratedException,
            ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resources associated with the specified TagOption.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesForTagOptionRequest.Builder} avoiding
     * the need to create one manually via {@link ListResourcesForTagOptionRequest#builder()}
     * </p>
     *
     * @param listResourcesForTagOptionRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesForTagOptionInput.Builder} to create a
     *        request.
     * @return Result of the ListResourcesForTagOption operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListResourcesForTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListResourcesForTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourcesForTagOptionResponse listResourcesForTagOption(
            Consumer<ListResourcesForTagOptionRequest.Builder> listResourcesForTagOptionRequest)
            throws TagOptionNotMigratedException, ResourceNotFoundException, InvalidParametersException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return listResourcesForTagOption(ListResourcesForTagOptionRequest.builder()
                .applyMutation(listResourcesForTagOptionRequest).build());
    }

    /**
     * <p>
     * Lists the resources associated with the specified TagOption.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourcesForTagOption(software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListResourcesForTagOptionIterable responses = client.listResourcesForTagOptionPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListResourcesForTagOptionIterable responses = client
     *             .listResourcesForTagOptionPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListResourcesForTagOptionIterable responses = client.listResourcesForTagOptionPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourcesForTagOption(software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourcesForTagOptionRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListResourcesForTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListResourcesForTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourcesForTagOptionIterable listResourcesForTagOptionPaginator(
            ListResourcesForTagOptionRequest listResourcesForTagOptionRequest) throws TagOptionNotMigratedException,
            ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return new ListResourcesForTagOptionIterable(this, listResourcesForTagOptionRequest);
    }

    /**
     * <p>
     * Lists the resources associated with the specified TagOption.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourcesForTagOption(software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListResourcesForTagOptionIterable responses = client.listResourcesForTagOptionPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListResourcesForTagOptionIterable responses = client
     *             .listResourcesForTagOptionPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListResourcesForTagOptionIterable responses = client.listResourcesForTagOptionPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourcesForTagOption(software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesForTagOptionRequest.Builder} avoiding
     * the need to create one manually via {@link ListResourcesForTagOptionRequest#builder()}
     * </p>
     *
     * @param listResourcesForTagOptionRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesForTagOptionInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListResourcesForTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListResourcesForTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourcesForTagOptionIterable listResourcesForTagOptionPaginator(
            Consumer<ListResourcesForTagOptionRequest.Builder> listResourcesForTagOptionRequest)
            throws TagOptionNotMigratedException, ResourceNotFoundException, InvalidParametersException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return listResourcesForTagOptionPaginator(ListResourcesForTagOptionRequest.builder()
                .applyMutation(listResourcesForTagOptionRequest).build());
    }

    /**
     * <p>
     * Lists all self-service actions.
     * </p>
     *
     * @param listServiceActionsRequest
     * @return Result of the ListServiceActions operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListServiceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceActionsResponse listServiceActions(ListServiceActionsRequest listServiceActionsRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all self-service actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceActionsRequest#builder()}
     * </p>
     *
     * @param listServiceActionsRequest
     *        A {@link Consumer} that will call methods on {@link ListServiceActionsInput.Builder} to create a request.
     * @return Result of the ListServiceActions operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListServiceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceActionsResponse listServiceActions(Consumer<ListServiceActionsRequest.Builder> listServiceActionsRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return listServiceActions(ListServiceActionsRequest.builder().applyMutation(listServiceActionsRequest).build());
    }

    /**
     * <p>
     * Lists all self-service actions.
     * </p>
     *
     * @return Result of the ListServiceActions operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListServiceActions
     * @see #listServiceActions(ListServiceActionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceActionsResponse listServiceActions() throws InvalidParametersException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return listServiceActions(ListServiceActionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all self-service actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceActions(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsIterable responses = client.listServiceActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsIterable responses = client
     *             .listServiceActionsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsIterable responses = client.listServiceActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceActions(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListServiceActions
     * @see #listServiceActionsPaginator(ListServiceActionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceActionsIterable listServiceActionsPaginator() throws InvalidParametersException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return listServiceActionsPaginator(ListServiceActionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all self-service actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceActions(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsIterable responses = client.listServiceActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsIterable responses = client
     *             .listServiceActionsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsIterable responses = client.listServiceActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceActions(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceActionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListServiceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceActionsIterable listServiceActionsPaginator(ListServiceActionsRequest listServiceActionsRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return new ListServiceActionsIterable(this, listServiceActionsRequest);
    }

    /**
     * <p>
     * Lists all self-service actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceActions(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsIterable responses = client.listServiceActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsIterable responses = client
     *             .listServiceActionsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsIterable responses = client.listServiceActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceActions(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceActionsRequest#builder()}
     * </p>
     *
     * @param listServiceActionsRequest
     *        A {@link Consumer} that will call methods on {@link ListServiceActionsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListServiceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceActionsIterable listServiceActionsPaginator(
            Consumer<ListServiceActionsRequest.Builder> listServiceActionsRequest) throws InvalidParametersException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        return listServiceActionsPaginator(ListServiceActionsRequest.builder().applyMutation(listServiceActionsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning
     * Artifact ID.
     * </p>
     *
     * @param listServiceActionsForProvisioningArtifactRequest
     * @return Result of the ListServiceActionsForProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListServiceActionsForProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActionsForProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceActionsForProvisioningArtifactResponse listServiceActionsForProvisioningArtifact(
            ListServiceActionsForProvisioningArtifactRequest listServiceActionsForProvisioningArtifactRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning
     * Artifact ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceActionsForProvisioningArtifactRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceActionsForProvisioningArtifactRequest#builder()}
     * </p>
     *
     * @param listServiceActionsForProvisioningArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListServiceActionsForProvisioningArtifactInput.Builder} to create a request.
     * @return Result of the ListServiceActionsForProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListServiceActionsForProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActionsForProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceActionsForProvisioningArtifactResponse listServiceActionsForProvisioningArtifact(
            Consumer<ListServiceActionsForProvisioningArtifactRequest.Builder> listServiceActionsForProvisioningArtifactRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return listServiceActionsForProvisioningArtifact(ListServiceActionsForProvisioningArtifactRequest.builder()
                .applyMutation(listServiceActionsForProvisioningArtifactRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning
     * Artifact ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceActionsForProvisioningArtifact(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsForProvisioningArtifactIterable responses = client.listServiceActionsForProvisioningArtifactPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsForProvisioningArtifactIterable responses = client
     *             .listServiceActionsForProvisioningArtifactPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsForProvisioningArtifactIterable responses = client.listServiceActionsForProvisioningArtifactPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceActionsForProvisioningArtifact(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceActionsForProvisioningArtifactRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListServiceActionsForProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActionsForProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceActionsForProvisioningArtifactIterable listServiceActionsForProvisioningArtifactPaginator(
            ListServiceActionsForProvisioningArtifactRequest listServiceActionsForProvisioningArtifactRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return new ListServiceActionsForProvisioningArtifactIterable(this, listServiceActionsForProvisioningArtifactRequest);
    }

    /**
     * <p>
     * Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning
     * Artifact ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceActionsForProvisioningArtifact(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsForProvisioningArtifactIterable responses = client.listServiceActionsForProvisioningArtifactPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsForProvisioningArtifactIterable responses = client
     *             .listServiceActionsForProvisioningArtifactPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsForProvisioningArtifactIterable responses = client.listServiceActionsForProvisioningArtifactPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceActionsForProvisioningArtifact(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceActionsForProvisioningArtifactRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceActionsForProvisioningArtifactRequest#builder()}
     * </p>
     *
     * @param listServiceActionsForProvisioningArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListServiceActionsForProvisioningArtifactInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListServiceActionsForProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActionsForProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceActionsForProvisioningArtifactIterable listServiceActionsForProvisioningArtifactPaginator(
            Consumer<ListServiceActionsForProvisioningArtifactRequest.Builder> listServiceActionsForProvisioningArtifactRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return listServiceActionsForProvisioningArtifactPaginator(ListServiceActionsForProvisioningArtifactRequest.builder()
                .applyMutation(listServiceActionsForProvisioningArtifactRequest).build());
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified
     * <code>CFN_STACKSET</code> type provisioned product. You can filter for stack instances that are associated with a
     * specific Amazon Web Services account name or Region.
     * </p>
     *
     * @param listStackInstancesForProvisionedProductRequest
     * @return Result of the ListStackInstancesForProvisionedProduct operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListStackInstancesForProvisionedProduct
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListStackInstancesForProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackInstancesForProvisionedProductResponse listStackInstancesForProvisionedProduct(
            ListStackInstancesForProvisionedProductRequest listStackInstancesForProvisionedProductRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified
     * <code>CFN_STACKSET</code> type provisioned product. You can filter for stack instances that are associated with a
     * specific Amazon Web Services account name or Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListStackInstancesForProvisionedProductRequest.Builder} avoiding the need to create one manually via
     * {@link ListStackInstancesForProvisionedProductRequest#builder()}
     * </p>
     *
     * @param listStackInstancesForProvisionedProductRequest
     *        A {@link Consumer} that will call methods on {@link ListStackInstancesForProvisionedProductInput.Builder}
     *        to create a request.
     * @return Result of the ListStackInstancesForProvisionedProduct operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListStackInstancesForProvisionedProduct
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListStackInstancesForProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackInstancesForProvisionedProductResponse listStackInstancesForProvisionedProduct(
            Consumer<ListStackInstancesForProvisionedProductRequest.Builder> listStackInstancesForProvisionedProductRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return listStackInstancesForProvisionedProduct(ListStackInstancesForProvisionedProductRequest.builder()
                .applyMutation(listStackInstancesForProvisionedProductRequest).build());
    }

    /**
     * <p>
     * Lists the specified TagOptions or all TagOptions.
     * </p>
     *
     * @param listTagOptionsRequest
     * @return Result of the ListTagOptions operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListTagOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListTagOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagOptionsResponse listTagOptions(ListTagOptionsRequest listTagOptionsRequest)
            throws TagOptionNotMigratedException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the specified TagOptions or all TagOptions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagOptionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagOptionsRequest#builder()}
     * </p>
     *
     * @param listTagOptionsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagOptionsInput.Builder} to create a request.
     * @return Result of the ListTagOptions operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListTagOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListTagOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagOptionsResponse listTagOptions(Consumer<ListTagOptionsRequest.Builder> listTagOptionsRequest)
            throws TagOptionNotMigratedException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return listTagOptions(ListTagOptionsRequest.builder().applyMutation(listTagOptionsRequest).build());
    }

    /**
     * <p>
     * Lists the specified TagOptions or all TagOptions.
     * </p>
     *
     * @return Result of the ListTagOptions operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListTagOptions
     * @see #listTagOptions(ListTagOptionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListTagOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagOptionsResponse listTagOptions() throws TagOptionNotMigratedException, InvalidParametersException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        return listTagOptions(ListTagOptionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the specified TagOptions or all TagOptions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagOptions(software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsIterable responses = client.listTagOptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsIterable responses = client
     *             .listTagOptionsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsIterable responses = client.listTagOptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagOptions(software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListTagOptions
     * @see #listTagOptionsPaginator(ListTagOptionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListTagOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagOptionsIterable listTagOptionsPaginator() throws TagOptionNotMigratedException, InvalidParametersException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        return listTagOptionsPaginator(ListTagOptionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the specified TagOptions or all TagOptions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagOptions(software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsIterable responses = client.listTagOptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsIterable responses = client
     *             .listTagOptionsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsIterable responses = client.listTagOptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagOptions(software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagOptionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListTagOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListTagOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagOptionsIterable listTagOptionsPaginator(ListTagOptionsRequest listTagOptionsRequest)
            throws TagOptionNotMigratedException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return new ListTagOptionsIterable(this, listTagOptionsRequest);
    }

    /**
     * <p>
     * Lists the specified TagOptions or all TagOptions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagOptions(software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsIterable responses = client.listTagOptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsIterable responses = client
     *             .listTagOptionsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsIterable responses = client.listTagOptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagOptions(software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagOptionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagOptionsRequest#builder()}
     * </p>
     *
     * @param listTagOptionsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagOptionsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListTagOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListTagOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagOptionsIterable listTagOptionsPaginator(Consumer<ListTagOptionsRequest.Builder> listTagOptionsRequest)
            throws TagOptionNotMigratedException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return listTagOptionsPaginator(ListTagOptionsRequest.builder().applyMutation(listTagOptionsRequest).build());
    }

    /**
     * <p>
     * Notifies the result of the provisioning engine execution.
     * </p>
     *
     * @param notifyProvisionProductEngineWorkflowResultRequest
     * @return Result of the NotifyProvisionProductEngineWorkflowResult operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.NotifyProvisionProductEngineWorkflowResult
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/NotifyProvisionProductEngineWorkflowResult"
     *      target="_top">AWS API Documentation</a>
     */
    default NotifyProvisionProductEngineWorkflowResultResponse notifyProvisionProductEngineWorkflowResult(
            NotifyProvisionProductEngineWorkflowResultRequest notifyProvisionProductEngineWorkflowResultRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Notifies the result of the provisioning engine execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link NotifyProvisionProductEngineWorkflowResultRequest.Builder} avoiding the need to create one manually via
     * {@link NotifyProvisionProductEngineWorkflowResultRequest#builder()}
     * </p>
     *
     * @param notifyProvisionProductEngineWorkflowResultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link NotifyProvisionProductEngineWorkflowResultInput.Builder} to create a request.
     * @return Result of the NotifyProvisionProductEngineWorkflowResult operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.NotifyProvisionProductEngineWorkflowResult
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/NotifyProvisionProductEngineWorkflowResult"
     *      target="_top">AWS API Documentation</a>
     */
    default NotifyProvisionProductEngineWorkflowResultResponse notifyProvisionProductEngineWorkflowResult(
            Consumer<NotifyProvisionProductEngineWorkflowResultRequest.Builder> notifyProvisionProductEngineWorkflowResultRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return notifyProvisionProductEngineWorkflowResult(NotifyProvisionProductEngineWorkflowResultRequest.builder()
                .applyMutation(notifyProvisionProductEngineWorkflowResultRequest).build());
    }

    /**
     * <p>
     * Notifies the result of the terminate engine execution.
     * </p>
     *
     * @param notifyTerminateProvisionedProductEngineWorkflowResultRequest
     * @return Result of the NotifyTerminateProvisionedProductEngineWorkflowResult operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.NotifyTerminateProvisionedProductEngineWorkflowResult
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/NotifyTerminateProvisionedProductEngineWorkflowResult"
     *      target="_top">AWS API Documentation</a>
     */
    default NotifyTerminateProvisionedProductEngineWorkflowResultResponse notifyTerminateProvisionedProductEngineWorkflowResult(
            NotifyTerminateProvisionedProductEngineWorkflowResultRequest notifyTerminateProvisionedProductEngineWorkflowResultRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Notifies the result of the terminate engine execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link NotifyTerminateProvisionedProductEngineWorkflowResultRequest.Builder} avoiding the need to create one
     * manually via {@link NotifyTerminateProvisionedProductEngineWorkflowResultRequest#builder()}
     * </p>
     *
     * @param notifyTerminateProvisionedProductEngineWorkflowResultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link NotifyTerminateProvisionedProductEngineWorkflowResultInput.Builder} to create a request.
     * @return Result of the NotifyTerminateProvisionedProductEngineWorkflowResult operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.NotifyTerminateProvisionedProductEngineWorkflowResult
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/NotifyTerminateProvisionedProductEngineWorkflowResult"
     *      target="_top">AWS API Documentation</a>
     */
    default NotifyTerminateProvisionedProductEngineWorkflowResultResponse notifyTerminateProvisionedProductEngineWorkflowResult(
            Consumer<NotifyTerminateProvisionedProductEngineWorkflowResultRequest.Builder> notifyTerminateProvisionedProductEngineWorkflowResultRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return notifyTerminateProvisionedProductEngineWorkflowResult(NotifyTerminateProvisionedProductEngineWorkflowResultRequest
                .builder().applyMutation(notifyTerminateProvisionedProductEngineWorkflowResultRequest).build());
    }

    /**
     * <p>
     * Notifies the result of the update engine execution.
     * </p>
     *
     * @param notifyUpdateProvisionedProductEngineWorkflowResultRequest
     * @return Result of the NotifyUpdateProvisionedProductEngineWorkflowResult operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.NotifyUpdateProvisionedProductEngineWorkflowResult
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/NotifyUpdateProvisionedProductEngineWorkflowResult"
     *      target="_top">AWS API Documentation</a>
     */
    default NotifyUpdateProvisionedProductEngineWorkflowResultResponse notifyUpdateProvisionedProductEngineWorkflowResult(
            NotifyUpdateProvisionedProductEngineWorkflowResultRequest notifyUpdateProvisionedProductEngineWorkflowResultRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Notifies the result of the update engine execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link NotifyUpdateProvisionedProductEngineWorkflowResultRequest.Builder} avoiding the need to create one
     * manually via {@link NotifyUpdateProvisionedProductEngineWorkflowResultRequest#builder()}
     * </p>
     *
     * @param notifyUpdateProvisionedProductEngineWorkflowResultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link NotifyUpdateProvisionedProductEngineWorkflowResultInput.Builder} to create a request.
     * @return Result of the NotifyUpdateProvisionedProductEngineWorkflowResult operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.NotifyUpdateProvisionedProductEngineWorkflowResult
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/NotifyUpdateProvisionedProductEngineWorkflowResult"
     *      target="_top">AWS API Documentation</a>
     */
    default NotifyUpdateProvisionedProductEngineWorkflowResultResponse notifyUpdateProvisionedProductEngineWorkflowResult(
            Consumer<NotifyUpdateProvisionedProductEngineWorkflowResultRequest.Builder> notifyUpdateProvisionedProductEngineWorkflowResultRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return notifyUpdateProvisionedProductEngineWorkflowResult(NotifyUpdateProvisionedProductEngineWorkflowResultRequest
                .builder().applyMutation(notifyUpdateProvisionedProductEngineWorkflowResultRequest).build());
    }

    /**
     * <p>
     * Provisions the specified product.
     * </p>
     * <p>
     * A provisioned product is a resourced instance of a product. For example, provisioning a product that's based on
     * an CloudFormation template launches an CloudFormation stack and its underlying resources. You can check the
     * status of this request using <a>DescribeRecord</a>.
     * </p>
     * <p>
     * If the request contains a tag key with an empty list of values, there's a tag conflict for that key. Don't
     * include conflicted keys as tags, or this will cause the error
     * "Parameter validation failed: Missing required parameter in Tags[<i>N</i>]:<i>Value</i>".
     * </p>
     * <note>
     * <p>
     * When provisioning a product that's been added to a portfolio, you must grant your user, group, or role access to
     * the portfolio. For more information, see <a
     * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/catalogs_portfolios_users.html">Granting users
     * access</a> in the <i>Service Catalog User Guide</i>.
     * </p>
     * </note>
     *
     * @param provisionProductRequest
     * @return Result of the ProvisionProduct operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ProvisionProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisionProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default ProvisionProductResponse provisionProduct(ProvisionProductRequest provisionProductRequest)
            throws InvalidParametersException, ResourceNotFoundException, DuplicateResourceException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provisions the specified product.
     * </p>
     * <p>
     * A provisioned product is a resourced instance of a product. For example, provisioning a product that's based on
     * an CloudFormation template launches an CloudFormation stack and its underlying resources. You can check the
     * status of this request using <a>DescribeRecord</a>.
     * </p>
     * <p>
     * If the request contains a tag key with an empty list of values, there's a tag conflict for that key. Don't
     * include conflicted keys as tags, or this will cause the error
     * "Parameter validation failed: Missing required parameter in Tags[<i>N</i>]:<i>Value</i>".
     * </p>
     * <note>
     * <p>
     * When provisioning a product that's been added to a portfolio, you must grant your user, group, or role access to
     * the portfolio. For more information, see <a
     * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/catalogs_portfolios_users.html">Granting users
     * access</a> in the <i>Service Catalog User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ProvisionProductRequest.Builder} avoiding the need
     * to create one manually via {@link ProvisionProductRequest#builder()}
     * </p>
     *
     * @param provisionProductRequest
     *        A {@link Consumer} that will call methods on {@link ProvisionProductInput.Builder} to create a request.
     * @return Result of the ProvisionProduct operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ProvisionProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisionProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default ProvisionProductResponse provisionProduct(Consumer<ProvisionProductRequest.Builder> provisionProductRequest)
            throws InvalidParametersException, ResourceNotFoundException, DuplicateResourceException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return provisionProduct(ProvisionProductRequest.builder().applyMutation(provisionProductRequest).build());
    }

    /**
     * <p>
     * Rejects an offer to share the specified portfolio.
     * </p>
     *
     * @param rejectPortfolioShareRequest
     * @return Result of the RejectPortfolioShare operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.RejectPortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/RejectPortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectPortfolioShareResponse rejectPortfolioShare(RejectPortfolioShareRequest rejectPortfolioShareRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects an offer to share the specified portfolio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectPortfolioShareRequest.Builder} avoiding the
     * need to create one manually via {@link RejectPortfolioShareRequest#builder()}
     * </p>
     *
     * @param rejectPortfolioShareRequest
     *        A {@link Consumer} that will call methods on {@link RejectPortfolioShareInput.Builder} to create a
     *        request.
     * @return Result of the RejectPortfolioShare operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.RejectPortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/RejectPortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectPortfolioShareResponse rejectPortfolioShare(
            Consumer<RejectPortfolioShareRequest.Builder> rejectPortfolioShareRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        return rejectPortfolioShare(RejectPortfolioShareRequest.builder().applyMutation(rejectPortfolioShareRequest).build());
    }

    /**
     * <p>
     * Lists the provisioned products that are available (not terminated).
     * </p>
     * <p>
     * To use additional filtering, see <a>SearchProvisionedProducts</a>.
     * </p>
     *
     * @param scanProvisionedProductsRequest
     * @return Result of the ScanProvisionedProducts operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ScanProvisionedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ScanProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default ScanProvisionedProductsResponse scanProvisionedProducts(ScanProvisionedProductsRequest scanProvisionedProductsRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the provisioned products that are available (not terminated).
     * </p>
     * <p>
     * To use additional filtering, see <a>SearchProvisionedProducts</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ScanProvisionedProductsRequest.Builder} avoiding
     * the need to create one manually via {@link ScanProvisionedProductsRequest#builder()}
     * </p>
     *
     * @param scanProvisionedProductsRequest
     *        A {@link Consumer} that will call methods on {@link ScanProvisionedProductsInput.Builder} to create a
     *        request.
     * @return Result of the ScanProvisionedProducts operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ScanProvisionedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ScanProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default ScanProvisionedProductsResponse scanProvisionedProducts(
            Consumer<ScanProvisionedProductsRequest.Builder> scanProvisionedProductsRequest) throws InvalidParametersException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        return scanProvisionedProducts(ScanProvisionedProductsRequest.builder().applyMutation(scanProvisionedProductsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the provisioned products that are available (not terminated).
     * </p>
     * <p>
     * To use additional filtering, see <a>SearchProvisionedProducts</a>.
     * </p>
     *
     * @return Result of the ScanProvisionedProducts operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ScanProvisionedProducts
     * @see #scanProvisionedProducts(ScanProvisionedProductsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ScanProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default ScanProvisionedProductsResponse scanProvisionedProducts() throws InvalidParametersException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return scanProvisionedProducts(ScanProvisionedProductsRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the products to which the caller has access.
     * </p>
     *
     * @param searchProductsRequest
     * @return Result of the SearchProducts operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchProductsResponse searchProducts(SearchProductsRequest searchProductsRequest) throws InvalidParametersException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the products to which the caller has access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchProductsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchProductsRequest#builder()}
     * </p>
     *
     * @param searchProductsRequest
     *        A {@link Consumer} that will call methods on {@link SearchProductsInput.Builder} to create a request.
     * @return Result of the SearchProducts operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchProductsResponse searchProducts(Consumer<SearchProductsRequest.Builder> searchProductsRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return searchProducts(SearchProductsRequest.builder().applyMutation(searchProductsRequest).build());
    }

    /**
     * <p>
     * Gets information about the products to which the caller has access.
     * </p>
     *
     * @return Result of the SearchProducts operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProducts
     * @see #searchProducts(SearchProductsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchProductsResponse searchProducts() throws InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return searchProducts(SearchProductsRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the products to which the caller has access.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsIterable responses = client.searchProductsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsIterable responses = client
     *             .searchProductsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsIterable responses = client.searchProductsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProducts
     * @see #searchProductsPaginator(SearchProductsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchProductsIterable searchProductsPaginator() throws InvalidParametersException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return searchProductsPaginator(SearchProductsRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the products to which the caller has access.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsIterable responses = client.searchProductsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsIterable responses = client
     *             .searchProductsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsIterable responses = client.searchProductsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchProductsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchProductsIterable searchProductsPaginator(SearchProductsRequest searchProductsRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return new SearchProductsIterable(this, searchProductsRequest);
    }

    /**
     * <p>
     * Gets information about the products to which the caller has access.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsIterable responses = client.searchProductsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsIterable responses = client
     *             .searchProductsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsIterable responses = client.searchProductsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchProductsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchProductsRequest#builder()}
     * </p>
     *
     * @param searchProductsRequest
     *        A {@link Consumer} that will call methods on {@link SearchProductsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchProductsIterable searchProductsPaginator(Consumer<SearchProductsRequest.Builder> searchProductsRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return searchProductsPaginator(SearchProductsRequest.builder().applyMutation(searchProductsRequest).build());
    }

    /**
     * <p>
     * Gets information about the products for the specified portfolio or all products.
     * </p>
     *
     * @param searchProductsAsAdminRequest
     * @return Result of the SearchProductsAsAdmin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProductsAsAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProductsAsAdminResponse searchProductsAsAdmin(SearchProductsAsAdminRequest searchProductsAsAdminRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the products for the specified portfolio or all products.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchProductsAsAdminRequest.Builder} avoiding the
     * need to create one manually via {@link SearchProductsAsAdminRequest#builder()}
     * </p>
     *
     * @param searchProductsAsAdminRequest
     *        A {@link Consumer} that will call methods on {@link SearchProductsAsAdminInput.Builder} to create a
     *        request.
     * @return Result of the SearchProductsAsAdmin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProductsAsAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProductsAsAdminResponse searchProductsAsAdmin(
            Consumer<SearchProductsAsAdminRequest.Builder> searchProductsAsAdminRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return searchProductsAsAdmin(SearchProductsAsAdminRequest.builder().applyMutation(searchProductsAsAdminRequest).build());
    }

    /**
     * <p>
     * Gets information about the products for the specified portfolio or all products.
     * </p>
     *
     * @return Result of the SearchProductsAsAdmin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProductsAsAdmin
     * @see #searchProductsAsAdmin(SearchProductsAsAdminRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProductsAsAdminResponse searchProductsAsAdmin() throws ResourceNotFoundException, InvalidParametersException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        return searchProductsAsAdmin(SearchProductsAsAdminRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the products for the specified portfolio or all products.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProductsAsAdmin(software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminIterable responses = client.searchProductsAsAdminPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminIterable responses = client
     *             .searchProductsAsAdminPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminIterable responses = client.searchProductsAsAdminPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProductsAsAdmin(software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProductsAsAdmin
     * @see #searchProductsAsAdminPaginator(SearchProductsAsAdminRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProductsAsAdminIterable searchProductsAsAdminPaginator() throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return searchProductsAsAdminPaginator(SearchProductsAsAdminRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the products for the specified portfolio or all products.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProductsAsAdmin(software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminIterable responses = client.searchProductsAsAdminPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminIterable responses = client
     *             .searchProductsAsAdminPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminIterable responses = client.searchProductsAsAdminPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProductsAsAdmin(software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchProductsAsAdminRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProductsAsAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProductsAsAdminIterable searchProductsAsAdminPaginator(SearchProductsAsAdminRequest searchProductsAsAdminRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return new SearchProductsAsAdminIterable(this, searchProductsAsAdminRequest);
    }

    /**
     * <p>
     * Gets information about the products for the specified portfolio or all products.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProductsAsAdmin(software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminIterable responses = client.searchProductsAsAdminPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminIterable responses = client
     *             .searchProductsAsAdminPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminIterable responses = client.searchProductsAsAdminPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProductsAsAdmin(software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchProductsAsAdminRequest.Builder} avoiding the
     * need to create one manually via {@link SearchProductsAsAdminRequest#builder()}
     * </p>
     *
     * @param searchProductsAsAdminRequest
     *        A {@link Consumer} that will call methods on {@link SearchProductsAsAdminInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProductsAsAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProductsAsAdminIterable searchProductsAsAdminPaginator(
            Consumer<SearchProductsAsAdminRequest.Builder> searchProductsAsAdminRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return searchProductsAsAdminPaginator(SearchProductsAsAdminRequest.builder().applyMutation(searchProductsAsAdminRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about the provisioned products that meet the specified criteria.
     * </p>
     *
     * @param searchProvisionedProductsRequest
     * @return Result of the SearchProvisionedProducts operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProvisionedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProvisionedProductsResponse searchProvisionedProducts(
            SearchProvisionedProductsRequest searchProvisionedProductsRequest) throws InvalidParametersException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the provisioned products that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchProvisionedProductsRequest.Builder} avoiding
     * the need to create one manually via {@link SearchProvisionedProductsRequest#builder()}
     * </p>
     *
     * @param searchProvisionedProductsRequest
     *        A {@link Consumer} that will call methods on {@link SearchProvisionedProductsInput.Builder} to create a
     *        request.
     * @return Result of the SearchProvisionedProducts operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProvisionedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProvisionedProductsResponse searchProvisionedProducts(
            Consumer<SearchProvisionedProductsRequest.Builder> searchProvisionedProductsRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return searchProvisionedProducts(SearchProvisionedProductsRequest.builder()
                .applyMutation(searchProvisionedProductsRequest).build());
    }

    /**
     * <p>
     * Gets information about the provisioned products that meet the specified criteria.
     * </p>
     *
     * @return Result of the SearchProvisionedProducts operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProvisionedProducts
     * @see #searchProvisionedProducts(SearchProvisionedProductsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProvisionedProductsResponse searchProvisionedProducts() throws InvalidParametersException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return searchProvisionedProducts(SearchProvisionedProductsRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the provisioned products that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProvisionedProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsIterable responses = client.searchProvisionedProductsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsIterable responses = client
     *             .searchProvisionedProductsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsIterable responses = client.searchProvisionedProductsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProvisionedProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProvisionedProducts
     * @see #searchProvisionedProductsPaginator(SearchProvisionedProductsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProvisionedProductsIterable searchProvisionedProductsPaginator() throws InvalidParametersException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        return searchProvisionedProductsPaginator(SearchProvisionedProductsRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the provisioned products that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProvisionedProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsIterable responses = client.searchProvisionedProductsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsIterable responses = client
     *             .searchProvisionedProductsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsIterable responses = client.searchProvisionedProductsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProvisionedProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchProvisionedProductsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProvisionedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProvisionedProductsIterable searchProvisionedProductsPaginator(
            SearchProvisionedProductsRequest searchProvisionedProductsRequest) throws InvalidParametersException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        return new SearchProvisionedProductsIterable(this, searchProvisionedProductsRequest);
    }

    /**
     * <p>
     * Gets information about the provisioned products that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProvisionedProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsIterable responses = client.searchProvisionedProductsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsIterable responses = client
     *             .searchProvisionedProductsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsIterable responses = client.searchProvisionedProductsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProvisionedProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchProvisionedProductsRequest.Builder} avoiding
     * the need to create one manually via {@link SearchProvisionedProductsRequest#builder()}
     * </p>
     *
     * @param searchProvisionedProductsRequest
     *        A {@link Consumer} that will call methods on {@link SearchProvisionedProductsInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProvisionedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProvisionedProductsIterable searchProvisionedProductsPaginator(
            Consumer<SearchProvisionedProductsRequest.Builder> searchProvisionedProductsRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return searchProvisionedProductsPaginator(SearchProvisionedProductsRequest.builder()
                .applyMutation(searchProvisionedProductsRequest).build());
    }

    /**
     * <p>
     * Terminates the specified provisioned product.
     * </p>
     * <p>
     * This operation does not delete any records associated with the provisioned product.
     * </p>
     * <p>
     * You can check the status of this request using <a>DescribeRecord</a>.
     * </p>
     *
     * @param terminateProvisionedProductRequest
     * @return Result of the TerminateProvisionedProduct operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.TerminateProvisionedProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/TerminateProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default TerminateProvisionedProductResponse terminateProvisionedProduct(
            TerminateProvisionedProductRequest terminateProvisionedProductRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates the specified provisioned product.
     * </p>
     * <p>
     * This operation does not delete any records associated with the provisioned product.
     * </p>
     * <p>
     * You can check the status of this request using <a>DescribeRecord</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateProvisionedProductRequest.Builder}
     * avoiding the need to create one manually via {@link TerminateProvisionedProductRequest#builder()}
     * </p>
     *
     * @param terminateProvisionedProductRequest
     *        A {@link Consumer} that will call methods on {@link TerminateProvisionedProductInput.Builder} to create a
     *        request.
     * @return Result of the TerminateProvisionedProduct operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.TerminateProvisionedProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/TerminateProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default TerminateProvisionedProductResponse terminateProvisionedProduct(
            Consumer<TerminateProvisionedProductRequest.Builder> terminateProvisionedProductRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return terminateProvisionedProduct(TerminateProvisionedProductRequest.builder()
                .applyMutation(terminateProvisionedProductRequest).build());
    }

    /**
     * <p>
     * Updates the specified constraint.
     * </p>
     *
     * @param updateConstraintRequest
     * @return Result of the UpdateConstraint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateConstraint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConstraintResponse updateConstraint(UpdateConstraintRequest updateConstraintRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified constraint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConstraintRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateConstraintRequest#builder()}
     * </p>
     *
     * @param updateConstraintRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConstraintInput.Builder} to create a request.
     * @return Result of the UpdateConstraint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateConstraint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConstraintResponse updateConstraint(Consumer<UpdateConstraintRequest.Builder> updateConstraintRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return updateConstraint(UpdateConstraintRequest.builder().applyMutation(updateConstraintRequest).build());
    }

    /**
     * <p>
     * Updates the specified portfolio.
     * </p>
     * <p>
     * You cannot update a product that was shared with you.
     * </p>
     *
     * @param updatePortfolioRequest
     * @return Result of the UpdatePortfolio operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdatePortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdatePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePortfolioResponse updatePortfolio(UpdatePortfolioRequest updatePortfolioRequest)
            throws InvalidParametersException, ResourceNotFoundException, LimitExceededException, TagOptionNotMigratedException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified portfolio.
     * </p>
     * <p>
     * You cannot update a product that was shared with you.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePortfolioRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePortfolioRequest#builder()}
     * </p>
     *
     * @param updatePortfolioRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePortfolioInput.Builder} to create a request.
     * @return Result of the UpdatePortfolio operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdatePortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdatePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePortfolioResponse updatePortfolio(Consumer<UpdatePortfolioRequest.Builder> updatePortfolioRequest)
            throws InvalidParametersException, ResourceNotFoundException, LimitExceededException, TagOptionNotMigratedException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        return updatePortfolio(UpdatePortfolioRequest.builder().applyMutation(updatePortfolioRequest).build());
    }

    /**
     * <p>
     * Updates the specified portfolio share. You can use this API to enable or disable <code>TagOptions</code> sharing
     * or Principal sharing for an existing portfolio share.
     * </p>
     * <p>
     * The portfolio share cannot be updated if the <code>CreatePortfolioShare</code> operation is
     * <code>IN_PROGRESS</code>, as the share is not available to recipient entities. In this case, you must wait for
     * the portfolio share to be COMPLETED.
     * </p>
     * <p>
     * You must provide the <code>accountId</code> or organization node in the input, but not both.
     * </p>
     * <p>
     * If the portfolio is shared to both an external account and an organization node, and both shares need to be
     * updated, you must invoke <code>UpdatePortfolioShare</code> separately for each share type.
     * </p>
     * <p>
     * This API cannot be used for removing the portfolio share. You must use <code>DeletePortfolioShare</code> API for
     * that action.
     * </p>
     * <note>
     * <p>
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that
     * portfolio is then shared with other accounts. For a user in a recipient account who is <i>not</i> an Service
     * Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role
     * that matches a principal name association for the portfolio. Although this user may not know which principal
     * names are associated through Service Catalog, they may be able to guess the user. If this potential escalation
     * path is a concern, then Service Catalog recommends using <code>PrincipalType</code> as <code>IAM</code>. With
     * this configuration, the <code>PrincipalARN</code> must already exist in the recipient account before it can be
     * associated.
     * </p>
     * </note>
     *
     * @param updatePortfolioShareRequest
     * @return Result of the UpdatePortfolioShare operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdatePortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdatePortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePortfolioShareResponse updatePortfolioShare(UpdatePortfolioShareRequest updatePortfolioShareRequest)
            throws ResourceNotFoundException, InvalidParametersException, OperationNotSupportedException, InvalidStateException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified portfolio share. You can use this API to enable or disable <code>TagOptions</code> sharing
     * or Principal sharing for an existing portfolio share.
     * </p>
     * <p>
     * The portfolio share cannot be updated if the <code>CreatePortfolioShare</code> operation is
     * <code>IN_PROGRESS</code>, as the share is not available to recipient entities. In this case, you must wait for
     * the portfolio share to be COMPLETED.
     * </p>
     * <p>
     * You must provide the <code>accountId</code> or organization node in the input, but not both.
     * </p>
     * <p>
     * If the portfolio is shared to both an external account and an organization node, and both shares need to be
     * updated, you must invoke <code>UpdatePortfolioShare</code> separately for each share type.
     * </p>
     * <p>
     * This API cannot be used for removing the portfolio share. You must use <code>DeletePortfolioShare</code> API for
     * that action.
     * </p>
     * <note>
     * <p>
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that
     * portfolio is then shared with other accounts. For a user in a recipient account who is <i>not</i> an Service
     * Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role
     * that matches a principal name association for the portfolio. Although this user may not know which principal
     * names are associated through Service Catalog, they may be able to guess the user. If this potential escalation
     * path is a concern, then Service Catalog recommends using <code>PrincipalType</code> as <code>IAM</code>. With
     * this configuration, the <code>PrincipalARN</code> must already exist in the recipient account before it can be
     * associated.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePortfolioShareRequest.Builder} avoiding the
     * need to create one manually via {@link UpdatePortfolioShareRequest#builder()}
     * </p>
     *
     * @param updatePortfolioShareRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePortfolioShareInput.Builder} to create a
     *        request.
     * @return Result of the UpdatePortfolioShare operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdatePortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdatePortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePortfolioShareResponse updatePortfolioShare(
            Consumer<UpdatePortfolioShareRequest.Builder> updatePortfolioShareRequest) throws ResourceNotFoundException,
            InvalidParametersException, OperationNotSupportedException, InvalidStateException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return updatePortfolioShare(UpdatePortfolioShareRequest.builder().applyMutation(updatePortfolioShareRequest).build());
    }

    /**
     * <p>
     * Updates the specified product.
     * </p>
     *
     * @param updateProductRequest
     * @return Result of the UpdateProduct operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateProductResponse updateProduct(UpdateProductRequest updateProductRequest) throws ResourceNotFoundException,
            InvalidParametersException, TagOptionNotMigratedException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProductRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProductRequest#builder()}
     * </p>
     *
     * @param updateProductRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProductInput.Builder} to create a request.
     * @return Result of the UpdateProduct operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateProductResponse updateProduct(Consumer<UpdateProductRequest.Builder> updateProductRequest)
            throws ResourceNotFoundException, InvalidParametersException, TagOptionNotMigratedException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return updateProduct(UpdateProductRequest.builder().applyMutation(updateProductRequest).build());
    }

    /**
     * <p>
     * Requests updates to the configuration of the specified provisioned product.
     * </p>
     * <p>
     * If there are tags associated with the object, they cannot be updated or added. Depending on the specific updates
     * requested, this operation can update with no interruption, with some interruption, or replace the provisioned
     * product entirely.
     * </p>
     * <p>
     * You can check the status of this request using <a>DescribeRecord</a>.
     * </p>
     *
     * @param updateProvisionedProductRequest
     * @return Result of the UpdateProvisionedProduct operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateProvisionedProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProvisionedProductResponse updateProvisionedProduct(
            UpdateProvisionedProductRequest updateProvisionedProductRequest) throws InvalidParametersException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests updates to the configuration of the specified provisioned product.
     * </p>
     * <p>
     * If there are tags associated with the object, they cannot be updated or added. Depending on the specific updates
     * requested, this operation can update with no interruption, with some interruption, or replace the provisioned
     * product entirely.
     * </p>
     * <p>
     * You can check the status of this request using <a>DescribeRecord</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProvisionedProductRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateProvisionedProductRequest#builder()}
     * </p>
     *
     * @param updateProvisionedProductRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProvisionedProductInput.Builder} to create a
     *        request.
     * @return Result of the UpdateProvisionedProduct operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateProvisionedProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProvisionedProductResponse updateProvisionedProduct(
            Consumer<UpdateProvisionedProductRequest.Builder> updateProvisionedProductRequest) throws InvalidParametersException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return updateProvisionedProduct(UpdateProvisionedProductRequest.builder().applyMutation(updateProvisionedProductRequest)
                .build());
    }

    /**
     * <p>
     * Requests updates to the properties of the specified provisioned product.
     * </p>
     *
     * @param updateProvisionedProductPropertiesRequest
     * @return Result of the UpdateProvisionedProductProperties operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateProvisionedProductProperties
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisionedProductProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProvisionedProductPropertiesResponse updateProvisionedProductProperties(
            UpdateProvisionedProductPropertiesRequest updateProvisionedProductPropertiesRequest)
            throws InvalidParametersException, ResourceNotFoundException, InvalidStateException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests updates to the properties of the specified provisioned product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProvisionedProductPropertiesRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateProvisionedProductPropertiesRequest#builder()}
     * </p>
     *
     * @param updateProvisionedProductPropertiesRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProvisionedProductPropertiesInput.Builder} to
     *        create a request.
     * @return Result of the UpdateProvisionedProductProperties operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateProvisionedProductProperties
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisionedProductProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProvisionedProductPropertiesResponse updateProvisionedProductProperties(
            Consumer<UpdateProvisionedProductPropertiesRequest.Builder> updateProvisionedProductPropertiesRequest)
            throws InvalidParametersException, ResourceNotFoundException, InvalidStateException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        return updateProvisionedProductProperties(UpdateProvisionedProductPropertiesRequest.builder()
                .applyMutation(updateProvisionedProductPropertiesRequest).build());
    }

    /**
     * <p>
     * Updates the specified provisioning artifact (also known as a version) for the specified product.
     * </p>
     * <p>
     * You cannot update a provisioning artifact for a product that was shared with you.
     * </p>
     *
     * @param updateProvisioningArtifactRequest
     * @return Result of the UpdateProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateProvisioningArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProvisioningArtifactResponse updateProvisioningArtifact(
            UpdateProvisioningArtifactRequest updateProvisioningArtifactRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified provisioning artifact (also known as a version) for the specified product.
     * </p>
     * <p>
     * You cannot update a provisioning artifact for a product that was shared with you.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProvisioningArtifactRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateProvisioningArtifactRequest#builder()}
     * </p>
     *
     * @param updateProvisioningArtifactRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProvisioningArtifactInput.Builder} to create a
     *        request.
     * @return Result of the UpdateProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateProvisioningArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProvisioningArtifactResponse updateProvisioningArtifact(
            Consumer<UpdateProvisioningArtifactRequest.Builder> updateProvisioningArtifactRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return updateProvisioningArtifact(UpdateProvisioningArtifactRequest.builder()
                .applyMutation(updateProvisioningArtifactRequest).build());
    }

    /**
     * <p>
     * Updates a self-service action.
     * </p>
     *
     * @param updateServiceActionRequest
     * @return Result of the UpdateServiceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateServiceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServiceActionResponse updateServiceAction(UpdateServiceActionRequest updateServiceActionRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a self-service action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceActionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateServiceActionRequest#builder()}
     * </p>
     *
     * @param updateServiceActionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateServiceActionInput.Builder} to create a request.
     * @return Result of the UpdateServiceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateServiceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServiceActionResponse updateServiceAction(
            Consumer<UpdateServiceActionRequest.Builder> updateServiceActionRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return updateServiceAction(UpdateServiceActionRequest.builder().applyMutation(updateServiceActionRequest).build());
    }

    /**
     * <p>
     * Updates the specified TagOption.
     * </p>
     *
     * @param updateTagOptionRequest
     * @return Result of the UpdateTagOption operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTagOptionResponse updateTagOption(UpdateTagOptionRequest updateTagOptionRequest)
            throws TagOptionNotMigratedException, ResourceNotFoundException, DuplicateResourceException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified TagOption.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTagOptionRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateTagOptionRequest#builder()}
     * </p>
     *
     * @param updateTagOptionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTagOptionInput.Builder} to create a request.
     * @return Result of the UpdateTagOption operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTagOptionResponse updateTagOption(Consumer<UpdateTagOptionRequest.Builder> updateTagOptionRequest)
            throws TagOptionNotMigratedException, ResourceNotFoundException, DuplicateResourceException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return updateTagOption(UpdateTagOptionRequest.builder().applyMutation(updateTagOptionRequest).build());
    }

    /**
     * Create a {@link ServiceCatalogClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ServiceCatalogClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ServiceCatalogClient}.
     */
    static ServiceCatalogClientBuilder builder() {
        return new DefaultServiceCatalogClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default ServiceCatalogServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
