/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.CopyProductStatus;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCopyProductStatusResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, DescribeCopyProductStatusResponse> {
    private static final SdkField<String> COPY_PRODUCT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CopyProductStatus").getter(DescribeCopyProductStatusResponse.getter(DescribeCopyProductStatusResponse::copyProductStatusAsString)).setter(DescribeCopyProductStatusResponse.setter(Builder::copyProductStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyProductStatus").build()}).build();
    private static final SdkField<String> TARGET_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetProductId").getter(DescribeCopyProductStatusResponse.getter(DescribeCopyProductStatusResponse::targetProductId)).setter(DescribeCopyProductStatusResponse.setter(Builder::targetProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetProductId").build()}).build();
    private static final SdkField<String> STATUS_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusDetail").getter(DescribeCopyProductStatusResponse.getter(DescribeCopyProductStatusResponse::statusDetail)).setter(DescribeCopyProductStatusResponse.setter(Builder::statusDetail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COPY_PRODUCT_STATUS_FIELD, TARGET_PRODUCT_ID_FIELD, STATUS_DETAIL_FIELD));
    private final String copyProductStatus;
    private final String targetProductId;
    private final String statusDetail;

    private DescribeCopyProductStatusResponse(BuilderImpl builder) {
        super(builder);
        this.copyProductStatus = builder.copyProductStatus;
        this.targetProductId = builder.targetProductId;
        this.statusDetail = builder.statusDetail;
    }

    public final CopyProductStatus copyProductStatus() {
        return CopyProductStatus.fromValue(this.copyProductStatus);
    }

    public final String copyProductStatusAsString() {
        return this.copyProductStatus;
    }

    public final String targetProductId() {
        return this.targetProductId;
    }

    public final String statusDetail() {
        return this.statusDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.copyProductStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCopyProductStatusResponse)) {
            return false;
        }
        DescribeCopyProductStatusResponse other = (DescribeCopyProductStatusResponse)((Object)obj);
        return Objects.equals(this.copyProductStatusAsString(), other.copyProductStatusAsString()) && Objects.equals(this.targetProductId(), other.targetProductId()) && Objects.equals(this.statusDetail(), other.statusDetail());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCopyProductStatusResponse").add("CopyProductStatus", (Object)this.copyProductStatusAsString()).add("TargetProductId", (Object)this.targetProductId()).add("StatusDetail", (Object)this.statusDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CopyProductStatus": {
                return Optional.ofNullable(clazz.cast(this.copyProductStatusAsString()));
            }
            case "TargetProductId": {
                return Optional.ofNullable(clazz.cast(this.targetProductId()));
            }
            case "StatusDetail": {
                return Optional.ofNullable(clazz.cast(this.statusDetail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCopyProductStatusResponse, T> g) {
        return obj -> g.apply((DescribeCopyProductStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private String copyProductStatus;
        private String targetProductId;
        private String statusDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCopyProductStatusResponse model) {
            super(model);
            this.copyProductStatus(model.copyProductStatus);
            this.targetProductId(model.targetProductId);
            this.statusDetail(model.statusDetail);
        }

        public final String getCopyProductStatus() {
            return this.copyProductStatus;
        }

        public final void setCopyProductStatus(String copyProductStatus) {
            this.copyProductStatus = copyProductStatus;
        }

        @Override
        public final Builder copyProductStatus(String copyProductStatus) {
            this.copyProductStatus = copyProductStatus;
            return this;
        }

        @Override
        public final Builder copyProductStatus(CopyProductStatus copyProductStatus) {
            this.copyProductStatus(copyProductStatus == null ? null : copyProductStatus.toString());
            return this;
        }

        public final String getTargetProductId() {
            return this.targetProductId;
        }

        public final void setTargetProductId(String targetProductId) {
            this.targetProductId = targetProductId;
        }

        @Override
        public final Builder targetProductId(String targetProductId) {
            this.targetProductId = targetProductId;
            return this;
        }

        public final String getStatusDetail() {
            return this.statusDetail;
        }

        public final void setStatusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
        }

        @Override
        public final Builder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            return this;
        }

        @Override
        public DescribeCopyProductStatusResponse build() {
            return new DescribeCopyProductStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCopyProductStatusResponse> {
        public Builder copyProductStatus(String var1);

        public Builder copyProductStatus(CopyProductStatus var1);

        public Builder targetProductId(String var1);

        public Builder statusDetail(String var1);
    }
}

