/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse;

public class ListPortfoliosIterable
implements SdkIterable<ListPortfoliosResponse> {
    private final ServiceCatalogClient client;
    private final ListPortfoliosRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPortfoliosIterable(ServiceCatalogClient client, ListPortfoliosRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPortfoliosResponseFetcher();
    }

    public Iterator<ListPortfoliosResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPortfoliosResponseFetcher
    implements SyncPageFetcher<ListPortfoliosResponse> {
        private ListPortfoliosResponseFetcher() {
        }

        public boolean hasNextPage(ListPortfoliosResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListPortfoliosResponse nextPage(ListPortfoliosResponse previousPage) {
            if (previousPage == null) {
                return ListPortfoliosIterable.this.client.listPortfolios(ListPortfoliosIterable.this.firstRequest);
            }
            return ListPortfoliosIterable.this.client.listPortfolios((ListPortfoliosRequest)((Object)ListPortfoliosIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

