/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.PortfolioShareDetail;
import software.amazon.awssdk.services.servicecatalog.model.PortfolioShareDetailsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePortfolioSharesResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, DescribePortfolioSharesResponse> {
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(DescribePortfolioSharesResponse.getter(DescribePortfolioSharesResponse::nextPageToken)).setter(DescribePortfolioSharesResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final SdkField<List<PortfolioShareDetail>> PORTFOLIO_SHARE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PortfolioShareDetails").getter(DescribePortfolioSharesResponse.getter(DescribePortfolioSharesResponse::portfolioShareDetails)).setter(DescribePortfolioSharesResponse.setter(Builder::portfolioShareDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioShareDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortfolioShareDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_PAGE_TOKEN_FIELD, PORTFOLIO_SHARE_DETAILS_FIELD));
    private final String nextPageToken;
    private final List<PortfolioShareDetail> portfolioShareDetails;

    private DescribePortfolioSharesResponse(BuilderImpl builder) {
        super(builder);
        this.nextPageToken = builder.nextPageToken;
        this.portfolioShareDetails = builder.portfolioShareDetails;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public final boolean hasPortfolioShareDetails() {
        return this.portfolioShareDetails != null && !(this.portfolioShareDetails instanceof SdkAutoConstructList);
    }

    public final List<PortfolioShareDetail> portfolioShareDetails() {
        return this.portfolioShareDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPortfolioShareDetails() ? this.portfolioShareDetails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePortfolioSharesResponse)) {
            return false;
        }
        DescribePortfolioSharesResponse other = (DescribePortfolioSharesResponse)((Object)obj);
        return Objects.equals(this.nextPageToken(), other.nextPageToken()) && this.hasPortfolioShareDetails() == other.hasPortfolioShareDetails() && Objects.equals(this.portfolioShareDetails(), other.portfolioShareDetails());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePortfolioSharesResponse").add("NextPageToken", (Object)this.nextPageToken()).add("PortfolioShareDetails", this.hasPortfolioShareDetails() ? this.portfolioShareDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
            case "PortfolioShareDetails": {
                return Optional.ofNullable(clazz.cast(this.portfolioShareDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePortfolioSharesResponse, T> g) {
        return obj -> g.apply((DescribePortfolioSharesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private String nextPageToken;
        private List<PortfolioShareDetail> portfolioShareDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePortfolioSharesResponse model) {
            super(model);
            this.nextPageToken(model.nextPageToken);
            this.portfolioShareDetails(model.portfolioShareDetails);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final List<PortfolioShareDetail.Builder> getPortfolioShareDetails() {
            List<PortfolioShareDetail.Builder> result = PortfolioShareDetailsCopier.copyToBuilder(this.portfolioShareDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortfolioShareDetails(Collection<PortfolioShareDetail.BuilderImpl> portfolioShareDetails) {
            this.portfolioShareDetails = PortfolioShareDetailsCopier.copyFromBuilder(portfolioShareDetails);
        }

        @Override
        public final Builder portfolioShareDetails(Collection<PortfolioShareDetail> portfolioShareDetails) {
            this.portfolioShareDetails = PortfolioShareDetailsCopier.copy(portfolioShareDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portfolioShareDetails(PortfolioShareDetail ... portfolioShareDetails) {
            this.portfolioShareDetails(Arrays.asList(portfolioShareDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portfolioShareDetails(Consumer<PortfolioShareDetail.Builder> ... portfolioShareDetails) {
            this.portfolioShareDetails(Stream.of(portfolioShareDetails).map(c -> (PortfolioShareDetail)((PortfolioShareDetail.Builder)PortfolioShareDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribePortfolioSharesResponse build() {
            return new DescribePortfolioSharesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePortfolioSharesResponse> {
        public Builder nextPageToken(String var1);

        public Builder portfolioShareDetails(Collection<PortfolioShareDetail> var1);

        public Builder portfolioShareDetails(PortfolioShareDetail ... var1);

        public Builder portfolioShareDetails(Consumer<PortfolioShareDetail.Builder> ... var1);
    }
}

