/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteProvisionedProductPlanRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, DeleteProvisionedProductPlanRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptLanguage").getter(DeleteProvisionedProductPlanRequest.getter(DeleteProvisionedProductPlanRequest::acceptLanguage)).setter(DeleteProvisionedProductPlanRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> PLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlanId").getter(DeleteProvisionedProductPlanRequest.getter(DeleteProvisionedProductPlanRequest::planId)).setter(DeleteProvisionedProductPlanRequest.setter(Builder::planId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanId").build()}).build();
    private static final SdkField<Boolean> IGNORE_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IgnoreErrors").getter(DeleteProvisionedProductPlanRequest.getter(DeleteProvisionedProductPlanRequest::ignoreErrors)).setter(DeleteProvisionedProductPlanRequest.setter(Builder::ignoreErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IgnoreErrors").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, PLAN_ID_FIELD, IGNORE_ERRORS_FIELD));
    private final String acceptLanguage;
    private final String planId;
    private final Boolean ignoreErrors;

    private DeleteProvisionedProductPlanRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.planId = builder.planId;
        this.ignoreErrors = builder.ignoreErrors;
    }

    public final String acceptLanguage() {
        return this.acceptLanguage;
    }

    public final String planId() {
        return this.planId;
    }

    public final Boolean ignoreErrors() {
        return this.ignoreErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.planId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ignoreErrors());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteProvisionedProductPlanRequest)) {
            return false;
        }
        DeleteProvisionedProductPlanRequest other = (DeleteProvisionedProductPlanRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.planId(), other.planId()) && Objects.equals(this.ignoreErrors(), other.ignoreErrors());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteProvisionedProductPlanRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("PlanId", (Object)this.planId()).add("IgnoreErrors", (Object)this.ignoreErrors()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "PlanId": {
                return Optional.ofNullable(clazz.cast(this.planId()));
            }
            case "IgnoreErrors": {
                return Optional.ofNullable(clazz.cast(this.ignoreErrors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteProvisionedProductPlanRequest, T> g) {
        return obj -> g.apply((DeleteProvisionedProductPlanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String planId;
        private Boolean ignoreErrors;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteProvisionedProductPlanRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.planId(model.planId);
            this.ignoreErrors(model.ignoreErrors);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getPlanId() {
            return this.planId;
        }

        public final void setPlanId(String planId) {
            this.planId = planId;
        }

        @Override
        public final Builder planId(String planId) {
            this.planId = planId;
            return this;
        }

        public final Boolean getIgnoreErrors() {
            return this.ignoreErrors;
        }

        public final void setIgnoreErrors(Boolean ignoreErrors) {
            this.ignoreErrors = ignoreErrors;
        }

        @Override
        public final Builder ignoreErrors(Boolean ignoreErrors) {
            this.ignoreErrors = ignoreErrors;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteProvisionedProductPlanRequest build() {
            return new DeleteProvisionedProductPlanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteProvisionedProductPlanRequest> {
        public Builder acceptLanguage(String var1);

        public Builder planId(String var1);

        public Builder ignoreErrors(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

