/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociation;
import software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDisassociateServiceActionFromProvisioningArtifactRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, BatchDisassociateServiceActionFromProvisioningArtifactRequest> {
    private static final SdkField<List<ServiceActionAssociation>> SERVICE_ACTION_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceActionAssociations").getter(BatchDisassociateServiceActionFromProvisioningArtifactRequest.getter(BatchDisassociateServiceActionFromProvisioningArtifactRequest::serviceActionAssociations)).setter(BatchDisassociateServiceActionFromProvisioningArtifactRequest.setter(Builder::serviceActionAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceActionAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceActionAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptLanguage").getter(BatchDisassociateServiceActionFromProvisioningArtifactRequest.getter(BatchDisassociateServiceActionFromProvisioningArtifactRequest::acceptLanguage)).setter(BatchDisassociateServiceActionFromProvisioningArtifactRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACTION_ASSOCIATIONS_FIELD, ACCEPT_LANGUAGE_FIELD));
    private final List<ServiceActionAssociation> serviceActionAssociations;
    private final String acceptLanguage;

    private BatchDisassociateServiceActionFromProvisioningArtifactRequest(BuilderImpl builder) {
        super(builder);
        this.serviceActionAssociations = builder.serviceActionAssociations;
        this.acceptLanguage = builder.acceptLanguage;
    }

    public final boolean hasServiceActionAssociations() {
        return this.serviceActionAssociations != null && !(this.serviceActionAssociations instanceof SdkAutoConstructList);
    }

    public final List<ServiceActionAssociation> serviceActionAssociations() {
        return this.serviceActionAssociations;
    }

    public final String acceptLanguage() {
        return this.acceptLanguage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceActionAssociations() ? this.serviceActionAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisassociateServiceActionFromProvisioningArtifactRequest)) {
            return false;
        }
        BatchDisassociateServiceActionFromProvisioningArtifactRequest other = (BatchDisassociateServiceActionFromProvisioningArtifactRequest)((Object)obj);
        return this.hasServiceActionAssociations() == other.hasServiceActionAssociations() && Objects.equals(this.serviceActionAssociations(), other.serviceActionAssociations()) && Objects.equals(this.acceptLanguage(), other.acceptLanguage());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDisassociateServiceActionFromProvisioningArtifactRequest").add("ServiceActionAssociations", this.hasServiceActionAssociations() ? this.serviceActionAssociations() : null).add("AcceptLanguage", (Object)this.acceptLanguage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceActionAssociations": {
                return Optional.ofNullable(clazz.cast(this.serviceActionAssociations()));
            }
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDisassociateServiceActionFromProvisioningArtifactRequest, T> g) {
        return obj -> g.apply((BatchDisassociateServiceActionFromProvisioningArtifactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private List<ServiceActionAssociation> serviceActionAssociations = DefaultSdkAutoConstructList.getInstance();
        private String acceptLanguage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDisassociateServiceActionFromProvisioningArtifactRequest model) {
            super(model);
            this.serviceActionAssociations(model.serviceActionAssociations);
            this.acceptLanguage(model.acceptLanguage);
        }

        public final List<ServiceActionAssociation.Builder> getServiceActionAssociations() {
            List<ServiceActionAssociation.Builder> result = ServiceActionAssociationsCopier.copyToBuilder(this.serviceActionAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceActionAssociations(Collection<ServiceActionAssociation.BuilderImpl> serviceActionAssociations) {
            this.serviceActionAssociations = ServiceActionAssociationsCopier.copyFromBuilder(serviceActionAssociations);
        }

        @Override
        @Transient
        public final Builder serviceActionAssociations(Collection<ServiceActionAssociation> serviceActionAssociations) {
            this.serviceActionAssociations = ServiceActionAssociationsCopier.copy(serviceActionAssociations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder serviceActionAssociations(ServiceActionAssociation ... serviceActionAssociations) {
            this.serviceActionAssociations(Arrays.asList(serviceActionAssociations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder serviceActionAssociations(Consumer<ServiceActionAssociation.Builder> ... serviceActionAssociations) {
            this.serviceActionAssociations(Stream.of(serviceActionAssociations).map(c -> (ServiceActionAssociation)((ServiceActionAssociation.Builder)ServiceActionAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        @Transient
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDisassociateServiceActionFromProvisioningArtifactRequest build() {
            return new BatchDisassociateServiceActionFromProvisioningArtifactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDisassociateServiceActionFromProvisioningArtifactRequest> {
        public Builder serviceActionAssociations(Collection<ServiceActionAssociation> var1);

        public Builder serviceActionAssociations(ServiceActionAssociation ... var1);

        public Builder serviceActionAssociations(Consumer<ServiceActionAssociation.Builder> ... var1);

        public Builder acceptLanguage(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

