/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.StackInstanceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackInstance> {
    private static final SdkField<String> ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Account").getter(StackInstance.getter(StackInstance::account)).setter(StackInstance.setter(Builder::account)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(StackInstance.getter(StackInstance::region)).setter(StackInstance.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> STACK_INSTANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackInstanceStatus").getter(StackInstance.getter(StackInstance::stackInstanceStatusAsString)).setter(StackInstance.setter(Builder::stackInstanceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackInstanceStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_FIELD, REGION_FIELD, STACK_INSTANCE_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String account;
    private final String region;
    private final String stackInstanceStatus;

    private StackInstance(BuilderImpl builder) {
        this.account = builder.account;
        this.region = builder.region;
        this.stackInstanceStatus = builder.stackInstanceStatus;
    }

    public final String account() {
        return this.account;
    }

    public final String region() {
        return this.region;
    }

    public final StackInstanceStatus stackInstanceStatus() {
        return StackInstanceStatus.fromValue(this.stackInstanceStatus);
    }

    public final String stackInstanceStatusAsString() {
        return this.stackInstanceStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.account());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackInstanceStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackInstance)) {
            return false;
        }
        StackInstance other = (StackInstance)obj;
        return Objects.equals(this.account(), other.account()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.stackInstanceStatusAsString(), other.stackInstanceStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StackInstance").add("Account", (Object)this.account()).add("Region", (Object)this.region()).add("StackInstanceStatus", (Object)this.stackInstanceStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Account": {
                return Optional.ofNullable(clazz.cast(this.account()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "StackInstanceStatus": {
                return Optional.ofNullable(clazz.cast(this.stackInstanceStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackInstance, T> g) {
        return obj -> g.apply((StackInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String account;
        private String region;
        private String stackInstanceStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(StackInstance model) {
            this.account(model.account);
            this.region(model.region);
            this.stackInstanceStatus(model.stackInstanceStatus);
        }

        public final String getAccount() {
            return this.account;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        @Override
        @Transient
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getStackInstanceStatus() {
            return this.stackInstanceStatus;
        }

        public final void setStackInstanceStatus(String stackInstanceStatus) {
            this.stackInstanceStatus = stackInstanceStatus;
        }

        @Override
        @Transient
        public final Builder stackInstanceStatus(String stackInstanceStatus) {
            this.stackInstanceStatus = stackInstanceStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder stackInstanceStatus(StackInstanceStatus stackInstanceStatus) {
            this.stackInstanceStatus(stackInstanceStatus == null ? null : stackInstanceStatus.toString());
            return this;
        }

        public StackInstance build() {
            return new StackInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackInstance> {
        public Builder account(String var1);

        public Builder region(String var1);

        public Builder stackInstanceStatus(String var1);

        public Builder stackInstanceStatus(StackInstanceStatus var1);
    }
}

