/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ShareError;
import software.amazon.awssdk.services.servicecatalog.model.ShareErrorsCopier;
import software.amazon.awssdk.services.servicecatalog.model.SuccessfulSharesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ShareDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ShareDetails> {
    private static final SdkField<List<String>> SUCCESSFUL_SHARES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuccessfulShares").getter(ShareDetails.getter(ShareDetails::successfulShares)).setter(ShareDetails.setter(Builder::successfulShares)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulShares").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ShareError>> SHARE_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ShareErrors").getter(ShareDetails.getter(ShareDetails::shareErrors)).setter(ShareDetails.setter(Builder::shareErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ShareError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_SHARES_FIELD, SHARE_ERRORS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> successfulShares;
    private final List<ShareError> shareErrors;

    private ShareDetails(BuilderImpl builder) {
        this.successfulShares = builder.successfulShares;
        this.shareErrors = builder.shareErrors;
    }

    public final boolean hasSuccessfulShares() {
        return this.successfulShares != null && !(this.successfulShares instanceof SdkAutoConstructList);
    }

    public final List<String> successfulShares() {
        return this.successfulShares;
    }

    public final boolean hasShareErrors() {
        return this.shareErrors != null && !(this.shareErrors instanceof SdkAutoConstructList);
    }

    public final List<ShareError> shareErrors() {
        return this.shareErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfulShares() ? this.successfulShares() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasShareErrors() ? this.shareErrors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShareDetails)) {
            return false;
        }
        ShareDetails other = (ShareDetails)obj;
        return this.hasSuccessfulShares() == other.hasSuccessfulShares() && Objects.equals(this.successfulShares(), other.successfulShares()) && this.hasShareErrors() == other.hasShareErrors() && Objects.equals(this.shareErrors(), other.shareErrors());
    }

    public final String toString() {
        return ToString.builder((String)"ShareDetails").add("SuccessfulShares", this.hasSuccessfulShares() ? this.successfulShares() : null).add("ShareErrors", this.hasShareErrors() ? this.shareErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuccessfulShares": {
                return Optional.ofNullable(clazz.cast(this.successfulShares()));
            }
            case "ShareErrors": {
                return Optional.ofNullable(clazz.cast(this.shareErrors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShareDetails, T> g) {
        return obj -> g.apply((ShareDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> successfulShares = DefaultSdkAutoConstructList.getInstance();
        private List<ShareError> shareErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ShareDetails model) {
            this.successfulShares(model.successfulShares);
            this.shareErrors(model.shareErrors);
        }

        public final Collection<String> getSuccessfulShares() {
            if (this.successfulShares instanceof SdkAutoConstructList) {
                return null;
            }
            return this.successfulShares;
        }

        public final void setSuccessfulShares(Collection<String> successfulShares) {
            this.successfulShares = SuccessfulSharesCopier.copy(successfulShares);
        }

        @Override
        @Transient
        public final Builder successfulShares(Collection<String> successfulShares) {
            this.successfulShares = SuccessfulSharesCopier.copy(successfulShares);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder successfulShares(String ... successfulShares) {
            this.successfulShares(Arrays.asList(successfulShares));
            return this;
        }

        public final List<ShareError.Builder> getShareErrors() {
            List<ShareError.Builder> result = ShareErrorsCopier.copyToBuilder(this.shareErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShareErrors(Collection<ShareError.BuilderImpl> shareErrors) {
            this.shareErrors = ShareErrorsCopier.copyFromBuilder(shareErrors);
        }

        @Override
        @Transient
        public final Builder shareErrors(Collection<ShareError> shareErrors) {
            this.shareErrors = ShareErrorsCopier.copy(shareErrors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder shareErrors(ShareError ... shareErrors) {
            this.shareErrors(Arrays.asList(shareErrors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder shareErrors(Consumer<ShareError.Builder> ... shareErrors) {
            this.shareErrors(Stream.of(shareErrors).map(c -> (ShareError)((ShareError.Builder)ShareError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ShareDetails build() {
            return new ShareDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ShareDetails> {
        public Builder successfulShares(Collection<String> var1);

        public Builder successfulShares(String ... var1);

        public Builder shareErrors(Collection<ShareError> var1);

        public Builder shareErrors(ShareError ... var1);

        public Builder shareErrors(Consumer<ShareError.Builder> ... var1);
    }
}

