/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PortfolioShareDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PortfolioShareDetail> {
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrincipalId").getter(PortfolioShareDetail.getter(PortfolioShareDetail::principalId)).setter(PortfolioShareDetail.setter(Builder::principalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(PortfolioShareDetail.getter(PortfolioShareDetail::typeAsString)).setter(PortfolioShareDetail.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Boolean> ACCEPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Accepted").getter(PortfolioShareDetail.getter(PortfolioShareDetail::accepted)).setter(PortfolioShareDetail.setter(Builder::accepted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accepted").build()}).build();
    private static final SdkField<Boolean> SHARE_TAG_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ShareTagOptions").getter(PortfolioShareDetail.getter(PortfolioShareDetail::shareTagOptions)).setter(PortfolioShareDetail.setter(Builder::shareTagOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareTagOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_ID_FIELD, TYPE_FIELD, ACCEPTED_FIELD, SHARE_TAG_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String principalId;
    private final String type;
    private final Boolean accepted;
    private final Boolean shareTagOptions;

    private PortfolioShareDetail(BuilderImpl builder) {
        this.principalId = builder.principalId;
        this.type = builder.type;
        this.accepted = builder.accepted;
        this.shareTagOptions = builder.shareTagOptions;
    }

    public final String principalId() {
        return this.principalId;
    }

    public final DescribePortfolioShareType type() {
        return DescribePortfolioShareType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Boolean accepted() {
        return this.accepted;
    }

    public final Boolean shareTagOptions() {
        return this.shareTagOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accepted());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareTagOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortfolioShareDetail)) {
            return false;
        }
        PortfolioShareDetail other = (PortfolioShareDetail)obj;
        return Objects.equals(this.principalId(), other.principalId()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.accepted(), other.accepted()) && Objects.equals(this.shareTagOptions(), other.shareTagOptions());
    }

    public final String toString() {
        return ToString.builder((String)"PortfolioShareDetail").add("PrincipalId", (Object)this.principalId()).add("Type", (Object)this.typeAsString()).add("Accepted", (Object)this.accepted()).add("ShareTagOptions", (Object)this.shareTagOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrincipalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Accepted": {
                return Optional.ofNullable(clazz.cast(this.accepted()));
            }
            case "ShareTagOptions": {
                return Optional.ofNullable(clazz.cast(this.shareTagOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PortfolioShareDetail, T> g) {
        return obj -> g.apply((PortfolioShareDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String principalId;
        private String type;
        private Boolean accepted;
        private Boolean shareTagOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(PortfolioShareDetail model) {
            this.principalId(model.principalId);
            this.type(model.type);
            this.accepted(model.accepted);
            this.shareTagOptions(model.shareTagOptions);
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DescribePortfolioShareType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Boolean getAccepted() {
            return this.accepted;
        }

        public final void setAccepted(Boolean accepted) {
            this.accepted = accepted;
        }

        @Override
        public final Builder accepted(Boolean accepted) {
            this.accepted = accepted;
            return this;
        }

        public final Boolean getShareTagOptions() {
            return this.shareTagOptions;
        }

        public final void setShareTagOptions(Boolean shareTagOptions) {
            this.shareTagOptions = shareTagOptions;
        }

        @Override
        public final Builder shareTagOptions(Boolean shareTagOptions) {
            this.shareTagOptions = shareTagOptions;
            return this;
        }

        public PortfolioShareDetail build() {
            return new PortfolioShareDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PortfolioShareDetail> {
        public Builder principalId(String var1);

        public Builder type(String var1);

        public Builder type(DescribePortfolioShareType var1);

        public Builder accepted(Boolean var1);

        public Builder shareTagOptions(Boolean var1);
    }
}

