/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProvisioningParametersRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, DescribeProvisioningParametersRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptLanguage").getter(DescribeProvisioningParametersRequest.getter(DescribeProvisioningParametersRequest::acceptLanguage)).setter(DescribeProvisioningParametersRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductId").getter(DescribeProvisioningParametersRequest.getter(DescribeProvisioningParametersRequest::productId)).setter(DescribeProvisioningParametersRequest.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductName").getter(DescribeProvisioningParametersRequest.getter(DescribeProvisioningParametersRequest::productName)).setter(DescribeProvisioningParametersRequest.setter(Builder::productName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningArtifactId").getter(DescribeProvisioningParametersRequest.getter(DescribeProvisioningParametersRequest::provisioningArtifactId)).setter(DescribeProvisioningParametersRequest.setter(Builder::provisioningArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningArtifactName").getter(DescribeProvisioningParametersRequest.getter(DescribeProvisioningParametersRequest::provisioningArtifactName)).setter(DescribeProvisioningParametersRequest.setter(Builder::provisioningArtifactName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactName").build()}).build();
    private static final SdkField<String> PATH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PathId").getter(DescribeProvisioningParametersRequest.getter(DescribeProvisioningParametersRequest::pathId)).setter(DescribeProvisioningParametersRequest.setter(Builder::pathId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathId").build()}).build();
    private static final SdkField<String> PATH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PathName").getter(DescribeProvisioningParametersRequest.getter(DescribeProvisioningParametersRequest::pathName)).setter(DescribeProvisioningParametersRequest.setter(Builder::pathName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, PRODUCT_ID_FIELD, PRODUCT_NAME_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, PROVISIONING_ARTIFACT_NAME_FIELD, PATH_ID_FIELD, PATH_NAME_FIELD));
    private final String acceptLanguage;
    private final String productId;
    private final String productName;
    private final String provisioningArtifactId;
    private final String provisioningArtifactName;
    private final String pathId;
    private final String pathName;

    private DescribeProvisioningParametersRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.productId = builder.productId;
        this.productName = builder.productName;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.provisioningArtifactName = builder.provisioningArtifactName;
        this.pathId = builder.pathId;
        this.pathName = builder.pathName;
    }

    public final String acceptLanguage() {
        return this.acceptLanguage;
    }

    public final String productId() {
        return this.productId;
    }

    public final String productName() {
        return this.productName;
    }

    public final String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public final String provisioningArtifactName() {
        return this.provisioningArtifactName;
    }

    public final String pathId() {
        return this.pathId;
    }

    public final String pathName() {
        return this.pathName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProvisioningParametersRequest)) {
            return false;
        }
        DescribeProvisioningParametersRequest other = (DescribeProvisioningParametersRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.productName(), other.productName()) && Objects.equals(this.provisioningArtifactId(), other.provisioningArtifactId()) && Objects.equals(this.provisioningArtifactName(), other.provisioningArtifactName()) && Objects.equals(this.pathId(), other.pathId()) && Objects.equals(this.pathName(), other.pathName());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeProvisioningParametersRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("ProductId", (Object)this.productId()).add("ProductName", (Object)this.productName()).add("ProvisioningArtifactId", (Object)this.provisioningArtifactId()).add("ProvisioningArtifactName", (Object)this.provisioningArtifactName()).add("PathId", (Object)this.pathId()).add("PathName", (Object)this.pathName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "ProductName": {
                return Optional.ofNullable(clazz.cast(this.productName()));
            }
            case "ProvisioningArtifactId": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactId()));
            }
            case "ProvisioningArtifactName": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactName()));
            }
            case "PathId": {
                return Optional.ofNullable(clazz.cast(this.pathId()));
            }
            case "PathName": {
                return Optional.ofNullable(clazz.cast(this.pathName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProvisioningParametersRequest, T> g) {
        return obj -> g.apply((DescribeProvisioningParametersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String productId;
        private String productName;
        private String provisioningArtifactId;
        private String provisioningArtifactName;
        private String pathId;
        private String pathName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProvisioningParametersRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.productId(model.productId);
            this.productName(model.productName);
            this.provisioningArtifactId(model.provisioningArtifactId);
            this.provisioningArtifactName(model.provisioningArtifactName);
            this.pathId(model.pathId);
            this.pathName(model.pathName);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        @Transient
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getProductId() {
            return this.productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        @Transient
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getProductName() {
            return this.productName;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        @Override
        @Transient
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        @Override
        @Transient
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final String getProvisioningArtifactName() {
            return this.provisioningArtifactName;
        }

        public final void setProvisioningArtifactName(String provisioningArtifactName) {
            this.provisioningArtifactName = provisioningArtifactName;
        }

        @Override
        @Transient
        public final Builder provisioningArtifactName(String provisioningArtifactName) {
            this.provisioningArtifactName = provisioningArtifactName;
            return this;
        }

        public final String getPathId() {
            return this.pathId;
        }

        public final void setPathId(String pathId) {
            this.pathId = pathId;
        }

        @Override
        @Transient
        public final Builder pathId(String pathId) {
            this.pathId = pathId;
            return this;
        }

        public final String getPathName() {
            return this.pathName;
        }

        public final void setPathName(String pathName) {
            this.pathName = pathName;
        }

        @Override
        @Transient
        public final Builder pathName(String pathName) {
            this.pathName = pathName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeProvisioningParametersRequest build() {
            return new DescribeProvisioningParametersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProvisioningParametersRequest> {
        public Builder acceptLanguage(String var1);

        public Builder productId(String var1);

        public Builder productName(String var1);

        public Builder provisioningArtifactId(String var1);

        public Builder provisioningArtifactName(String var1);

        public Builder pathId(String var1);

        public Builder pathName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

