/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.StackSetAccountsCopier;
import software.amazon.awssdk.services.servicecatalog.model.StackSetOperationType;
import software.amazon.awssdk.services.servicecatalog.model.StackSetRegionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProvisioningPreferences
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateProvisioningPreferences> {
    private static final SdkField<List<String>> STACK_SET_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StackSetAccounts").getter(UpdateProvisioningPreferences.getter(UpdateProvisioningPreferences::stackSetAccounts)).setter(UpdateProvisioningPreferences.setter(Builder::stackSetAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STACK_SET_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StackSetRegions").getter(UpdateProvisioningPreferences.getter(UpdateProvisioningPreferences::stackSetRegions)).setter(UpdateProvisioningPreferences.setter(Builder::stackSetRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> STACK_SET_FAILURE_TOLERANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StackSetFailureToleranceCount").getter(UpdateProvisioningPreferences.getter(UpdateProvisioningPreferences::stackSetFailureToleranceCount)).setter(UpdateProvisioningPreferences.setter(Builder::stackSetFailureToleranceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetFailureToleranceCount").build()}).build();
    private static final SdkField<Integer> STACK_SET_FAILURE_TOLERANCE_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StackSetFailureTolerancePercentage").getter(UpdateProvisioningPreferences.getter(UpdateProvisioningPreferences::stackSetFailureTolerancePercentage)).setter(UpdateProvisioningPreferences.setter(Builder::stackSetFailureTolerancePercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetFailureTolerancePercentage").build()}).build();
    private static final SdkField<Integer> STACK_SET_MAX_CONCURRENCY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StackSetMaxConcurrencyCount").getter(UpdateProvisioningPreferences.getter(UpdateProvisioningPreferences::stackSetMaxConcurrencyCount)).setter(UpdateProvisioningPreferences.setter(Builder::stackSetMaxConcurrencyCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetMaxConcurrencyCount").build()}).build();
    private static final SdkField<Integer> STACK_SET_MAX_CONCURRENCY_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StackSetMaxConcurrencyPercentage").getter(UpdateProvisioningPreferences.getter(UpdateProvisioningPreferences::stackSetMaxConcurrencyPercentage)).setter(UpdateProvisioningPreferences.setter(Builder::stackSetMaxConcurrencyPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetMaxConcurrencyPercentage").build()}).build();
    private static final SdkField<String> STACK_SET_OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackSetOperationType").getter(UpdateProvisioningPreferences.getter(UpdateProvisioningPreferences::stackSetOperationTypeAsString)).setter(UpdateProvisioningPreferences.setter(Builder::stackSetOperationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetOperationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_ACCOUNTS_FIELD, STACK_SET_REGIONS_FIELD, STACK_SET_FAILURE_TOLERANCE_COUNT_FIELD, STACK_SET_FAILURE_TOLERANCE_PERCENTAGE_FIELD, STACK_SET_MAX_CONCURRENCY_COUNT_FIELD, STACK_SET_MAX_CONCURRENCY_PERCENTAGE_FIELD, STACK_SET_OPERATION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> stackSetAccounts;
    private final List<String> stackSetRegions;
    private final Integer stackSetFailureToleranceCount;
    private final Integer stackSetFailureTolerancePercentage;
    private final Integer stackSetMaxConcurrencyCount;
    private final Integer stackSetMaxConcurrencyPercentage;
    private final String stackSetOperationType;

    private UpdateProvisioningPreferences(BuilderImpl builder) {
        this.stackSetAccounts = builder.stackSetAccounts;
        this.stackSetRegions = builder.stackSetRegions;
        this.stackSetFailureToleranceCount = builder.stackSetFailureToleranceCount;
        this.stackSetFailureTolerancePercentage = builder.stackSetFailureTolerancePercentage;
        this.stackSetMaxConcurrencyCount = builder.stackSetMaxConcurrencyCount;
        this.stackSetMaxConcurrencyPercentage = builder.stackSetMaxConcurrencyPercentage;
        this.stackSetOperationType = builder.stackSetOperationType;
    }

    public final boolean hasStackSetAccounts() {
        return this.stackSetAccounts != null && !(this.stackSetAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> stackSetAccounts() {
        return this.stackSetAccounts;
    }

    public final boolean hasStackSetRegions() {
        return this.stackSetRegions != null && !(this.stackSetRegions instanceof SdkAutoConstructList);
    }

    public final List<String> stackSetRegions() {
        return this.stackSetRegions;
    }

    public final Integer stackSetFailureToleranceCount() {
        return this.stackSetFailureToleranceCount;
    }

    public final Integer stackSetFailureTolerancePercentage() {
        return this.stackSetFailureTolerancePercentage;
    }

    public final Integer stackSetMaxConcurrencyCount() {
        return this.stackSetMaxConcurrencyCount;
    }

    public final Integer stackSetMaxConcurrencyPercentage() {
        return this.stackSetMaxConcurrencyPercentage;
    }

    public final StackSetOperationType stackSetOperationType() {
        return StackSetOperationType.fromValue(this.stackSetOperationType);
    }

    public final String stackSetOperationTypeAsString() {
        return this.stackSetOperationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStackSetAccounts() ? this.stackSetAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStackSetRegions() ? this.stackSetRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetFailureToleranceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetFailureTolerancePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetMaxConcurrencyCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetMaxConcurrencyPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetOperationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProvisioningPreferences)) {
            return false;
        }
        UpdateProvisioningPreferences other = (UpdateProvisioningPreferences)obj;
        return this.hasStackSetAccounts() == other.hasStackSetAccounts() && Objects.equals(this.stackSetAccounts(), other.stackSetAccounts()) && this.hasStackSetRegions() == other.hasStackSetRegions() && Objects.equals(this.stackSetRegions(), other.stackSetRegions()) && Objects.equals(this.stackSetFailureToleranceCount(), other.stackSetFailureToleranceCount()) && Objects.equals(this.stackSetFailureTolerancePercentage(), other.stackSetFailureTolerancePercentage()) && Objects.equals(this.stackSetMaxConcurrencyCount(), other.stackSetMaxConcurrencyCount()) && Objects.equals(this.stackSetMaxConcurrencyPercentage(), other.stackSetMaxConcurrencyPercentage()) && Objects.equals(this.stackSetOperationTypeAsString(), other.stackSetOperationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProvisioningPreferences").add("StackSetAccounts", this.hasStackSetAccounts() ? this.stackSetAccounts() : null).add("StackSetRegions", this.hasStackSetRegions() ? this.stackSetRegions() : null).add("StackSetFailureToleranceCount", (Object)this.stackSetFailureToleranceCount()).add("StackSetFailureTolerancePercentage", (Object)this.stackSetFailureTolerancePercentage()).add("StackSetMaxConcurrencyCount", (Object)this.stackSetMaxConcurrencyCount()).add("StackSetMaxConcurrencyPercentage", (Object)this.stackSetMaxConcurrencyPercentage()).add("StackSetOperationType", (Object)this.stackSetOperationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSetAccounts": {
                return Optional.ofNullable(clazz.cast(this.stackSetAccounts()));
            }
            case "StackSetRegions": {
                return Optional.ofNullable(clazz.cast(this.stackSetRegions()));
            }
            case "StackSetFailureToleranceCount": {
                return Optional.ofNullable(clazz.cast(this.stackSetFailureToleranceCount()));
            }
            case "StackSetFailureTolerancePercentage": {
                return Optional.ofNullable(clazz.cast(this.stackSetFailureTolerancePercentage()));
            }
            case "StackSetMaxConcurrencyCount": {
                return Optional.ofNullable(clazz.cast(this.stackSetMaxConcurrencyCount()));
            }
            case "StackSetMaxConcurrencyPercentage": {
                return Optional.ofNullable(clazz.cast(this.stackSetMaxConcurrencyPercentage()));
            }
            case "StackSetOperationType": {
                return Optional.ofNullable(clazz.cast(this.stackSetOperationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProvisioningPreferences, T> g) {
        return obj -> g.apply((UpdateProvisioningPreferences)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> stackSetAccounts = DefaultSdkAutoConstructList.getInstance();
        private List<String> stackSetRegions = DefaultSdkAutoConstructList.getInstance();
        private Integer stackSetFailureToleranceCount;
        private Integer stackSetFailureTolerancePercentage;
        private Integer stackSetMaxConcurrencyCount;
        private Integer stackSetMaxConcurrencyPercentage;
        private String stackSetOperationType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProvisioningPreferences model) {
            this.stackSetAccounts(model.stackSetAccounts);
            this.stackSetRegions(model.stackSetRegions);
            this.stackSetFailureToleranceCount(model.stackSetFailureToleranceCount);
            this.stackSetFailureTolerancePercentage(model.stackSetFailureTolerancePercentage);
            this.stackSetMaxConcurrencyCount(model.stackSetMaxConcurrencyCount);
            this.stackSetMaxConcurrencyPercentage(model.stackSetMaxConcurrencyPercentage);
            this.stackSetOperationType(model.stackSetOperationType);
        }

        public final Collection<String> getStackSetAccounts() {
            if (this.stackSetAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stackSetAccounts;
        }

        @Override
        public final Builder stackSetAccounts(Collection<String> stackSetAccounts) {
            this.stackSetAccounts = StackSetAccountsCopier.copy(stackSetAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackSetAccounts(String ... stackSetAccounts) {
            this.stackSetAccounts(Arrays.asList(stackSetAccounts));
            return this;
        }

        public final void setStackSetAccounts(Collection<String> stackSetAccounts) {
            this.stackSetAccounts = StackSetAccountsCopier.copy(stackSetAccounts);
        }

        public final Collection<String> getStackSetRegions() {
            if (this.stackSetRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stackSetRegions;
        }

        @Override
        public final Builder stackSetRegions(Collection<String> stackSetRegions) {
            this.stackSetRegions = StackSetRegionsCopier.copy(stackSetRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackSetRegions(String ... stackSetRegions) {
            this.stackSetRegions(Arrays.asList(stackSetRegions));
            return this;
        }

        public final void setStackSetRegions(Collection<String> stackSetRegions) {
            this.stackSetRegions = StackSetRegionsCopier.copy(stackSetRegions);
        }

        public final Integer getStackSetFailureToleranceCount() {
            return this.stackSetFailureToleranceCount;
        }

        @Override
        public final Builder stackSetFailureToleranceCount(Integer stackSetFailureToleranceCount) {
            this.stackSetFailureToleranceCount = stackSetFailureToleranceCount;
            return this;
        }

        public final void setStackSetFailureToleranceCount(Integer stackSetFailureToleranceCount) {
            this.stackSetFailureToleranceCount = stackSetFailureToleranceCount;
        }

        public final Integer getStackSetFailureTolerancePercentage() {
            return this.stackSetFailureTolerancePercentage;
        }

        @Override
        public final Builder stackSetFailureTolerancePercentage(Integer stackSetFailureTolerancePercentage) {
            this.stackSetFailureTolerancePercentage = stackSetFailureTolerancePercentage;
            return this;
        }

        public final void setStackSetFailureTolerancePercentage(Integer stackSetFailureTolerancePercentage) {
            this.stackSetFailureTolerancePercentage = stackSetFailureTolerancePercentage;
        }

        public final Integer getStackSetMaxConcurrencyCount() {
            return this.stackSetMaxConcurrencyCount;
        }

        @Override
        public final Builder stackSetMaxConcurrencyCount(Integer stackSetMaxConcurrencyCount) {
            this.stackSetMaxConcurrencyCount = stackSetMaxConcurrencyCount;
            return this;
        }

        public final void setStackSetMaxConcurrencyCount(Integer stackSetMaxConcurrencyCount) {
            this.stackSetMaxConcurrencyCount = stackSetMaxConcurrencyCount;
        }

        public final Integer getStackSetMaxConcurrencyPercentage() {
            return this.stackSetMaxConcurrencyPercentage;
        }

        @Override
        public final Builder stackSetMaxConcurrencyPercentage(Integer stackSetMaxConcurrencyPercentage) {
            this.stackSetMaxConcurrencyPercentage = stackSetMaxConcurrencyPercentage;
            return this;
        }

        public final void setStackSetMaxConcurrencyPercentage(Integer stackSetMaxConcurrencyPercentage) {
            this.stackSetMaxConcurrencyPercentage = stackSetMaxConcurrencyPercentage;
        }

        public final String getStackSetOperationType() {
            return this.stackSetOperationType;
        }

        @Override
        public final Builder stackSetOperationType(String stackSetOperationType) {
            this.stackSetOperationType = stackSetOperationType;
            return this;
        }

        @Override
        public final Builder stackSetOperationType(StackSetOperationType stackSetOperationType) {
            this.stackSetOperationType(stackSetOperationType == null ? null : stackSetOperationType.toString());
            return this;
        }

        public final void setStackSetOperationType(String stackSetOperationType) {
            this.stackSetOperationType = stackSetOperationType;
        }

        public UpdateProvisioningPreferences build() {
            return new UpdateProvisioningPreferences(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateProvisioningPreferences> {
        public Builder stackSetAccounts(Collection<String> var1);

        public Builder stackSetAccounts(String ... var1);

        public Builder stackSetRegions(Collection<String> var1);

        public Builder stackSetRegions(String ... var1);

        public Builder stackSetFailureToleranceCount(Integer var1);

        public Builder stackSetFailureTolerancePercentage(Integer var1);

        public Builder stackSetMaxConcurrencyCount(Integer var1);

        public Builder stackSetMaxConcurrencyPercentage(Integer var1);

        public Builder stackSetOperationType(String var1);

        public Builder stackSetOperationType(StackSetOperationType var1);
    }
}

