/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewFiltersCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSortBy;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.services.servicecatalog.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchProductsRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, SearchProductsRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptLanguage").getter(SearchProductsRequest.getter(SearchProductsRequest::acceptLanguage)).setter(SearchProductsRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<Map<String, List<String>>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Filters").getter(SearchProductsRequest.getter(SearchProductsRequest::filtersAsStrings)).setter(SearchProductsRequest.setter(Builder::filtersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSize").getter(SearchProductsRequest.getter(SearchProductsRequest::pageSize)).setter(SearchProductsRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortBy").getter(SearchProductsRequest.getter(SearchProductsRequest::sortByAsString)).setter(SearchProductsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(SearchProductsRequest.getter(SearchProductsRequest::sortOrderAsString)).setter(SearchProductsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PageToken").getter(SearchProductsRequest.getter(SearchProductsRequest::pageToken)).setter(SearchProductsRequest.setter(Builder::pageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, FILTERS_FIELD, PAGE_SIZE_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, PAGE_TOKEN_FIELD));
    private final String acceptLanguage;
    private final Map<String, List<String>> filters;
    private final Integer pageSize;
    private final String sortBy;
    private final String sortOrder;
    private final String pageToken;

    private SearchProductsRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.filters = builder.filters;
        this.pageSize = builder.pageSize;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.pageToken = builder.pageToken;
    }

    public final String acceptLanguage() {
        return this.acceptLanguage;
    }

    public final Map<ProductViewFilterBy, List<String>> filters() {
        return ProductViewFiltersCopier.copyStringToEnum(this.filters);
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> filtersAsStrings() {
        return this.filters;
    }

    public final Integer pageSize() {
        return this.pageSize;
    }

    public final ProductViewSortBy sortBy() {
        return ProductViewSortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final String pageToken() {
        return this.pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filtersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProductsRequest)) {
            return false;
        }
        SearchProductsRequest other = (SearchProductsRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filtersAsStrings(), other.filtersAsStrings()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.pageToken(), other.pageToken());
    }

    public final String toString() {
        return ToString.builder((String)"SearchProductsRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("Filters", this.hasFilters() ? this.filtersAsStrings() : null).add("PageSize", (Object)this.pageSize()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("PageToken", (Object)this.pageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filtersAsStrings()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "PageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchProductsRequest, T> g) {
        return obj -> g.apply((SearchProductsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private Map<String, List<String>> filters = DefaultSdkAutoConstructMap.getInstance();
        private Integer pageSize;
        private String sortBy;
        private String sortOrder;
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchProductsRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.filtersWithStrings(model.filters);
            this.pageSize(model.pageSize);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.pageToken(model.pageToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final Map<String, ? extends Collection<String>> getFilters() {
            if (this.filters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.filters;
        }

        @Override
        public final Builder filtersWithStrings(Map<String, ? extends Collection<String>> filters) {
            this.filters = ProductViewFiltersCopier.copy(filters);
            return this;
        }

        @Override
        public final Builder filters(Map<ProductViewFilterBy, ? extends Collection<String>> filters) {
            this.filters = ProductViewFiltersCopier.copyEnumToString(filters);
            return this;
        }

        public final void setFilters(Map<String, ? extends Collection<String>> filters) {
            this.filters = ProductViewFiltersCopier.copy(filters);
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ProductViewSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchProductsRequest build() {
            return new SearchProductsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchProductsRequest> {
        public Builder acceptLanguage(String var1);

        public Builder filtersWithStrings(Map<String, ? extends Collection<String>> var1);

        public Builder filters(Map<ProductViewFilterBy, ? extends Collection<String>> var1);

        public Builder pageSize(Integer var1);

        public Builder sortBy(String var1);

        public Builder sortBy(ProductViewSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder pageToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

