/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewAggregationValue;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewAggregationsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSummariesCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSummary;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchProductsResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, SearchProductsResponse> {
    private static final SdkField<List<ProductViewSummary>> PRODUCT_VIEW_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductViewSummaries").getter(SearchProductsResponse.getter(SearchProductsResponse::productViewSummaries)).setter(SearchProductsResponse.setter(Builder::productViewSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductViewSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductViewSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<ProductViewAggregationValue>>> PRODUCT_VIEW_AGGREGATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ProductViewAggregations").getter(SearchProductsResponse.getter(SearchProductsResponse::productViewAggregations)).setter(SearchProductsResponse.setter(Builder::productViewAggregations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductViewAggregations").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductViewAggregationValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(SearchProductsResponse.getter(SearchProductsResponse::nextPageToken)).setter(SearchProductsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_VIEW_SUMMARIES_FIELD, PRODUCT_VIEW_AGGREGATIONS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<ProductViewSummary> productViewSummaries;
    private final Map<String, List<ProductViewAggregationValue>> productViewAggregations;
    private final String nextPageToken;

    private SearchProductsResponse(BuilderImpl builder) {
        super(builder);
        this.productViewSummaries = builder.productViewSummaries;
        this.productViewAggregations = builder.productViewAggregations;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasProductViewSummaries() {
        return this.productViewSummaries != null && !(this.productViewSummaries instanceof SdkAutoConstructList);
    }

    public final List<ProductViewSummary> productViewSummaries() {
        return this.productViewSummaries;
    }

    public final boolean hasProductViewAggregations() {
        return this.productViewAggregations != null && !(this.productViewAggregations instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<ProductViewAggregationValue>> productViewAggregations() {
        return this.productViewAggregations;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductViewSummaries() ? this.productViewSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductViewAggregations() ? this.productViewAggregations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProductsResponse)) {
            return false;
        }
        SearchProductsResponse other = (SearchProductsResponse)((Object)obj);
        return this.hasProductViewSummaries() == other.hasProductViewSummaries() && Objects.equals(this.productViewSummaries(), other.productViewSummaries()) && this.hasProductViewAggregations() == other.hasProductViewAggregations() && Objects.equals(this.productViewAggregations(), other.productViewAggregations()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"SearchProductsResponse").add("ProductViewSummaries", this.hasProductViewSummaries() ? this.productViewSummaries() : null).add("ProductViewAggregations", this.hasProductViewAggregations() ? this.productViewAggregations() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductViewSummaries": {
                return Optional.ofNullable(clazz.cast(this.productViewSummaries()));
            }
            case "ProductViewAggregations": {
                return Optional.ofNullable(clazz.cast(this.productViewAggregations()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchProductsResponse, T> g) {
        return obj -> g.apply((SearchProductsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<ProductViewSummary> productViewSummaries = DefaultSdkAutoConstructList.getInstance();
        private Map<String, List<ProductViewAggregationValue>> productViewAggregations = DefaultSdkAutoConstructMap.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchProductsResponse model) {
            super(model);
            this.productViewSummaries(model.productViewSummaries);
            this.productViewAggregations(model.productViewAggregations);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<ProductViewSummary.Builder> getProductViewSummaries() {
            if (this.productViewSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.productViewSummaries != null ? (Collection)this.productViewSummaries.stream().map(ProductViewSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productViewSummaries(Collection<ProductViewSummary> productViewSummaries) {
            this.productViewSummaries = ProductViewSummariesCopier.copy(productViewSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productViewSummaries(ProductViewSummary ... productViewSummaries) {
            this.productViewSummaries(Arrays.asList(productViewSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productViewSummaries(Consumer<ProductViewSummary.Builder> ... productViewSummaries) {
            this.productViewSummaries(Stream.of(productViewSummaries).map(c -> (ProductViewSummary)((ProductViewSummary.Builder)ProductViewSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProductViewSummaries(Collection<ProductViewSummary.BuilderImpl> productViewSummaries) {
            this.productViewSummaries = ProductViewSummariesCopier.copyFromBuilder(productViewSummaries);
        }

        public final Map<String, ? extends Collection<ProductViewAggregationValue>> getProductViewAggregations() {
            if (this.productViewAggregations instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.productViewAggregations;
        }

        @Override
        public final Builder productViewAggregations(Map<String, ? extends Collection<ProductViewAggregationValue>> productViewAggregations) {
            this.productViewAggregations = ProductViewAggregationsCopier.copy(productViewAggregations);
            return this;
        }

        public final void setProductViewAggregations(Map<String, ? extends Collection<ProductViewAggregationValue>> productViewAggregations) {
            this.productViewAggregations = ProductViewAggregationsCopier.copy(productViewAggregations);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public SearchProductsResponse build() {
            return new SearchProductsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchProductsResponse> {
        public Builder productViewSummaries(Collection<ProductViewSummary> var1);

        public Builder productViewSummaries(ProductViewSummary ... var1);

        public Builder productViewSummaries(Consumer<ProductViewSummary.Builder> ... var1);

        public Builder productViewAggregations(Map<String, ? extends Collection<ProductViewAggregationValue>> var1);

        public Builder nextPageToken(String var1);
    }
}

