/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductDetail;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductDetailsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScanProvisionedProductsResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ScanProvisionedProductsResponse> {
    private static final SdkField<List<ProvisionedProductDetail>> PROVISIONED_PRODUCTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProvisionedProducts").getter(ScanProvisionedProductsResponse.getter(ScanProvisionedProductsResponse::provisionedProducts)).setter(ScanProvisionedProductsResponse.setter(Builder::provisionedProducts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProducts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProvisionedProductDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(ScanProvisionedProductsResponse.getter(ScanProvisionedProductsResponse::nextPageToken)).setter(ScanProvisionedProductsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONED_PRODUCTS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<ProvisionedProductDetail> provisionedProducts;
    private final String nextPageToken;

    private ScanProvisionedProductsResponse(BuilderImpl builder) {
        super(builder);
        this.provisionedProducts = builder.provisionedProducts;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasProvisionedProducts() {
        return this.provisionedProducts != null && !(this.provisionedProducts instanceof SdkAutoConstructList);
    }

    public final List<ProvisionedProductDetail> provisionedProducts() {
        return this.provisionedProducts;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisionedProducts() ? this.provisionedProducts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanProvisionedProductsResponse)) {
            return false;
        }
        ScanProvisionedProductsResponse other = (ScanProvisionedProductsResponse)((Object)obj);
        return this.hasProvisionedProducts() == other.hasProvisionedProducts() && Objects.equals(this.provisionedProducts(), other.provisionedProducts()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"ScanProvisionedProductsResponse").add("ProvisionedProducts", this.hasProvisionedProducts() ? this.provisionedProducts() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionedProducts": {
                return Optional.ofNullable(clazz.cast(this.provisionedProducts()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScanProvisionedProductsResponse, T> g) {
        return obj -> g.apply((ScanProvisionedProductsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<ProvisionedProductDetail> provisionedProducts = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanProvisionedProductsResponse model) {
            super(model);
            this.provisionedProducts(model.provisionedProducts);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<ProvisionedProductDetail.Builder> getProvisionedProducts() {
            if (this.provisionedProducts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.provisionedProducts != null ? (Collection)this.provisionedProducts.stream().map(ProvisionedProductDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisionedProducts(Collection<ProvisionedProductDetail> provisionedProducts) {
            this.provisionedProducts = ProvisionedProductDetailsCopier.copy(provisionedProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedProducts(ProvisionedProductDetail ... provisionedProducts) {
            this.provisionedProducts(Arrays.asList(provisionedProducts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedProducts(Consumer<ProvisionedProductDetail.Builder> ... provisionedProducts) {
            this.provisionedProducts(Stream.of(provisionedProducts).map(c -> (ProvisionedProductDetail)((ProvisionedProductDetail.Builder)ProvisionedProductDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisionedProducts(Collection<ProvisionedProductDetail.BuilderImpl> provisionedProducts) {
            this.provisionedProducts = ProvisionedProductDetailsCopier.copyFromBuilder(provisionedProducts);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ScanProvisionedProductsResponse build() {
            return new ScanProvisionedProductsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ScanProvisionedProductsResponse> {
        public Builder provisionedProducts(Collection<ProvisionedProductDetail> var1);

        public Builder provisionedProducts(ProvisionedProductDetail ... var1);

        public Builder provisionedProducts(Consumer<ProvisionedProductDetail.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

