/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.AccessStatus;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAwsOrganizationsAccessStatusResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, GetAwsOrganizationsAccessStatusResponse> {
    private static final SdkField<String> ACCESS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessStatus").getter(GetAwsOrganizationsAccessStatusResponse.getter(GetAwsOrganizationsAccessStatusResponse::accessStatusAsString)).setter(GetAwsOrganizationsAccessStatusResponse.setter(Builder::accessStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_STATUS_FIELD));
    private final String accessStatus;

    private GetAwsOrganizationsAccessStatusResponse(BuilderImpl builder) {
        super(builder);
        this.accessStatus = builder.accessStatus;
    }

    public AccessStatus accessStatus() {
        return AccessStatus.fromValue(this.accessStatus);
    }

    public String accessStatusAsString() {
        return this.accessStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAwsOrganizationsAccessStatusResponse)) {
            return false;
        }
        GetAwsOrganizationsAccessStatusResponse other = (GetAwsOrganizationsAccessStatusResponse)((Object)obj);
        return Objects.equals(this.accessStatusAsString(), other.accessStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetAwsOrganizationsAccessStatusResponse").add("AccessStatus", (Object)this.accessStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessStatus": {
                return Optional.ofNullable(clazz.cast(this.accessStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAwsOrganizationsAccessStatusResponse, T> g) {
        return obj -> g.apply((GetAwsOrganizationsAccessStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private String accessStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAwsOrganizationsAccessStatusResponse model) {
            super(model);
            this.accessStatus(model.accessStatus);
        }

        public final String getAccessStatus() {
            return this.accessStatus;
        }

        @Override
        public final Builder accessStatus(String accessStatus) {
            this.accessStatus = accessStatus;
            return this;
        }

        @Override
        public final Builder accessStatus(AccessStatus accessStatus) {
            this.accessStatus(accessStatus == null ? null : accessStatus.toString());
            return this;
        }

        public final void setAccessStatus(String accessStatus) {
            this.accessStatus = accessStatus;
        }

        @Override
        public GetAwsOrganizationsAccessStatusResponse build() {
            return new GetAwsOrganizationsAccessStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAwsOrganizationsAccessStatusResponse> {
        public Builder accessStatus(String var1);

        public Builder accessStatus(AccessStatus var1);
    }
}

