/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewDetail;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactDetail;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProductResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, CreateProductResponse> {
    private static final SdkField<ProductViewDetail> PRODUCT_VIEW_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProductViewDetail").getter(CreateProductResponse.getter(CreateProductResponse::productViewDetail)).setter(CreateProductResponse.setter(Builder::productViewDetail)).constructor(ProductViewDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductViewDetail").build()}).build();
    private static final SdkField<ProvisioningArtifactDetail> PROVISIONING_ARTIFACT_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisioningArtifactDetail").getter(CreateProductResponse.getter(CreateProductResponse::provisioningArtifactDetail)).setter(CreateProductResponse.setter(Builder::provisioningArtifactDetail)).constructor(ProvisioningArtifactDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactDetail").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateProductResponse.getter(CreateProductResponse::tags)).setter(CreateProductResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_VIEW_DETAIL_FIELD, PROVISIONING_ARTIFACT_DETAIL_FIELD, TAGS_FIELD));
    private final ProductViewDetail productViewDetail;
    private final ProvisioningArtifactDetail provisioningArtifactDetail;
    private final List<Tag> tags;

    private CreateProductResponse(BuilderImpl builder) {
        super(builder);
        this.productViewDetail = builder.productViewDetail;
        this.provisioningArtifactDetail = builder.provisioningArtifactDetail;
        this.tags = builder.tags;
    }

    public ProductViewDetail productViewDetail() {
        return this.productViewDetail;
    }

    public ProvisioningArtifactDetail provisioningArtifactDetail() {
        return this.provisioningArtifactDetail;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.productViewDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProductResponse)) {
            return false;
        }
        CreateProductResponse other = (CreateProductResponse)((Object)obj);
        return Objects.equals(this.productViewDetail(), other.productViewDetail()) && Objects.equals(this.provisioningArtifactDetail(), other.provisioningArtifactDetail()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateProductResponse").add("ProductViewDetail", (Object)this.productViewDetail()).add("ProvisioningArtifactDetail", (Object)this.provisioningArtifactDetail()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductViewDetail": {
                return Optional.ofNullable(clazz.cast(this.productViewDetail()));
            }
            case "ProvisioningArtifactDetail": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactDetail()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProductResponse, T> g) {
        return obj -> g.apply((CreateProductResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private ProductViewDetail productViewDetail;
        private ProvisioningArtifactDetail provisioningArtifactDetail;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProductResponse model) {
            super(model);
            this.productViewDetail(model.productViewDetail);
            this.provisioningArtifactDetail(model.provisioningArtifactDetail);
            this.tags(model.tags);
        }

        public final ProductViewDetail.Builder getProductViewDetail() {
            return this.productViewDetail != null ? this.productViewDetail.toBuilder() : null;
        }

        @Override
        public final Builder productViewDetail(ProductViewDetail productViewDetail) {
            this.productViewDetail = productViewDetail;
            return this;
        }

        public final void setProductViewDetail(ProductViewDetail.BuilderImpl productViewDetail) {
            this.productViewDetail = productViewDetail != null ? productViewDetail.build() : null;
        }

        public final ProvisioningArtifactDetail.Builder getProvisioningArtifactDetail() {
            return this.provisioningArtifactDetail != null ? this.provisioningArtifactDetail.toBuilder() : null;
        }

        @Override
        public final Builder provisioningArtifactDetail(ProvisioningArtifactDetail provisioningArtifactDetail) {
            this.provisioningArtifactDetail = provisioningArtifactDetail;
            return this;
        }

        public final void setProvisioningArtifactDetail(ProvisioningArtifactDetail.BuilderImpl provisioningArtifactDetail) {
            this.provisioningArtifactDetail = provisioningArtifactDetail != null ? provisioningArtifactDetail.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public CreateProductResponse build() {
            return new CreateProductResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProductResponse> {
        public Builder productViewDetail(ProductViewDetail var1);

        default public Builder productViewDetail(Consumer<ProductViewDetail.Builder> productViewDetail) {
            return this.productViewDetail((ProductViewDetail)((ProductViewDetail.Builder)ProductViewDetail.builder().applyMutation(productViewDetail)).build());
        }

        public Builder provisioningArtifactDetail(ProvisioningArtifactDetail var1);

        default public Builder provisioningArtifactDetail(Consumer<ProvisioningArtifactDetail.Builder> provisioningArtifactDetail) {
            return this.provisioningArtifactDetail((ProvisioningArtifactDetail)((ProvisioningArtifactDetail.Builder)ProvisioningArtifactDetail.builder().applyMutation(provisioningArtifactDetail)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

