/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.AddTagsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagKeysCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePortfolioRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, UpdatePortfolioRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptLanguage").getter(UpdatePortfolioRequest.getter(UpdatePortfolioRequest::acceptLanguage)).setter(UpdatePortfolioRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdatePortfolioRequest.getter(UpdatePortfolioRequest::id)).setter(UpdatePortfolioRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(UpdatePortfolioRequest.getter(UpdatePortfolioRequest::displayName)).setter(UpdatePortfolioRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdatePortfolioRequest.getter(UpdatePortfolioRequest::description)).setter(UpdatePortfolioRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProviderName").getter(UpdatePortfolioRequest.getter(UpdatePortfolioRequest::providerName)).setter(UpdatePortfolioRequest.setter(Builder::providerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderName").build()}).build();
    private static final SdkField<List<Tag>> ADD_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddTags").getter(UpdatePortfolioRequest.getter(UpdatePortfolioRequest::addTags)).setter(UpdatePortfolioRequest.setter(Builder::addTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveTags").getter(UpdatePortfolioRequest.getter(UpdatePortfolioRequest::removeTags)).setter(UpdatePortfolioRequest.setter(Builder::removeTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, ID_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, PROVIDER_NAME_FIELD, ADD_TAGS_FIELD, REMOVE_TAGS_FIELD));
    private final String acceptLanguage;
    private final String id;
    private final String displayName;
    private final String description;
    private final String providerName;
    private final List<Tag> addTags;
    private final List<String> removeTags;

    private UpdatePortfolioRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.id = builder.id;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.providerName = builder.providerName;
        this.addTags = builder.addTags;
        this.removeTags = builder.removeTags;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String id() {
        return this.id;
    }

    public String displayName() {
        return this.displayName;
    }

    public String description() {
        return this.description;
    }

    public String providerName() {
        return this.providerName;
    }

    public boolean hasAddTags() {
        return this.addTags != null && !(this.addTags instanceof SdkAutoConstructList);
    }

    public List<Tag> addTags() {
        return this.addTags;
    }

    public boolean hasRemoveTags() {
        return this.removeTags != null && !(this.removeTags instanceof SdkAutoConstructList);
    }

    public List<String> removeTags() {
        return this.removeTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.addTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeTags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePortfolioRequest)) {
            return false;
        }
        UpdatePortfolioRequest other = (UpdatePortfolioRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.providerName(), other.providerName()) && Objects.equals(this.addTags(), other.addTags()) && Objects.equals(this.removeTags(), other.removeTags());
    }

    public String toString() {
        return ToString.builder((String)"UpdatePortfolioRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("Id", (Object)this.id()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)this.description()).add("ProviderName", (Object)this.providerName()).add("AddTags", this.addTags()).add("RemoveTags", this.removeTags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ProviderName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
            case "AddTags": {
                return Optional.ofNullable(clazz.cast(this.addTags()));
            }
            case "RemoveTags": {
                return Optional.ofNullable(clazz.cast(this.removeTags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePortfolioRequest, T> g) {
        return obj -> g.apply((UpdatePortfolioRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String id;
        private String displayName;
        private String description;
        private String providerName;
        private List<Tag> addTags = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePortfolioRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.id(model.id);
            this.displayName(model.displayName);
            this.description(model.description);
            this.providerName(model.providerName);
            this.addTags(model.addTags);
            this.removeTags(model.removeTags);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final Collection<Tag.Builder> getAddTags() {
            return this.addTags != null ? (Collection)this.addTags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addTags(Collection<Tag> addTags) {
            this.addTags = AddTagsCopier.copy(addTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Tag ... addTags) {
            this.addTags(Arrays.asList(addTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Consumer<Tag.Builder> ... addTags) {
            this.addTags(Stream.of(addTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAddTags(Collection<Tag.BuilderImpl> addTags) {
            this.addTags = AddTagsCopier.copyFromBuilder(addTags);
        }

        public final Collection<String> getRemoveTags() {
            return this.removeTags;
        }

        @Override
        public final Builder removeTags(Collection<String> removeTags) {
            this.removeTags = TagKeysCopier.copy(removeTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeTags(String ... removeTags) {
            this.removeTags(Arrays.asList(removeTags));
            return this;
        }

        public final void setRemoveTags(Collection<String> removeTags) {
            this.removeTags = TagKeysCopier.copy(removeTags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePortfolioRequest build() {
            return new UpdatePortfolioRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePortfolioRequest> {
        public Builder acceptLanguage(String var1);

        public Builder id(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder providerName(String var1);

        public Builder addTags(Collection<Tag> var1);

        public Builder addTags(Tag ... var1);

        public Builder addTags(Consumer<Tag.Builder> ... var1);

        public Builder removeTags(Collection<String> var1);

        public Builder removeTags(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

