/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.PortfolioShareType;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAcceptedPortfolioSharesRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, ListAcceptedPortfolioSharesRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListAcceptedPortfolioSharesRequest.getter(ListAcceptedPortfolioSharesRequest::acceptLanguage)).setter(ListAcceptedPortfolioSharesRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListAcceptedPortfolioSharesRequest.getter(ListAcceptedPortfolioSharesRequest::pageToken)).setter(ListAcceptedPortfolioSharesRequest.setter(Builder::pageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListAcceptedPortfolioSharesRequest.getter(ListAcceptedPortfolioSharesRequest::pageSize)).setter(ListAcceptedPortfolioSharesRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final SdkField<String> PORTFOLIO_SHARE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListAcceptedPortfolioSharesRequest.getter(ListAcceptedPortfolioSharesRequest::portfolioShareTypeAsString)).setter(ListAcceptedPortfolioSharesRequest.setter(Builder::portfolioShareType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioShareType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, PAGE_TOKEN_FIELD, PAGE_SIZE_FIELD, PORTFOLIO_SHARE_TYPE_FIELD));
    private final String acceptLanguage;
    private final String pageToken;
    private final Integer pageSize;
    private final String portfolioShareType;

    private ListAcceptedPortfolioSharesRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.pageToken = builder.pageToken;
        this.pageSize = builder.pageSize;
        this.portfolioShareType = builder.portfolioShareType;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String pageToken() {
        return this.pageToken;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public PortfolioShareType portfolioShareType() {
        return PortfolioShareType.fromValue(this.portfolioShareType);
    }

    public String portfolioShareTypeAsString() {
        return this.portfolioShareType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.portfolioShareTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAcceptedPortfolioSharesRequest)) {
            return false;
        }
        ListAcceptedPortfolioSharesRequest other = (ListAcceptedPortfolioSharesRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.pageToken(), other.pageToken()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.portfolioShareTypeAsString(), other.portfolioShareTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"ListAcceptedPortfolioSharesRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("PageToken", (Object)this.pageToken()).add("PageSize", (Object)this.pageSize()).add("PortfolioShareType", (Object)this.portfolioShareTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "PageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "PortfolioShareType": {
                return Optional.ofNullable(clazz.cast(this.portfolioShareTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAcceptedPortfolioSharesRequest, T> g) {
        return obj -> g.apply((ListAcceptedPortfolioSharesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String pageToken;
        private Integer pageSize;
        private String portfolioShareType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAcceptedPortfolioSharesRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.pageToken(model.pageToken);
            this.pageSize(model.pageSize);
            this.portfolioShareType(model.portfolioShareType);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getPortfolioShareType() {
            return this.portfolioShareType;
        }

        @Override
        public final Builder portfolioShareType(String portfolioShareType) {
            this.portfolioShareType = portfolioShareType;
            return this;
        }

        @Override
        public final Builder portfolioShareType(PortfolioShareType portfolioShareType) {
            this.portfolioShareType(portfolioShareType == null ? null : portfolioShareType.toString());
            return this;
        }

        public final void setPortfolioShareType(String portfolioShareType) {
            this.portfolioShareType = portfolioShareType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAcceptedPortfolioSharesRequest build() {
            return new ListAcceptedPortfolioSharesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAcceptedPortfolioSharesRequest> {
        public Builder acceptLanguage(String var1);

        public Builder pageToken(String var1);

        public Builder pageSize(Integer var1);

        public Builder portfolioShareType(String var1);

        public Builder portfolioShareType(PortfolioShareType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

