/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ExecutionParameter;
import software.amazon.awssdk.services.servicecatalog.model.ExecutionParametersCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeServiceActionExecutionParametersResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, DescribeServiceActionExecutionParametersResponse> {
    private static final SdkField<List<ExecutionParameter>> SERVICE_ACTION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeServiceActionExecutionParametersResponse.getter(DescribeServiceActionExecutionParametersResponse::serviceActionParameters)).setter(DescribeServiceActionExecutionParametersResponse.setter(Builder::serviceActionParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceActionParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExecutionParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACTION_PARAMETERS_FIELD));
    private final List<ExecutionParameter> serviceActionParameters;

    private DescribeServiceActionExecutionParametersResponse(BuilderImpl builder) {
        super(builder);
        this.serviceActionParameters = builder.serviceActionParameters;
    }

    public List<ExecutionParameter> serviceActionParameters() {
        return this.serviceActionParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceActionParameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceActionExecutionParametersResponse)) {
            return false;
        }
        DescribeServiceActionExecutionParametersResponse other = (DescribeServiceActionExecutionParametersResponse)((Object)obj);
        return Objects.equals(this.serviceActionParameters(), other.serviceActionParameters());
    }

    public String toString() {
        return ToString.builder((String)"DescribeServiceActionExecutionParametersResponse").add("ServiceActionParameters", this.serviceActionParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceActionParameters": {
                return Optional.ofNullable(clazz.cast(this.serviceActionParameters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceActionExecutionParametersResponse, T> g) {
        return obj -> g.apply((DescribeServiceActionExecutionParametersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<ExecutionParameter> serviceActionParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceActionExecutionParametersResponse model) {
            super(model);
            this.serviceActionParameters(model.serviceActionParameters);
        }

        public final Collection<ExecutionParameter.Builder> getServiceActionParameters() {
            return this.serviceActionParameters != null ? (Collection)this.serviceActionParameters.stream().map(ExecutionParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceActionParameters(Collection<ExecutionParameter> serviceActionParameters) {
            this.serviceActionParameters = ExecutionParametersCopier.copy(serviceActionParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceActionParameters(ExecutionParameter ... serviceActionParameters) {
            this.serviceActionParameters(Arrays.asList(serviceActionParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceActionParameters(Consumer<ExecutionParameter.Builder> ... serviceActionParameters) {
            this.serviceActionParameters(Stream.of(serviceActionParameters).map(c -> (ExecutionParameter)((ExecutionParameter.Builder)ExecutionParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceActionParameters(Collection<ExecutionParameter.BuilderImpl> serviceActionParameters) {
            this.serviceActionParameters = ExecutionParametersCopier.copyFromBuilder(serviceActionParameters);
        }

        @Override
        public DescribeServiceActionExecutionParametersResponse build() {
            return new DescribeServiceActionExecutionParametersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeServiceActionExecutionParametersResponse> {
        public Builder serviceActionParameters(Collection<ExecutionParameter> var1);

        public Builder serviceActionParameters(ExecutionParameter ... var1);

        public Builder serviceActionParameters(Consumer<ExecutionParameter.Builder> ... var1);
    }
}

