/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse;

public class ListOrganizationPortfolioAccessPublisher
implements SdkPublisher<ListOrganizationPortfolioAccessResponse> {
    private final ServiceCatalogAsyncClient client;
    private final ListOrganizationPortfolioAccessRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOrganizationPortfolioAccessPublisher(ServiceCatalogAsyncClient client, ListOrganizationPortfolioAccessRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOrganizationPortfolioAccessPublisher(ServiceCatalogAsyncClient client, ListOrganizationPortfolioAccessRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOrganizationPortfolioAccessResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOrganizationPortfolioAccessResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListOrganizationPortfolioAccessPublisher resume(ListOrganizationPortfolioAccessResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListOrganizationPortfolioAccessPublisher(this.client, (ListOrganizationPortfolioAccessRequest)((Object)this.firstRequest.toBuilder().pageToken(lastSuccessfulPage.nextPageToken()).build()));
        }
        return new ListOrganizationPortfolioAccessPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListOrganizationPortfolioAccessResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListOrganizationPortfolioAccessResponseFetcher
    implements AsyncPageFetcher<ListOrganizationPortfolioAccessResponse> {
        private ListOrganizationPortfolioAccessResponseFetcher() {
        }

        public boolean hasNextPage(ListOrganizationPortfolioAccessResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<ListOrganizationPortfolioAccessResponse> nextPage(ListOrganizationPortfolioAccessResponse previousPage) {
            if (previousPage == null) {
                return ListOrganizationPortfolioAccessPublisher.this.client.listOrganizationPortfolioAccess(ListOrganizationPortfolioAccessPublisher.this.firstRequest);
            }
            return ListOrganizationPortfolioAccessPublisher.this.client.listOrganizationPortfolioAccess((ListOrganizationPortfolioAccessRequest)((Object)ListOrganizationPortfolioAccessPublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

