/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SearchProductsRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCEPTLANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AcceptLanguage").isBinary(false).build();
    private static final MarshallingInfo<Map> FILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Filters").isBinary(false).build();
    private static final MarshallingInfo<Integer> PAGESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageSize").isBinary(false).build();
    private static final MarshallingInfo<String> SORTBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SortBy").isBinary(false).build();
    private static final MarshallingInfo<String> SORTORDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SortOrder").isBinary(false).build();
    private static final MarshallingInfo<String> PAGETOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageToken").isBinary(false).build();
    private static final SearchProductsRequestModelMarshaller INSTANCE = new SearchProductsRequestModelMarshaller();

    private SearchProductsRequestModelMarshaller() {
    }

    public static SearchProductsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SearchProductsRequest searchProductsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)searchProductsRequest), (String)"searchProductsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)searchProductsRequest.acceptLanguage(), ACCEPTLANGUAGE_BINDING);
            protocolMarshaller.marshall(searchProductsRequest.filtersStrings(), FILTERS_BINDING);
            protocolMarshaller.marshall((Object)searchProductsRequest.pageSize(), PAGESIZE_BINDING);
            protocolMarshaller.marshall((Object)searchProductsRequest.sortByString(), SORTBY_BINDING);
            protocolMarshaller.marshall((Object)searchProductsRequest.sortOrderString(), SORTORDER_BINDING);
            protocolMarshaller.marshall((Object)searchProductsRequest.pageToken(), PAGETOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

