/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListRecordHistoryRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCEPTLANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AcceptLanguage").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ACCESSLEVELFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessLevelFilter").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SEARCHFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SearchFilter").isBinary(false).build();
    private static final MarshallingInfo<Integer> PAGESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageSize").isBinary(false).build();
    private static final MarshallingInfo<String> PAGETOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageToken").isBinary(false).build();
    private static final ListRecordHistoryRequestModelMarshaller INSTANCE = new ListRecordHistoryRequestModelMarshaller();

    private ListRecordHistoryRequestModelMarshaller() {
    }

    public static ListRecordHistoryRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListRecordHistoryRequest listRecordHistoryRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listRecordHistoryRequest), (String)"listRecordHistoryRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listRecordHistoryRequest.acceptLanguage(), ACCEPTLANGUAGE_BINDING);
            protocolMarshaller.marshall((Object)listRecordHistoryRequest.accessLevelFilter(), ACCESSLEVELFILTER_BINDING);
            protocolMarshaller.marshall((Object)listRecordHistoryRequest.searchFilter(), SEARCHFILTER_BINDING);
            protocolMarshaller.marshall((Object)listRecordHistoryRequest.pageSize(), PAGESIZE_BINDING);
            protocolMarshaller.marshall((Object)listRecordHistoryRequest.pageToken(), PAGETOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

